<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>"  dir="<?php echo e(app()->getLocale() === 'ar' ? 'rtl' : 'ltr'); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<title><?php echo e($title ?? config('app.name', 'Protpost')); ?></title>
 <link rel="icon" type="image/svg+xml" href="/favicon.ico" media="(prefers-color-scheme: light)" />
        <link rel="icon" type="image/svg+xml" href="/favicon.ico" media="(prefers-color-scheme: dark)" />
        <!-- Fonts -->
        <link rel="stylesheet" href="/build/assets/ed455474e0b11244.css" data-precedence="next">
        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')([ 'resources/js/app.js']); ?>
      <script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>
      <style>
        /* تحسين التمرير */
.overflow-y-auto::-webkit-scrollbar {
    width: 6px;
}
.border-b {
    border-bottom-style: groove;
    border-bottom-width: 1px;
}
.overflow-y-auto::-webkit-scrollbar-track {
    background: rgb(243, 244, 246);
    border-radius: 3px;
}

.overflow-y-auto::-webkit-scrollbar-thumb {
    background: rgb(156, 163, 175);
    border-radius: 3px;
}

.overflow-y-auto::-webkit-scrollbar-thumb:hover {
    background: rgb(107, 114, 128);
}
    </style>
     <!--  
 برمجة وتصميم عمر محمد
 https://wa.me/249100858093
 omar@rompure.com
 https://x.com/omar_m7a
 -->
    </head>
<body class="font-sans __variable_fb8f2c __variable_f910ec">
 <div class="flex h-screen bg-muted/30 overflow-hidden">
   
 <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

 <!-- end desktop sidebar -->
<div class="flex-1 flex flex-col min-w-0 overflow-hidden">
    
 <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
  <main class="flex-1 overflow-y-auto">

       <div class="max-w-[1200px] mx-auto">

        <div class="space-y-4 sm:space-y-6">
      <?php echo e($slot); ?>

        </div>
      </div>
    </main>


  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const htmlDir = document.documentElement.getAttribute('dir') || 'ltr';
    const isRTL = htmlDir.toLowerCase() === 'rtl';

    // زر فتح القائمة (أيقونة menu)
    const openBtn = document.querySelector('button.lg\\:hidden');
    // زر غلق القائمة (أيقونة x داخل السايدبار)
    const closeBtn = document.querySelector('.fixed .lucide-x')?.closest('button');
    // عنصر السايدبار
    const sidebar = document.querySelector('.fixed.inset-y-0');

    if (!sidebar) return;

    // تحديد الجهة حسب الاتجاه
    const sideClass = isRTL ? 'right-0' : 'left-0';
    const oppositeTranslate = isRTL ? 'translate-x-full' : '-translate-x-full';

    // تأكد من وجود الجهة الصحيحة في العنصر
    sidebar.classList.add(sideClass);
    sidebar.classList.add(oppositeTranslate);

    if (openBtn) {
        openBtn.addEventListener('click', function () {
            sidebar.classList.remove(oppositeTranslate);
            sidebar.classList.add('translate-x-0');
        });
    }

    if (closeBtn) {
        closeBtn.addEventListener('click', function () {
            sidebar.classList.remove('translate-x-0');
            sidebar.classList.add(oppositeTranslate);
        });
    }
});
</script>

        <script>
    function updateModeIcon() {
        const isDark = document.documentElement.classList.contains('dark');
        document.getElementById('sunIcon').style.display = isDark ? 'inline' : 'none';
        document.getElementById('moonIcon').style.display = isDark ? 'none' : 'inline';
    }

    document.getElementById('toggleModeBtn').onclick = function() {
        const html = document.documentElement;
        let mode;
        if (html.classList.contains('dark')) {
            html.classList.remove('dark');
            html.classList.add('light');
            html.style.colorScheme = 'light';
            mode = 'light';
        } else {
            html.classList.remove('light');
            html.classList.add('dark');
            html.style.colorScheme = 'dark';
            mode = 'dark';
        }
        localStorage.setItem('colorMode', mode);
        updateModeIcon();
        // حفظ الوضع في قاعدة البيانات إذا كان المستخدم مسجلاً الدخول
        if (window.laravelUserId) {
            fetch("<?php echo e(url('/profile/color-mode')); ?>", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ color_mode: mode })
            });
        }
    };
    </script>
<script>
    // تعريف متغير laravelUserId إذا كان المستخدم مسجلاً الدخول
    window.laravelUserId = <?php echo auth()->check() ? json_encode(auth()->id()) : 'null'; ?>;
    window.laravelUserColorMode = <?php echo auth()->check() ? json_encode(auth()->user()->color_mode) : 'null'; ?>;

    // Initialize mode and icon on page load
    document.addEventListener('DOMContentLoaded', function() {
        let savedMode = localStorage.getItem('colorMode');
        const html = document.documentElement;
        // إذا كان المستخدم مسجلاً الدخول، استخدم وضعه من قاعدة البيانات
        if (window.laravelUserId && window.laravelUserColorMode) {
            savedMode = window.laravelUserColorMode;
        }
        if (savedMode === 'dark') {
            html.classList.remove('light');
            html.classList.add('dark');
            html.style.colorScheme = 'dark';
        } else if (savedMode === 'light') {
            html.classList.remove('dark');
            html.classList.add('light');
            html.style.colorScheme = 'light';
        }
        updateModeIcon();
    });
</script>
    <?php echo $__env->make('components.impersonate-banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </body>
    
</html>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>