<?php if (isset($component)) { $__componentOriginal69dc84650370d1d4dc1b42d016d7226b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal69dc84650370d1d4dc1b42d016d7226b = $attributes; } ?>
<?php $component = App\View\Components\GuestLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('guest-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\GuestLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
 <?php $__env->slot('title', null, []); ?>  Mujeep -مجيب للرد الالي على التعليقات والمحادثات  <?php $__env->endSlot(); ?>
 <?php $__env->slot('url', null, []); ?> https://Mujeep.app <?php $__env->endSlot(); ?>
<body class="bg-background text-foreground antialiased">

<?php echo $__env->make('components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- ========== قسم Hero ========== -->
    <section class="pt-32 pb-20 px-6 overflow-hidden relative">
        <!-- خلفية متحركة -->
        <div class="absolute inset-0 -z-10">
            <div class="absolute top-20 right-1/4 w-72 h-72 bg-primary/10 rounded-full blur-3xl"></div>
            <div class="absolute bottom-20 left-1/4 w-96 h-96 bg-purple-500/10 rounded-full blur-3xl"></div>
        </div>
        
        <div class="max-w-7xl mx-auto">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <!-- المحتوى النصي -->
                <div class="text-center lg:text-right fade-in-up">
                    <!-- شارة جديدة -->
                    <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold mb-6">
                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        بوت الرد التلقائي على التعليقات
                    </div>
                    
                    <h1 class="text-5xl md:text-6xl lg:text-7xl font-black mb-6 leading-tight">
                        <span class="gradient-text">نظام الرد الالي</span><br/>
                        <span class="text-foreground">للتعليقات والمنشورات </span>
                    </h1>
                    
                    <p class="text-xl md:text-2xl text-muted-foreground mb-8 leading-relaxed max-w-2xl mx-auto lg:mx-0">
                        وفّر ساعات من العمل اليومي مع نظام الردود التلقائية، جدولة المنشورات، والتحليلات الشاملة لفيسبوك وإنستقرام
                    </p>
                    
                    <!-- أزرار الإجراء -->
                    <div class="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start mb-8">
                        <a href="<?php echo e(route('register')); ?>" class="group inline-flex items-center justify-center gap-3 px-8 py-4 rounded-xl text-lg font-bold bg-primary text-primary-foreground shadow-2xl hover:shadow-primary/50 hover:scale-105 transition-all">
                            تسجيل حساب
                            <svg class="w-5 h-5 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                            </svg>
                        </a>
                        <a href="#demo" class="inline-flex items-center justify-center gap-3 px-8 py-4 rounded-xl text-lg font-bold bg-secondary text-secondary-foreground hover:bg-accent transition-all border-2 border-border">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z"/>
                            </svg>
                            شاهد العرض التوضيحي
                        </a>
                    </div>
                    
                    <!-- إحصائيات سريعة -->
                    <div class="grid grid-cols-3 gap-6 max-w-lg mx-auto lg:mx-0">
                        <div class="text-center lg:text-right">
                            <div class="text-3xl font-black text-primary mb-1">+600</div>
                            <div class="text-sm text-muted-foreground">مستخدم نشط</div>
                        </div>
                        <div class="text-center lg:text-right">
                            <div class="text-3xl font-black text-primary mb-1">99%</div>
                            <div class="text-sm text-muted-foreground">رضا العملاء</div>
                        </div>
                        <div class="text-center lg:text-right">
                            <div class="text-3xl font-black text-primary mb-1">24/7</div>
                            <div class="text-sm text-muted-foreground">دعم فني</div>
                        </div>
                    </div>
                </div>
                
                <!-- معاينة التطبيق -->
                <div class="relative float-animation">
                    <!-- نافذة براوزر -->
                    <div class="relative bg-gradient-to-br from-card to-muted rounded-2xl shadow-2xl border-2 border-border p-6">
                        <!-- شريط العنوان -->
                        <div class="flex items-center gap-2 mb-4">
                            <div class="w-3 h-3 bg-red-500 rounded-full"></div>
                            <div class="w-3 h-3 bg-yellow-500 rounded-full"></div>
                            <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                        </div>
                        
                        <!-- محتوى الداشبورد -->
                        <div class="bg-background rounded-xl overflow-hidden shadow-lg">
                            <img src="img/ultravo.webp" alt="لوحة التحكم" class="w-full h-auto object-cover"/>
                        </div>
                    </div>
                    
                    <!-- كارت متحرك - فيسبوك -->
                    <div class="absolute -top-6 -left-6 bg-card rounded-2xl shadow-2xl border border-border p-4 hover:scale-110 transition-transform">
                        <div class="flex items-center gap-3">
                            <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </div>
                            <div>
                                <div class="text-sm font-bold">متصل بفيسبوك</div>
                                <div class="text-xs text-muted-foreground">5 صفحات نشطة</div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- كارت متحرك - إنستقرام -->
                    <div class="absolute -bottom-6 -right-6 bg-card rounded-2xl shadow-2xl border border-border p-4 hover:scale-110 transition-transform">
                        <div class="flex items-center gap-3">
                            <div class="w-12 h-12 bg-gradient-to-br from-purple-500 via-pink-500 to-orange-500 rounded-full flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </div>
                            <div>
                                <div class="text-sm font-bold">الردود التلقائية</div>
                                <div class="text-xs text-muted-foreground">نشطة الآن</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ========== قسم المميزات ========== -->
    <section id="features" class="py-24 px-6 bg-muted/30">
        <div class="max-w-7xl mx-auto">
            <!-- العنوان -->
            <div class="text-center mb-16 fade-in-up">
                <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold mb-4">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    المميزات القوية
                </div>
                <h2 class="text-4xl md:text-5xl font-black text-foreground mb-4">
                    مجيب هو كل ما تحتاجه
                </h2>
                <p class="text-xl text-muted-foreground max-w-3xl mx-auto">
                   نشر وجدولة المنشورات والرد على التعيقات من مكان واحد
                </p>
            </div>

            <!-- شبكة المميزات -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <!-- ميزة 1: الردود التلقائية -->
                <div class="group bg-card rounded-2xl p-8 border-2 border-border hover:border-primary hover:shadow-2xl transition-all duration-300">
                    <div class="w-14 h-14 bg-gradient-to-br from-primary to-green-600 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3">الردود التلقائية على التعليقات</h3>
                    <p class="text-muted-foreground leading-relaxed mb-4">
                        رد تلقائي فوري على جميع التعليقات مع إمكانية تخصيص الردود لكل منشور وإرسال رسائل خاصة
                    </p>
                    <ul class="space-y-2 text-sm">
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            ردود مخصصة لكل منشور
                        </li>
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            إرسال رسائل خاصة تلقائية
                        </li>
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            الرد على تعليقات فيسبوك وانستقرام
                        </li>
                    </ul>
                </div>

                <!-- ميزة 2: الجدولة الذكية -->
                <div class="group bg-card rounded-2xl p-8 border-2 border-border hover:border-primary hover:shadow-2xl transition-all duration-300">
                    <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3">جدولة ذكية للمنشورات</h3>
                    <p class="text-muted-foreground leading-relaxed mb-4">
                        انشر على فيسبوك وإنستقرام في الوقت المثالي مع دعم الصور والفيديوهات والريلز والستوريز
                    </p>
                    <ul class="space-y-2 text-sm">
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            نشر متعدد لكل الحسابات
                        </li>
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            دعم كامل للريلز والستوريز
                        </li>
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            جدولة حسب التوقيت المحلي
                        </li>
                    </ul>
                </div>

                <!-- ميزة 3: التحليلات الشاملة -->
                <div class="group bg-card rounded-2xl p-8 border-2 border-border hover:border-primary hover:shadow-2xl transition-all duration-300">
                    <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-emerald-500 rounded-2xl flex items-center justify-center mb-6 group-hover:scale-110 transition-transform shadow-lg">
                        <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-bold mb-3">تحليلات وإحصائيات شاملة</h3>
                    <p class="text-muted-foreground leading-relaxed mb-4">
                        راقب أداء منشوراتك بتقارير تفصيلية عن الإعجابات والتعليقات والمشاركات والوصول
                    </p>
                    <ul class="space-y-2 text-sm">
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            تقارير أداء تفصيلية
                        </li>
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            تتبع معدل التفاعل
                        </li>
                        <li class="flex items-center gap-2 text-muted-foreground">
                            <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                            </svg>
                            رسوم بيانية توضيحية
                        </li>
                    </ul>
                </div>

            </div>
        </div>
    </section>
<!-- ========== قسم التوضيح بنصفين ==========
ضع هذا القسم أسفل "شهادات العملاء" وقبل الـCTA النهائي -->
<section id="feature-explain" class="py-24 px-6">
  <div class="max-w-7xl mx-auto space-y-24">

    <!-- كتلة 1: كتابة يسار / صورة يمين في RTL -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center" dir="ltr">
      <div class="relative lg:order-first">
        <!-- خلفية زخرفية -->
        <div class="absolute -inset-6 bg-gradient-to-br from-primary/10 via-purple-500/10 to-primary/10 blur-2xl rounded-3xl" aria-hidden="true"></div>
        <div class="relative bg-card border-2 border-border rounded-3xl shadow-2xl p-4">
          <img
            src="/img/DASHBO.webp"
            alt="معاينة تقويم الجدولة مع أوقات نشر مثالية على فيسبوك وإنستقرام"
            loading="lazy"
            class="w-full h-auto rounded-2xl"
          />
        </div>
      </div>
      <!-- النص -->
      <div  dir="rtl">
        <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold">
          ⚡ جدولة بلا مجهود
        </span>
        <h3 class="mt-4 text-4xl md:text-5xl font-black text-foreground">
          خطط المحتوى مرة، ودع النظام ينشر في الوقت المثالي
        </h3>
        <p class="mt-4 text-lg md:text-xl text-muted-foreground leading-relaxed">
          صمّم تقويماً أسبوعياً أو شهرياً للصور والفيديو والريلز والستوريز، ثم اترك النظام يختار أفضل توقيت للنشر حسب منطقة الجمهور وتاريخ الأداء.
        </p>
        <ul class="mt-6 space-y-3 text-muted-foreground">
          <li class="flex items-center gap-2"><span class="text-primary">✓</span> نشر متزامن لصفحات فيسبوك وحسابات إنستقرام</li>
          <li class="flex items-center gap-2"><span class="text-primary">✓</span> واجه خفيفه وسهلة للنشر والجدولة</li>
          <li class="flex items-center gap-2"><span class="text-primary">✓</span> تحكم كامل بالتوقيت المحلي وتكرار النشر</li>
        </ul>
        <div class="mt-8 flex items-center gap-4">
          <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center gap-2 px-6 py-3 rounded-xl bg-primary text-primary-foreground font-bold hover:bg-primary/90 transition">
            ابدأ في استخدام المنصة
          </a>
          <a href="#demo" class="inline-flex items-center gap-2 px-6 py-3 rounded-xl border-2 border-border bg-secondary text-secondary-foreground font-bold hover:bg-accent transition">
            شاهد العرض التوضيحي
          </a>
        </div>
      </div>

      <!-- الصورة -->
      
    </div>

    <!-- كتلة 2: صورة يسار / كتابة يمين في RTL -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
      <!-- الصورة -->
      <div class="relative">
        <div class="absolute -inset-6 bg-gradient-to-br from-emerald-500/10 via-green-500/10 to-primary/10 blur-2xl rounded-3xl" aria-hidden="true"></div>
        <div class="relative bg-card border-2 border-border rounded-3xl shadow-2xl p-4">
          <img
            src="/img/auto-replies.webp"
            alt="معاينة بوت رد تلقائي فيسبوك و بوت انستقرام الرد التلقائي"
            loading="lazy"
            class="w-full h-auto rounded-2xl"
          />
        </div>
      </div>

      <!-- النص -->
      <div>
        <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold">
          📈 عزز التفاعل بالردود التلقائية
        </span>
        <h3 class="mt-4 text-4xl md:text-5xl font-black text-foreground">
          الرد التلقائي على التعليقات مع ارسال رسالة خاصة
        </h3>
        <p class="mt-4 text-lg md:text-xl text-muted-foreground leading-relaxed">
              انشي ردود تلقائية على تعليقات فيسبوك وانستقرام لزيادة التفاعل، رفع نسبة الوصول، وتقليل تكلفة الإعلانات المدفوعة.
        </p>
        <ul class="mt-6 space-y-3 text-muted-foreground">
          <li class="flex items-center gap-2"><span class="text-primary">✓</span> الرد الفوري على التعليق وارسال رسالة خاصة</li>
          <li class="flex items-center gap-2"><span class="text-primary">✓</span> رد شامل لكل المنشورات او ردود مخصصة لكل منشور</li>
          <li class="flex items-center gap-2"><span class="text-primary">✓</span> ادخال وتعديل الردود بشكل مرن وسهل</li>
        </ul>
        <div class="mt-8 flex items-center gap-4">
          <a href="#pricing" class="inline-flex items-center gap-2 px-6 py-3 rounded-xl bg-primary text-primary-foreground font-bold hover:bg-primary/90 transition">
            اطّلع على الباقات
          </a>
          <a href="#features" class="inline-flex items-center gap-2 px-6 py-3 rounded-xl border-2 border-border bg-secondary text-secondary-foreground font-bold hover:bg-accent transition">
            جميع المميزات
          </a>
        </div>
      </div>
    </div>
 <!-- كتلة 1: كتابة يسار / صورة يمين في RTL -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center" dir="ltr">
      <div class="relative lg:order-first">
        <!-- خلفية زخرفية -->
        <div class="absolute -inset-6 bg-gradient-to-br from-primary/10 via-purple-500/10 to-primary/10 blur-2xl rounded-3xl" aria-hidden="true"></div>
        <div class="relative bg-card border-2 border-border rounded-3xl shadow-2xl p-4">
          <img
            src="/img/igchatbot.webp"
            alt="معاينة تقويم الجدولة مع أوقات نشر مثالية على فيسبوك وإنستقرام"
            loading="lazy"
            class="w-full h-auto rounded-2xl"
          />
        </div>
      </div>
      <!-- النص -->
      <div dir="rtl">
  <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold">
    بوت إنستقرام DM
  </span>
  <h3 class="mt-4 text-4xl md:text-5xl font-black text-foreground">
    رد تلقائي ذكي على رسائل إنستقرام الخاصة على مدار الساعة
  </h3>
  <p class="mt-4 text-lg md:text-xl text-muted-foreground leading-relaxed">
    أنشئ بوت متكامل يرد على رسائل العملاء عبر الخاص في إنستقرام بشكل فوري واحترافي، لتحافظ على تفاعل دائم حتى أثناء غيابك.
  </p>
  <ul class="mt-6 space-y-3 text-muted-foreground">
    <li class="flex items-center gap-2"><span class="text-primary">✓</span> الرد على آلاف الرسائل في وقت واحد</li>
    <li class="flex items-center gap-2"><span class="text-primary">✓</span> يدعم الأزرار التفاعلية والنصوص الذكية</li>
    <li class="flex items-center gap-2"><span class="text-primary">✓</span> سجل كامل لتتبع المحادثات وردود البوت</li>
        <li class="flex items-center gap-2"><span class="text-primary">✓</span>تخصيص الردود حسب الكلمات المفتاحية والسياق
</li>

  </ul>
  <div class="mt-8 flex items-center gap-4">
    <a href="<?php echo e(route('register')); ?>" class="inline-flex items-center gap-2 px-6 py-3 rounded-xl bg-primary text-primary-foreground font-bold hover:bg-primary/90 transition">
      ابدأ الآن مجانًا
    </a>
    <a href="#demo" class="inline-flex items-center gap-2 px-6 py-3 rounded-xl border-2 border-border bg-secondary text-secondary-foreground font-bold hover:bg-accent transition">
      شاهد العرض التوضيحي
    </a>
  </div>
</div>

  </div>
</section>

 <script src="//unpkg.com/alpinejs" defer></script>
<section id="pricing" class="py-24 px-6" x-data="{ billing: 'monthly' }">
    <div class="max-w-7xl mx-auto">
        <!-- العنوان -->
        <div class="text-center mb-16">
            <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold mb-4">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                الباقات والأسعار
            </div>
            <h2 class="text-4xl md:text-5xl font-black text-foreground mb-4">
                اختر الباقة المناسبة لك
            </h2>
            <p class="text-xl text-muted-foreground max-w-3xl mx-auto">
                باقات مرنة تناسب جميع الأحجام من الأفراد إلى الشركات الكبرى
            </p>
        </div>

        <!-- زر التبديل بين الشهري والسنوي -->
        <div class="flex justify-center items-center gap-4 mb-16" dir="ltr">
            <span class="font-semibold" :class="billing === 'monthly' ? 'text-primary' : 'text-muted-foreground'">شهرياً</span>
            <div @click="billing = (billing === 'monthly' ? 'yearly' : 'monthly')" class="relative w-14 h-8 bg-card rounded-full cursor-pointer border border-border flex items-center transition-all duration-300">
                <div class="w-6 h-6 bg-primary rounded-full absolute transition-all duration-300" :class="{ 'translate-x-1': billing === 'monthly', 'translate-x-7': billing === 'yearly' }"></div>
            </div>
            <span class="font-semibold" :class="billing === 'yearly' ? 'text-primary' : 'text-muted-foreground'">
                سنوياً
                <span class="text-xs text-primary bg-primary/10 rounded-full px-2 py-1 mr-1" dir="rtl">وفر 33%</span>
            </span>
        </div>

        <!-- شبكة الأسعار -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-6xl mx-auto">
            <!-- باقة الأساسية -->
            <div class="bg-card rounded-2xl border-2 border-border p-8 hover:shadow-2xl transition-all duration-300 hover:scale-105">
                <div class="text-center mb-6">
                    <div class="w-16 h-16 bg-gradient-to-br from-gray-400 to-gray-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-black mb-2">الباقة الأساسية</h3>
                    <p class="text-muted-foreground text-sm mb-4">مثالية للأفراد والمشاريع الصغيرة</p>
                    <div class="flex items-baseline justify-center gap-2">
                        <span class="text-5xl font-black" x-text="billing === 'monthly' ? '$5' : '$40'">$5</span>
                        <span class="text-muted-foreground" x-text="billing === 'monthly' ? '/ شهرياً' : '/ سنوياً'">/ شهرياً</span>
                    </div>
                </div>
                
                <ul class="space-y-3 mb-8">
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>حساب فيسبوك واحد</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>2 صفحات فيسبوك</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>حساب إنستقرام واحد</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>60 رد تلقائي لكل منصة</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>60 منشور لكل منصة</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>دعم أساسي</span>
                    </li>
                </ul>
                
                <a :href="billing === 'monthly' ? '/plans/13/checkout' : '/plans/16/checkout'" class="block w-full text-center px-6 py-3 rounded-xl text-sm font-bold bg-secondary text-secondary-foreground hover:bg-accent transition-all border-2 border-border">
                    ابدأ الآن
                </a>
            </div>

            <!-- باقة الذهبية - مميزة -->
            <div class="relative bg-gradient-to-br from-primary to-green-600 rounded-2xl p-8 hover:shadow-2xl transition-all duration-300 hover:scale-105">
                <!-- شارة الأكثر شعبية -->
                <div class="absolute -top-4 left-1/2 -translate-x-1/2 px-6 py-2 bg-amber-500 text-white rounded-full text-sm font-bold shadow-lg">
                    الأكثر شعبية ⭐
                </div>
                
                <div class="text-center mb-6">
                    <div class="w-16 h-16 bg-white/20 backdrop-blur rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-black text-white mb-2">الباقة الذهبية</h3>
                    <p class="text-white/80 text-sm mb-4">الأفضل للشركات الناشئة</p>
                    <div class="flex items-baseline justify-center gap-2">
                        <span class="text-5xl font-black text-white" x-text="billing === 'monthly' ? '$10' : '$80'">$10</span>
                        <span class="text-white/80" x-text="billing === 'monthly' ? '/ شهرياً' : '/ سنوياً'">/ شهرياً</span>
                    </div>
                </div>
                
                <ul class="space-y-3 mb-8">
                    <li class="flex items-center gap-3 text-sm text-white">
                        <svg class="w-5 h-5 text-white flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>3 حسابات فيسبوك</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-white">
                        <svg class="w-5 h-5 text-white flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>5 صفحة فيسبوك</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-white">
                        <svg class="w-5 h-5 text-white flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>5 حساب إنستقرام</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-white">
                        <svg class="w-5 h-5 text-white flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>ردود تلقائية غير محدودة</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-white">
                        <svg class="w-5 h-5 text-white flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>منشورات غير محدودة</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm text-white">
                        <svg class="w-5 h-5 text-white flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>دعم ذهبي 24/7</span>
                    </li>
                </ul>
                
                <a :href="billing === 'monthly' ? '/plans/14/checkout' : '/plans/17/checkout'" class="block w-full text-center px-6 py-3 rounded-xl text-sm font-bold bg-white text-primary hover:bg-gray-50 transition-all shadow-lg">
                    ابدأ الآن - الأفضل
                </a>
            </div>

            <!-- باقة الماسية -->
            <div class="bg-card rounded-2xl border-2 border-border p-8 hover:shadow-2xl transition-all duration-300 hover:scale-105">
                <div class="text-center mb-6">
                    <div class="w-16 h-16 bg-gradient-to-br from-cyan-400 to-blue-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"/>
                        </svg>
                    </div>
                    <h3 class="text-2xl font-black mb-2">الباقة الماسية</h3>
                    <p class="text-muted-foreground text-sm mb-4">للشركات والمؤسسات الكبرى</p>
                    <div class="flex items-baseline justify-center gap-2">
                        <span class="text-5xl font-black" x-text="billing === 'monthly' ? '$25' : '$199'">$25</span>
                        <span class="text-muted-foreground" x-text="billing === 'monthly' ? '/ شهرياً' : '/ سنوياً'">/ شهرياً</span>
                    </div>
                </div>
                
                <ul class="space-y-3 mb-8">
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>10 حسابات فيسبوك</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>25 صفحة فيسبوك</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>10 حساب إنستقرام</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>ردود تلقائية غير محدودة</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>منشورات غير محدودة</span>
                    </li>
                    <li class="flex items-center gap-3 text-sm">
                        <svg class="w-5 h-5 text-primary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <span>دعم ذهبي 24/7</span>
                    </li>
                </ul>
                
                <a :href="billing === 'monthly' ? '/plans/15/checkout' : '/plans/18/checkout'" class="block w-full text-center px-6 py-3 rounded-xl text-sm font-bold bg-primary text-primary-foreground hover:bg-primary/90 transition-all shadow-lg">
                    ابدأ الآن
                </a>
            </div>
        </div>

        <!-- ملاحظة الضمان -->
        <div class="text-center mt-12">
            <p class="text-muted-foreground">
                <svg class="w-5 h-5 inline-block ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                </svg>
                جميع الباقات تأتي مع ضمان استرداد كامل خلال 7 ايام
            </p>
        </div>
    </div>
</section>

    <!-- ========== قسم آراء العملاء ========== -->
    <section id="testimonials" class="py-24 px-6 bg-muted/30">
        <div class="max-w-7xl mx-auto">
            <!-- العنوان -->
            <div class="text-center mb-16">
                <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold mb-4">
                    <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                    </svg>
                    شهادات العملاء
                </div>
                <h2 class="text-4xl md:text-5xl font-black text-foreground mb-4">
                    ماذا يقول عملاؤنا
                </h2>
                <p class="text-xl text-muted-foreground max-w-3xl mx-auto">
                    انضم إلى آلاف العملاء السعداء الذين حققوا نتائج مذهلة
                </p>
            </div>

            <!-- شبكة الشهادات -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <!-- شهادة 1 -->
                <div class="bg-card rounded-2xl p-8 border-2 border-border hover:shadow-2xl transition-all hover:scale-105">
                    <!-- النجوم -->
                    <div class="flex gap-1 mb-4">
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    </div>
                    
                    <blockquote class="text-muted-foreground mb-6 text-lg leading-relaxed">
                        "منصة Mujeep غيّرت طريقة عملنا بالكامل! وفّرنا ساعات من الوقت يومياً بفضل نظام الردود التلقائية. أصبح التفاعل مع عملائنا أسرع بكثير."
                    </blockquote>
                    
                    <div class="flex items-center gap-4">
                        <div class="w-14 h-14 bg-gradient-to-br from-primary to-green-600 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            أ
                        </div>
                        <div>
                            <div class="font-bold text-lg">أحمد السعيد</div>
                            <div class="text-sm text-muted-foreground">مدير متجر إلكتروني</div>
                        </div>
                    </div>
                </div>

                <!-- شهادة 2 -->
                <div class="bg-card rounded-2xl p-8 border-2 border-border hover:shadow-2xl transition-all hover:scale-105">
                    <div class="flex gap-1 mb-4">
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    </div>
                    
                    <blockquote class="text-muted-foreground mb-6 text-lg leading-relaxed">
                        "التحليلات التي توفرها المنصة ساعدتني في فهم جمهوري بشكل أفضل. ميزة الجدولة التلقائية رائعة، أستطيع إدارة 10 صفحات بكل سهولة!"
                    </blockquote>
                    
                    <div class="flex items-center gap-4">
                        <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-cyan-500 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            م
                        </div>
                        <div>
                            <div class="font-bold text-lg">مريم الخالدي</div>
                            <div class="text-sm text-muted-foreground">مديرة تسويق رقمي</div>
                        </div>
                    </div>
                </div>

                <!-- شهادة 3 -->
                <div class="bg-card rounded-2xl p-8 border-2 border-border hover:shadow-2xl transition-all hover:scale-105">
                    <div class="flex gap-1 mb-4">
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                        <svg class="w-5 h-5 text-amber-400" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/>
                        </svg>
                    </div>
                    
                    <blockquote class="text-muted-foreground mb-6 text-lg leading-relaxed">
                        "دعم العملاء رائع ومتجاوب جداً! المنصة سهلة الاستخدام حتى للمبتدئين. زاد معدل تفاعل صفحاتنا بنسبة 250% خلال شهرين فقط."
                    </blockquote>
                    
                    <div class="flex items-center gap-4">
                        <div class="w-14 h-14 bg-gradient-to-br from-green-500 to-emerald-500 rounded-full flex items-center justify-center text-white font-bold text-xl">
                            خ
                        </div>
                        <div>
                            <div class="font-bold text-lg">خالد المنصور</div>
                            <div class="text-sm text-muted-foreground">رائد أعمال</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!-- ========== قسم الأسئلة الشائعة ========== -->
<section id="faq" class="py-24 px-6 bg-muted/30">
  <div class="max-w-4xl mx-auto">
    <!-- العنوان -->
    <div class="text-center mb-12">
      <span class="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-semibold">
        ❓ الأسئلة الشائعة
      </span>
      <h2 class="text-4xl md:text-5xl font-black text-foreground mt-4">إجابات واضحة قبل البدء</h2>
      <p class="text-xl text-muted-foreground mt-3">كل ما يلزم لمعرفة طريقة العمل، الأسعار، والدعم الفني</p>
    </div>

    <!-- الأكورديون -->
    <div class="rounded-2xl border-2 border-border bg-card divide-y divide-border">
      <!-- بند 1 -->
    
      <!-- بند 2 -->
      <details class="group p-6 open:bg-muted/40 transition-colors">
        <summary class="flex items-center justify-between cursor-pointer select-none">
          <h3 class="text-lg md:text-xl font-bold text-foreground">ما القنوات التي يدعمها الجدولة والنشر؟</h3>
          <svg class="w-6 h-6 text-primary transition-transform group-open:rotate-45" viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v14M5 12h14"/>
          </svg>
        </summary>
        <div class="mt-3 text-muted-foreground leading-relaxed">
          يدعم النشر والجدولة لصفحات فيسبوك وحسابات إنستقرام بمحتوى الصور والفيديو والريلز والستوريز مع احترام التوقيت المحلي.
        </div>
      </details>

      <!-- بند 3 -->
      <details class="group p-6 open:bg-muted/40 transition-colors">
        <summary class="flex items-center justify-between cursor-pointer select-none">
          <h3 class="text-lg md:text-xl font-bold text-foreground">هل الردود التلقائية قابلة للتخصيص؟</h3>
          <svg class="w-6 h-6 text-primary transition-transform group-open:rotate-45" viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v14M5 12h14"/>
          </svg>
        </summary>
        <div class="mt-3 text-muted-foreground leading-relaxed">
          نعم، يمكن إنشاء قوالب متعددة مع كلمات مفتاحية ورسائل خاصة تلقائية ودعم Spintax لتفادي التكرار وتحسين تجربة العملاء.
        </div>
      </details>

      <!-- بند 4 -->
      <details class="group p-6 open:bg-muted/40 transition-colors">
        <summary class="flex items-center justify-between cursor-pointer select-none">
          <h3 class="text-lg md:text-xl font-bold text-foreground">كيف يعمل بوت الرد التلقائي على التعليقات؟</h3>
          <svg class="w-6 h-6 text-primary transition-transform group-open:rotate-45" viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v14M5 12h14"/>
          </svg>
        </summary>
        <div class="mt-3 text-muted-foreground leading-relaxed">
          مجيب عبارة عن برمجة رسمية تتم عبر API من فيسبوك امنة على الحسابات والصفحات 100%
        </div>
      </details>

      <!-- بند 5 -->
      <details class="group p-6 open:bg-muted/40 transition-colors">
        <summary class="flex items-center justify-between cursor-pointer select-none">
          <h3 class="text-lg md:text-xl font-bold text-foreground">ما خيارات الدفع والإلغاء؟</h3>
          <svg class="w-6 h-6 text-primary transition-transform group-open:rotate-45" viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v14M5 12h14"/>
          </svg>
        </summary>
        <div class="mt-3 text-muted-foreground leading-relaxed">
          تتوفر خطط شهرية مرنة مع إمكانية الإلغاء الفوري من الإعدادات، وتستمر الاستفادة حتى نهاية الدورة الحالية.
        </div>
      </details>

      <!-- بند 6 -->
      <details class="group p-6 open:bg-muted/40 transition-colors">
        <summary class="flex items-center justify-between cursor-pointer select-none">
          <h3 class="text-lg md:text-xl font-bold text-foreground">كيف نحمي البيانات والخصوصية؟</h3>
          <svg class="w-6 h-6 text-primary transition-transform group-open:rotate-45" viewBox="0 0 24 24" fill="none" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 5v14M5 12h14"/>
          </svg>
        </summary>
        <div class="mt-3 text-muted-foreground leading-relaxed">
          يتم تخزين البيانات بأمان مع سياسات وصول محددة وتشفير أثناء النقل، مع التزام واضح بسياسة الخصوصية.
        </div>
      </details>
    </div>
  </div>
</section>
 <!--  
 برمجة وتصميم عمر محمد
 https://wa.me/249100858093
 omar@rompure.com
 https://x.com/omar_m7a
 -->
    <!-- ========== قسم CTA النهائي ========== -->
    <section class="py-24 px-6 relative overflow-hidden">
        <!-- خلفية متدرجة -->
        <div class="absolute inset-0 bg-gradient-to-br from-primary via-green-600 to-primary"></div>
        <div class="absolute inset-0 opacity-10" style="background-image: url('data:image/svg+xml,%3Csvg width=\'60\' height=\'60\' viewBox=\'0 0 60 60\' xmlns=\'http://www.w3.org/2000/svg\'%3E%3Cg fill=\'none\' fill-rule=\'evenodd\'%3E%3Cg fill=\'%23ffffff\' fill-opacity=\'1\'%3E%3Cpath d=\'M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z\'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E');"></div>
        
        <div class="max-w-4xl mx-auto text-center relative z-10">
            <h2 class="text-4xl md:text-6xl font-black text-white mb-6">
                ابدأ رحلتك اليوم
            </h2>
            <p class="text-xl md:text-2xl text-white/90 mb-10 leading-relaxed">
                انضم إلى أكثر من 600 مستخدم يديرون حساباتهم بذكاء ويوفرون ساعات من وقتهم يومياً
            </p>
            
            <div class="flex flex-col sm:flex-row gap-4 justify-center items-center mb-8">
                <a href="<?php echo e(route('register')); ?>" class="group inline-flex items-center justify-center gap-3 px-10 py-5 rounded-xl text-lg font-bold bg-white text-primary shadow-2xl hover:scale-105 transition-all">
                    تسجيل حساب الآن
                    <svg class="w-6 h-6 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                    </svg>
                </a>
                <a href="#demo" class="inline-flex items-center justify-center gap-3 px-10 py-5 rounded-xl text-lg font-bold bg-white/10 backdrop-blur text-white border-2 border-white/30 hover:bg-white/20 transition-all">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10 18a8 8 0 100-16 8 8 0 000 16zM9.555 7.168A1 1 0 008 8v4a1 1 0 001.555.832l3-2a1 1 0 000-1.664l-3-2z"/>
                    </svg>
                    شاهد العرض التوضيحي
                </a>
            </div>
            
            <div class="flex items-center justify-center gap-8 text-white">
                <div class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    <span>7 ايام ضمان استرداد</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    <span>إلغاء في أي وقت</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    <span>دعم 24/7</span>
                </div>
            </div>
        </div>
    </section>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "FAQPage",
  "mainEntity": [
   
    {
      "@type": "Question",
      "name": "ما القنوات التي يدعمها الجدولة والنشر؟",
      "acceptedAnswer": { "@type": "Answer", "text": "يدعم النشر والجدولة لصفحات فيسبوك وحسابات إنستقرام بمحتوى الصور والفيديو والريلز والستوريز مع احترام التوقيت المحلي." }
    },
    {
      "@type": "Question",
      "name": "هل الردود التلقائية قابلة للتخصيص؟",
      "acceptedAnswer": { "@type": "Answer", "text": "نعم، يمكن إنشاء قوالب متعددة مع كلمات مفتاحية ورسائل خاصة تلقائية ودعم Spintax لتفادي التكرار وتحسين تجربة العملاء." }
    },
    {
      "@type": "Question",
      "name": "كيف يعمل بوت الرد التلقائي على التعليقات؟",
      "acceptedAnswer": { "@type": "Answer", "text": "مجيب عبارة عن برمجة رسمية تتم عبر API من فيسبوك امنة على الحسابات والصفحات 100%" }
    },
    {
      "@type": "Question",
      "name": "ما خيارات الدفع والإلغاء؟",
      "acceptedAnswer": { "@type": "Answer", "text": "تتوفر خطط شهرية مرنة مع إمكانية الإلغاء الفوري من الإعدادات، وتستمر الاستفادة حتى نهاية الدورة الحالية." }
    },
    {
      "@type": "Question",
      "name": "كيف نحمي البيانات والخصوصية؟",
      "acceptedAnswer": { "@type": "Answer", "text": "يتم تخزين البيانات بأمان مع سياسات وصول محددة وتشفير أثناء النقل، مع التزام واضح بسياسة الخصوصية." }
    }
  ]
}
</script>
  <?php echo $__env->make('components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal69dc84650370d1d4dc1b42d016d7226b)): ?>
<?php $attributes = $__attributesOriginal69dc84650370d1d4dc1b42d016d7226b; ?>
<?php unset($__attributesOriginal69dc84650370d1d4dc1b42d016d7226b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal69dc84650370d1d4dc1b42d016d7226b)): ?>
<?php $component = $__componentOriginal69dc84650370d1d4dc1b42d016d7226b; ?>
<?php unset($__componentOriginal69dc84650370d1d4dc1b42d016d7226b); ?>
<?php endif; ?>

<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/welcome.blade.php ENDPATH**/ ?>