<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> إدارة الباقات <?php $__env->endSlot(); ?>

<div class="p-6 space-y-6">

<!-- رأس الصفحة -->
<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
    <div>
        <h1 class="text-3xl font-bold text-foreground flex items-center gap-2">
            <div class="w-8 h-8 bg-gradient-to-r from-green-600 to-emerald-600 rounded-lg flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                    <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                    <path d="m2 17 10 5 10-5"/>
                    <path d="m2 12 10 5 10-5"/>
                </svg>
            </div>
            إدارة الباقات
        </h1>
        <p class="text-muted-foreground">إدارة وتحكم في باقات الاشتراك المتاحة للمستخدمين</p>
    </div>
    
    <div class="flex items-center gap-2">
        <!-- زر التصدير -->
        <button onclick="exportPlansData()" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4"/>
                <polyline points="7 10 12 15 17 10"/>
                <line x1="12" y1="15" x2="12" y2="3"/>
            </svg>
            تصدير البيانات
        </button>

        <!-- زر إنشاء باقة جديدة -->
        <a href="<?php echo e(route('admin.plans.create')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive text-primary-foreground shadow-xs h-9 px-4 py-2 has-[>svg]:px-3 bg-primary hover:bg-primary/90">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M5 12h14"/>
                <path d="m12 5 7 7-7 7"/>
            </svg>
            <?php echo e(__('messages.add_new_plan')); ?>

        </a>
    </div>
</div>

<!-- رسائل النجاح والخطأ -->
<?php if(session('success')): ?>
    <div class="bg-green-50 border border-green-200 text-green-700 px-6 py-4 rounded-xl flex items-center gap-3">
        <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center flex-shrink-0">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                <polyline points="20 6 9 17 4 12"/>
            </svg>
        </div>
        <div class="text-sm font-medium"><?php echo e(session('success')); ?></div>
    </div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl flex items-center gap-3">
        <div class="w-8 h-8 bg-red-500 rounded-full flex items-center justify-center flex-shrink-0">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                <path d="M18 6 6 18"/>
                <path d="m6 6 12 12"/>
            </svg>
        </div>
        <div class="text-sm font-medium"><?php echo e(session('error')); ?></div>
    </div>
<?php endif; ?>

<!-- إحصائيات سريعة -->
<?php if($plans->count() > 0): ?>
<div class="grid grid-cols-1 md:grid-cols-4 gap-4">
    <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm p-6">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                    <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                </svg>
            </div>
            <div>
                <div class="text-2xl font-bold text-foreground"><?php echo e($plans->count()); ?></div>
                <div class="text-sm text-muted-foreground">إجمالي الباقات</div>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm p-6">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-green-100 rounded-xl flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                    <polyline points="20 6 9 17 4 12"/>
                </svg>
            </div>
            <div>
                <div class="text-2xl font-bold text-foreground"><?php echo e($plans->where('active', true)->count()); ?></div>
                <div class="text-sm text-muted-foreground">باقات مفعلة</div>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm p-6">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-red-100 rounded-xl flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-red-600">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </div>
            <div>
                <div class="text-2xl font-bold text-foreground"><?php echo e($plans->where('active', false)->count()); ?></div>
                <div class="text-sm text-muted-foreground">باقات معطلة</div>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm p-6">
        <div class="flex items-center gap-4">
            <div class="w-12 h-12 bg-yellow-100 rounded-xl flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-600">
                    <line x1="12" y1="1" x2="12" y2="3"/>
                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                </svg>
            </div>
            <div>
                <div class="text-2xl font-bold text-foreground"><?php echo e($plans->where('price', 0)->count()); ?></div>
                <div class="text-sm text-muted-foreground">باقات مجانية</div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- جدول الباقات -->
<div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm overflow-hidden">
    <div data-slot="card-header" class="px-6 py-4 border-b border-border bg-muted/30">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-semibold flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary">
                    <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                    <circle cx="12" cy="5" r="1"/>
                    <path d="m7 21-4.3-4.3c-1-1-1-2.5 0-3.4l9.6-9.6c1-1 2.5-1 3.4 0l5.6 5.6c1 1 1 2.5 0 3.4L12 21"/>
                </svg>
                قائمة الباقات المتاحة
            </h2>
            
            <!-- فلترة سريعة -->
            <div class="flex items-center gap-2">
                <select id="statusFilter" class="text-sm border border-input bg-background px-3 py-1 rounded-md">
                    <option value="">جميع الباقات</option>
                    <option value="active">مفعلة فقط</option>
                    <option value="inactive">معطلة فقط</option>
                    <option value="free">مجانية فقط</option>
                </select>
            </div>
        </div>
    </div>

    <div data-slot="card-content" class="overflow-x-auto">
        <?php if($plans->count() > 0): ?>
            <table class="w-full">
                <thead>
                    <tr class="border-b border-border bg-muted/20">
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground">#</th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground"><?php echo e(__('messages.name')); ?></th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground"><?php echo e(__('messages.price')); ?></th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground"><?php echo e(__('messages.duration')); ?></th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground">المزايا</th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground">المشتركون</th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground"><?php echo e(__('messages.status')); ?></th>
                        <th class="px-6 py-4 text-right text-sm font-medium text-foreground"><?php echo e(__('messages.options')); ?></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-border">
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-accent/50 transition-colors plan-row" 
                        data-status="<?php echo e($plan->active ? 'active' : 'inactive'); ?>" 
                        data-price="<?php echo e($plan->price); ?>"
                        data-id="<?php echo e($plan->id); ?>">
                        <td class="px-6 py-4 text-sm font-medium text-foreground">
                            <div class="w-8 h-8 bg-primary/10 rounded-full flex items-center justify-center text-primary font-bold text-xs">
                                <?php echo e($plan->id); ?>

                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                        <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-medium text-foreground"><?php echo e($plan->title); ?></div>
                                    <?php if($plan->description): ?>
                                        <div class="text-sm text-muted-foreground"><?php echo e(Str::limit($plan->description, 50)); ?></div>
                                    <?php endif; ?>
                                    <?php if($plan->priceid): ?>
                                        <div class="text-xs text-blue-600 bg-blue-50 px-2 py-1 rounded mt-1 w-fit">
                                            Stripe ID: <?php echo e($plan->priceid); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-1">
                                <span class="text-2xl font-bold text-foreground">$<?php echo e(number_format($plan->price, 2)); ?></span>
                                <?php if($plan->price == 0): ?>
                                    <span class="inline-flex items-center rounded-full px-2 py-1 text-xs font-medium bg-green-100 text-green-800">
                                        مجاني
                                    </span>
                                <?php endif; ?>
                            </div>
                            <?php if($plan->autorenew): ?>
                                <div class="text-xs text-blue-600 flex items-center gap-1 mt-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                                        <path d="M21 3v5h-5"/>
                                        <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                                        <path d="M8 16H3v5"/>
                                    </svg>
                                    تجديد تلقائي
                                </div>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-2 text-sm text-muted-foreground">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="10"/>
                                    <polyline points="12 6 12 12 16 14"/>
                                </svg>
                                <?php echo e($plan->period_days); ?> 
                                <?php if($plan->period_type == 'days'): ?>
                                    يوم
                                <?php elseif($plan->period_type == 'months'): ?>
                                    شهر
                                <?php else: ?>
                                    سنة
                                <?php endif; ?>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex flex-wrap gap-1">
                                <?php
                                    $features = $plan->features ?? [];
                                    $featureCount = 0;
                                    $displayFeatures = [];
                                    
                                    if (isset($features['facebook_accounts']) && $features['facebook_accounts'] != 0) {
                                        $value = $features['facebook_accounts'] == -1 ? '∞' : $features['facebook_accounts'];
                                        $displayFeatures[] = "FB: {$value}";
                                        $featureCount++;
                                    }
                                    
                                    if (isset($features['instagram_accounts']) && $features['instagram_accounts'] != 0) {
                                        $value = $features['instagram_accounts'] == -1 ? '∞' : $features['instagram_accounts'];
                                        $displayFeatures[] = "IG: {$value}";
                                        $featureCount++;
                                    }
                                    
                                    if (isset($features['facebook_posts']) && $features['facebook_posts'] != 0) {
                                        $value = $features['facebook_posts'] == -1 ? '∞' : $features['facebook_posts'];
                                        $displayFeatures[] = "منشورات: {$value}";
                                        $featureCount++;
                                    }
                                    
                                    if (isset($features['auto_replies']) && $features['auto_replies'] != 0) {
                                        $value = $features['auto_replies'] == -1 ? '∞' : $features['auto_replies'];
                                        $displayFeatures[] = "ردود: {$value}";
                                        $featureCount++;
                                    }
                                ?>
                                
                                <?php $__currentLoopData = array_slice($displayFeatures, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="inline-flex items-center rounded-full px-2 py-1 text-xs font-medium bg-blue-100 text-blue-800">
                                        <?php echo e($feature); ?>

                                    </span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <?php if(count($displayFeatures) > 3): ?>
                                    <span class="inline-flex items-center rounded-full px-2 py-1 text-xs font-medium bg-gray-100 text-gray-800" 
                                          title="مزايا إضافية">
                                        +<?php echo e(count($displayFeatures) - 3); ?>

                                    </span>
                                <?php endif; ?>
                                
                                <?php if(empty($displayFeatures)): ?>
                                    <span class="text-xs text-muted-foreground">لا توجد مزايا محددة</span>
                                <?php endif; ?>
                            </div>
                        </td>
                        
                        <td class="px-6 py-4">
                            <?php if($plan->active): ?>
                                <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium bg-green-100 text-green-800">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-1">
                                        <polyline points="20 6 9 17 4 12"/>
                                    </svg>
                                    مفعلة
                                </span>
                            <?php else: ?>
                                <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium bg-red-100 text-red-800">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-1">
                                        <path d="M18 6 6 18"/>
                                        <path d="m6 6 12 12"/>
                                    </svg>
                                    معطلة
                                </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4">
    <div class="flex items-center gap-2">
        <!-- زر عرض التفاصيل -->
        <button onclick="showPlanDetails(<?php echo e($plan->id); ?>)" 
                class="inline-flex items-center justify-center rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground h-8 w-8" 
                title="عرض التفاصيل">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z"/>
                <circle cx="12" cy="12" r="3"/>
            </svg>
        </button>

        <!-- زر النسخ -->
        <form action="<?php echo e(route('admin.plans.clone', $plan)); ?>" method="POST" class="inline-block">
            <?php echo csrf_field(); ?>
            <button type="submit" 
                    class="inline-flex items-center justify-center rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground h-8 w-8" 
                    title="نسخ الباقة">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect width="14" height="14" x="8" y="8" rx="2" ry="2"/>
                    <path d="M4 16c-1.1 0-2-.9-2-2V4c0-1.1.9-2 2-2h10c1.1 0 2 .9 2 2"/>
                </svg>
            </button>
        </form>

        <!-- زر تغيير الحالة -->
        <form action="<?php echo e(route('admin.plans.toggle', $plan)); ?>" method="POST" class="inline-block">
            <?php echo csrf_field(); ?>
            <button type="submit" 
                    class="inline-flex items-center justify-center rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground h-8 w-8" 
                    title="<?php echo e($plan->active ? 'إلغاء التفعيل' : 'تفعيل'); ?>">
                <?php if($plan->active): ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M18 6 6 18"/>
                        <path d="m6 6 12 12"/>
                    </svg>
                <?php else: ?>
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                <?php endif; ?>
            </button>
        </form>
        
        <!-- زر التعديل -->
        <a href="<?php echo e(route('admin.plans.edit', $plan)); ?>" 
           class="inline-flex items-center justify-center rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground h-8 w-8" 
           title="<?php echo e(__('messages.edit_plan')); ?>">
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/>
                <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4Z"/>
            </svg>
        </a>
        
        <!-- زر الحذف -->
        <?php
            $planSubscribersCount = $plan->subscribers()->count() ?? 0;
        ?>
        <form action="<?php echo e(route('admin.plans.destroy', $plan)); ?>" method="POST" class="inline-block" onsubmit="return confirmDelete(event, '<?php echo e($plan->title); ?>', <?php echo e($planSubscribersCount); ?>)">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" 
                    class="inline-flex items-center justify-center rounded-md text-sm font-medium transition-all border border-destructive bg-destructive text-destructive-foreground hover:bg-destructive/90 h-8 w-8 <?php echo e($planSubscribersCount > 0 ? 'opacity-50 cursor-not-allowed' : ''); ?>" 
                    title="<?php echo e(__('messages.delete_plan')); ?>"
                    <?php echo e($planSubscribersCount > 0 ? 'disabled' : ''); ?>>
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M3 6h18"/>
                    <path d="M19 6v14c0 1-1 2-2 2H7c-1 0-2-1-2-2V6"/>
                    <path d="M8 6V4c0-1 1-2 2-2h4c1 0 2 1 2 2v2"/>
                </svg>
            </button>
        </form>
    </div>
</td>

                        
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <!-- حالة عدم وجود باقات -->
            <div class="flex flex-col items-center justify-center py-16">
                <div class="w-24 h-24 bg-muted rounded-full flex items-center justify-center mb-6">
                    <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-muted-foreground">
                        <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                        <path d="m2 17 10 5 10-5"/>
                        <path d="m2 12 10 5 10-5"/>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold text-foreground mb-2">لا توجد باقات مضافة بعد</h3>
                <p class="text-muted-foreground text-center max-w-md mb-6">ابدأ بإنشاء باقة جديدة لتوفير خيارات الاشتراك للمستخدمين</p>
                <a href="<?php echo e(route('admin.plans.create')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-primary text-primary-foreground hover:bg-primary/90 h-9 px-4 py-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M5 12h14"/>
                        <path d="m12 5 7 7-7 7"/>
                    </svg>
                    إنشاء باقة جديدة
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- مودال تفاصيل الباقة -->
<div id="planDetailsModal" class="fixed inset-0 bg-black bg-opacity-50 hidden items-center justify-center z-50">
    <div class="bg-white rounded-xl max-w-2xl w-full mx-4 max-h-[90vh] overflow-y-auto">
        <div class="sticky top-0 bg-white border-b px-6 py-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold">تفاصيل الباقة</h3>
            <button onclick="closePlanDetailsModal()" class="text-gray-400 hover:text-gray-600">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </button>
        </div>
        <div id="planDetailsContent" class="p-6">
            <!-- محتوى التفاصيل سيتم تحميله هنا -->
        </div>
    </div>
</div>

</div>

<script>

document.getElementById('statusFilter').addEventListener('change', function() {
    const filterValue = this.value;
    const rows = document.querySelectorAll('.plan-row');
    
    rows.forEach(row => {
        let show = true;
        
        if (filterValue === 'active') {
            show = row.dataset.status === 'active';
        } else if (filterValue === 'inactive') {
            show = row.dataset.status === 'inactive';
        } else if (filterValue === 'free') {
            show = parseFloat(row.dataset.price) === 0;
        }
        
        row.style.display = show ? '' : 'none';
    });
});

// تأكيد الحذف
function confirmDelete(event, planTitle, subscribersCount) {
    event.preventDefault();
    
    if (subscribersCount > 0) {
        alert('لا يمكن حذف هذه الباقة لوجود ' + subscribersCount + ' مشترك. قم بنقل المشتركين لباقة أخرى أولاً.');
        return false;
    }
    
    if (confirm('تأكيد حذف الباقة "' + planTitle + '"؟\n\nهل أنت متأكد من حذف هذه الباقة؟ لا يمكن التراجع عن هذا الإجراء.')) {
        event.target.submit();
    }
    
    return false;
}
// عرض تفاصيل الباقة
function showPlanDetails(planId) {
    // fetch plan details via AJAX
    fetch(`/admin/plans/${planId}/statistics`)
        .then(response => response.json())
        .then(data => {
            const content = `
                <div class="grid grid-cols-2 gap-4 mb-6">
                    <div class="bg-blue-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-blue-900 mb-2">إجمالي المشتركين</h4>
                        <div class="text-2xl font-bold text-blue-600">${data.subscribers_count}</div>
                    </div>
                    <div class="bg-green-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-green-900 mb-2">المشتركون النشطون</h4>
                        <div class="text-2xl font-bold text-green-600">${data.active_subscribers}</div>
                    </div>
                    <div class="bg-yellow-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-yellow-900 mb-2">إجمالي الإيرادات</h4>
                        <div class="text-2xl font-bold text-yellow-600">$${data.total_revenue}</div>
                    </div>
                    <div class="bg-purple-50 p-4 rounded-lg">
                        <h4 class="font-semibold text-purple-900 mb-2">إيرادات هذا الشهر</h4>
                        <div class="text-2xl font-bold text-purple-600">$${data.monthly_revenue}</div>
                    </div>
                </div>
            `;
            
            document.getElementById('planDetailsContent').innerHTML = content;
            document.getElementById('planDetailsModal').classList.remove('hidden');
            document.getElementById('planDetailsModal').classList.add('flex');
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ في تحميل البيانات');
        });
}

// إغلاق مودال التفاصيل
function closePlanDetailsModal() {
    document.getElementById('planDetailsModal').classList.add('hidden');
    document.getElementById('planDetailsModal').classList.remove('flex');
}

// تصدير البيانات
function exportPlansData() {
    const plansData = <?php echo json_encode($plans->toArray(), 15, 512) ?>;
    const dataStr = JSON.stringify(plansData, null, 2);
    const dataBlob = new Blob([dataStr], {type: 'application/json'});
    
    const link = document.createElement('a');
    link.href = URL.createObjectURL(dataBlob);
    link.download = 'plans_export_' + new Date().toISOString().split('T')[0] + '.json';
    link.click();
}

// إغلاق المودال عند النقر خارجه
document.getElementById('planDetailsModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closePlanDetailsModal();
    }
});
</script>

<style>
/* تحسين تأثيرات الجدول */
table {
    border-spacing: 0;
    border-collapse: separate;
}

tbody tr {
    transition: all 0.2s ease;
}

tbody tr:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* تحسين الأزرار */
button, a {
    transition: all 0.2s ease;
}

button:hover, a:hover {
    transform: translateY(-1px);
}

/* تحسين الألوان */
.bg-destructive {
    background-color: rgb(239 68 68);
}

.text-destructive-foreground {
    color: rgb(255 255 255);
}

.hover\:bg-destructive\/90:hover {
    background-color: rgb(220 38 38);
}

.border-destructive {
    border-color: rgb(239 68 68);
}

/* تحسين التأثيرات البصرية */
.shadow-xs {
    box-shadow: 0 1px 2px 0 rgb(0 0 0 / 0.05);
}

.shadow-sm {
    box-shadow: 0 1px 2px 0 rgb(0 0 0 / 0.05);
}

/* تحسين استجابة الجدول */
@media (max-width: 768px) {
    .overflow-x-auto {
        -webkit-overflow-scrolling: touch;
    }
    
    table {
        min-width: 800px;
    }
    
    .px-6 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
    
    .py-4 {
        padding-top: 0.75rem;
        padding-bottom: 0.75rem;
    }
}

/* تحسين ألوان الحالة */
.bg-green-100 {
    background-color: rgb(220 252 231);
}

.text-green-800 {
    color: rgb(22 101 52);
}

.bg-red-100 {
    background-color: rgb(254 226 226);
}

.text-red-800 {
    color: rgb(153 27 27);
}

.bg-blue-100 {
    background-color: rgb(219 234 254);
}

.text-blue-800 {
    color: rgb(30 64 175);
}

/* مودال */
.fixed.inset-0 {
    position: fixed;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
}

/* تحسين المساحات */
.space-y-6 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 1.5rem;
}

.gap-4 {
    gap: 1rem;
}

.gap-3 {
    gap: 0.75rem;
}

.gap-2 {
    gap: 0.5rem;
}

/* تحسين الأزرار المعطلة */
button:disabled {
    cursor: not-allowed;
    opacity: 0.5;
}

button:disabled:hover {
    transform: none;
}
</style>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/admin/plans/index.blade.php ENDPATH**/ ?>