
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> منشورات فيسبوك - إدارة ونشر المنشورات على صفحات فيسبوك <?php $__env->endSlot(); ?>

    <div class="p-6 space-y-6">
        
        <!-- Page Header -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h1 class="text-3xl font-bold text-foreground flex items-center gap-2">
                    <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                        <svg class="h-6 w-6 text-white" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                        </svg>
                    </div>
                    <?php echo e(__('منشورات فيسبوك')); ?>

                </h1>
                <p class="text-muted-foreground"><?php echo e(__('إدارة ونشر المنشورات على صفحات فيسبوك')); ?></p>
            </div>
            
            <!-- Action Button -->
            <div>
                <?php if(isset($planLimits) && $planLimits['feature_available']): ?>
                    <?php if($planLimits['can_create_more']): ?>
                        <a href="<?php echo e(route('facebook-posts.create')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-blue-600 text-white shadow-xs hover:bg-blue-700 h-9 px-4 py-2">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                <line x1="12" y1="5" x2="12" y2="19"/>
                                <line x1="5" y1="12" x2="19" y2="12"/>
                            </svg>
                            <?php echo e(__('إنشاء منشور جديد')); ?>

                        </a>
                    <?php else: ?>
                        <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-gradient-to-r from-orange-500 to-orange-600 text-white shadow-xs hover:from-orange-600 hover:to-orange-700 h-9 px-4 py-2">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                            </svg>
                            <?php echo e(__('ترقية للمزيد من المنشورات')); ?>

                        </a>
                    <?php endif; ?>
                <?php else: ?>
                    <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-gradient-to-r from-purple-500 to-purple-600 text-white shadow-xs hover:from-purple-600 hover:to-purple-700 h-9 px-4 py-2">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                        </svg>
                        <?php echo e(__('ترقية لتفعيل الميزة')); ?>

                    </a>
                <?php endif; ?>
            </div>
        </div>

        <!-- Compact Usage Banner -->
        <?php if(isset($planLimits)): ?>
            <?php
                $percentage = !$planLimits['unlimited'] && $planLimits['max'] > 0 
                    ? ($planLimits['current'] / $planLimits['max']) * 100 
                    : 0;
                $isLow = !$planLimits['unlimited'] && $planLimits['remaining'] <= 5;
                $isFull = !$planLimits['unlimited'] && $planLimits['remaining'] == 0;
                
                // Determine banner color
                if (!$planLimits['feature_available']) {
                    $bannerColor = 'from-purple-500 to-purple-600';
                    $iconBg = 'bg-purple-400/30';
                } elseif ($isFull) {
                    $bannerColor = 'from-red-500 to-red-600';
                    $iconBg = 'bg-red-400/30';
                } elseif ($isLow) {
                    $bannerColor = 'from-orange-500 to-orange-600';
                    $iconBg = 'bg-orange-400/30';
                } elseif ($planLimits['unlimited']) {
                    $bannerColor = 'from-green-500 to-green-600';
                    $iconBg = 'bg-green-400/30';
                } else {
                    $bannerColor = 'from-blue-500 to-blue-600';
                    $iconBg = 'bg-blue-400/30';
                }
            ?>

            <div class="bg-gradient-to-r <?php echo e($bannerColor); ?> rounded-lg shadow-sm overflow-hidden">
                <div class="px-6 py-4">
                    <div class="flex items-center justify-between gap-4">
                        <!-- Left Section: Usage Info -->
                        <div class="flex items-center gap-4 flex-1">
                            <div class="w-10 h-10 <?php echo e($iconBg); ?> rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg class="h-5 w-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </div>
                            
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center gap-2 mb-1">
                                    <h3 class="text-white font-semibold text-sm"><?php echo e(__('استخدام منشورات فيسبوك')); ?></h3>
                                    <?php if($planLimits['unlimited']): ?>
                                        <span class="inline-flex items-center rounded-full bg-white/20 px-2 py-0.5 text-xs font-semibold text-white">
                                            <svg class="h-3 w-3 mr-1" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                                <path d="M18 6L6 18"/>
                                                <path d="m6 6 12 12"/>
                                            </svg>
                                            <?php echo e(__('غير محدود')); ?>

                                        </span>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="flex items-center gap-3">
                                    <div class="text-white text-sm">
                                        <span class="font-bold text-lg"><?php echo e($planLimits['current']); ?></span>
                                        <?php if(!$planLimits['unlimited']): ?>
                                            <span class="text-white/80">/ <?php echo e($planLimits['max']); ?></span>
                                        <?php endif; ?>
                                        <span class="text-white/80 text-xs"><?php echo e(__('منشور')); ?></span>
                                    </div>
                                    
                                    <?php if(!$planLimits['unlimited']): ?>
                                        <!-- Progress Bar (Inline) -->
                                        <div class="flex-1 max-w-xs">
                                            <div class="w-full bg-white/20 rounded-full h-2 overflow-hidden">
                                                <?php
                                                    $progressColor = $percentage >= 90 ? 'bg-red-300' : ($percentage >= 70 ? 'bg-yellow-300' : 'bg-green-300');
                                                ?>
                                                <div class="<?php echo e($progressColor); ?> h-full rounded-full transition-all duration-500" style="width: <?php echo e(min($percentage, 100)); ?>%"></div>
                                            </div>
                                        </div>
                                        
                                        <div class="text-white/90 text-xs font-medium">
                                            <?php echo e(number_format($percentage, 0)); ?>%
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Right Section: Status & Action -->
                        <div class="flex items-center gap-3">
                            <?php if(!$planLimits['feature_available']): ?>
                                <div class="text-white text-right hidden sm:block">
                                    <div class="text-xs text-white/80"><?php echo e(__('الميزة غير متاحة')); ?></div>
                                    <div class="font-medium text-sm"><?php echo e(__('قم بالترقية للتفعيل')); ?></div>
                                </div>
                                <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium bg-white text-purple-600 hover:bg-white/90 transition-all h-9 px-4 py-2 shadow-sm">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                        <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                                    </svg>
                                    <?php echo e(__('ترقية الآن')); ?>

                                </a>
                            <?php elseif($isFull): ?>
                                <div class="text-white text-right hidden sm:block">
                                    <div class="text-xs text-white/80"><?php echo e(__('وصلت للحد الأقصى')); ?></div>
                                    <div class="font-medium text-sm"><?php echo e(__('قم بالترقية للمزيد')); ?></div>
                                </div>
                                <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium bg-white text-red-600 hover:bg-white/90 transition-all h-9 px-4 py-2 shadow-sm">
                                    <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                        <polyline points="23,6 13.5,15.5 8.5,10.5 1,18"/>
                                        <polyline points="17,6 23,6 23,12"/>
                                    </svg>
                                    <?php echo e(__('ترقية')); ?>

                                </a>
                            <?php elseif($isLow): ?>
                                <div class="text-white text-right hidden sm:block">
                                    <div class="text-xs text-white/80"><?php echo e(__('متبقي')); ?></div>
                                    <div class="font-bold text-lg"><?php echo e($planLimits['remaining']); ?></div>
                                </div>
                                <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium bg-white/20 text-white hover:bg-white/30 transition-all h-9 px-4 py-2 border border-white/20">
                                    <?php echo e(__('عرض الباقات')); ?>

                                </a>
                            <?php elseif($planLimits['unlimited']): ?>
                                <div class="text-white text-right hidden sm:block">
                                    <div class="text-xs text-white/80"><?php echo e(__('الباقة')); ?></div>
                                    <div class="font-medium text-sm flex items-center gap-1">
                                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                            <polyline points="20,6 9,17 4,12"/>
                                        </svg>
                                        <?php echo e(__('مميزة')); ?>

                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="text-white text-right hidden sm:block">
                                    <div class="text-xs text-white/80"><?php echo e(__('متبقي')); ?></div>
                                    <div class="font-bold text-lg"><?php echo e($planLimits['remaining']); ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

       

        <!-- Rest of your page content (filters, posts list, etc.) -->
        



  
<!-- الفلاتر والإحصائيات -->
<div class="grid grid-cols-1 lg:grid-cols-4 gap-6">

<!-- فلاتر البحث -->
  <div class="lg:col-span-3">
<div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border py-6 shadow-sm">
    <div data-slot="card-content" class="px-6 pt-6">
        <form method="GET" action="<?php echo e(route('facebook-posts.index')); ?>" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            
            <!-- البحث -->
            <div class="relative">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                     viewBox="0 0 24 24" fill="none" stroke="currentColor"
                     stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                     class="lucide lucide-search absolute right-3 top-1/2 transform -translate-y-1/2 text-muted-foreground h-4 w-4">
                    <circle cx="11" cy="11" r="8"></circle>
                    <path d="m21 21-4.3-4.3"></path>
                </svg>
                <input type="text" name="search"
                       value="<?php echo e(request('search')); ?>"
                       placeholder="ابحث في المحتوى..."
                       class="file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground
                              dark:bg-input/30 border-input flex h-9 w-full min-w-0 rounded-md border bg-transparent px-3 py-1
                              text-base shadow-xs transition-[color,box-shadow] outline-none pr-10
                              md:text-sm focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]" />
            </div>

            <!-- اختيار الصفحة -->
            <select name="page_id"
                    class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30
                           flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm
                           shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring
                           focus-visible:ring-ring/50 focus-visible:ring-[3px]">
                <option value="">جميع الصفحات</option>
                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($page->id); ?>" <?php echo e(request('page_id') == $page->id ? 'selected' : ''); ?>>
                        <?php echo e($page->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <!-- اختيار الحالة -->
            <select name="status"
                    class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30
                           flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm
                           shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring
                           focus-visible:ring-ring/50 focus-visible:ring-[3px]">
                <option value="">جميع الحالات</option>
                <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>مسودة</option>
                <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>>مُجدول</option>
                <option value="published" <?php echo e(request('status') == 'published' ? 'selected' : ''); ?>>منشور</option>
                <option value="failed" <?php echo e(request('status') == 'failed' ? 'selected' : ''); ?>>فشل</option>
            </select>

            <!-- اختيار النوع -->
            <select name="type"
                    class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30
                           flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm
                           shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring
                           focus-visible:ring-ring/50 focus-visible:ring-[3px]">
                <option value="">جميع الأنواع</option>
                <option value="text" <?php echo e(request('type') == 'text' ? 'selected' : ''); ?>>نص</option>
                <option value="image" <?php echo e(request('type') == 'image' ? 'selected' : ''); ?>>صورة</option>
                <option value="carousel" <?php echo e(request('type') == 'carousel' ? 'selected' : ''); ?>>ألبوم</option>
                <option value="video" <?php echo e(request('type') == 'video' ? 'selected' : ''); ?>>فيديو</option>
            </select>

            <!-- الأزرار -->
            <div class="flex gap-2">
                <button type="submit"
                        class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs
                               hover:bg-accent hover:text-accent-foreground dark:bg-input/30 dark:border-input
                               dark:hover:bg-input/50 h-9 px-4 py-2 text-sm font-medium transition-all flex-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="11" cy="11" r="8"></circle>
                        <path d="m21 21-4.3-4.3"></path>
                    </svg>
                    بحث
                </button>
                <a href="<?php echo e(route('facebook-posts.index')); ?>"
                   class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs
                          hover:bg-accent hover:text-accent-foreground dark:bg-input/30 dark:border-input
                          dark:hover:bg-input/50 h-9 px-4 py-2 text-sm font-medium transition-all">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M18 6 6 18"></path>
                        <path d="m6 6 12 12"></path>
                    </svg>
                </a>
            </div>
        </form>
    </div>
</div>
    </div>
<!-- إحصائيات سريعة -->
<div class="grid grid-cols-2 gap-3">
    <div data-slot="card" class="bg-gradient-to-r from-blue-500 to-blue-600 text-white flex flex-col gap-6 rounded-xl border py-4 shadow-sm">
        <div data-slot="card-content" class="px-4 text-center">
            <div class="text-xl font-bold"><?php echo e($stats['total']); ?></div>
            <div class="text-xs text-blue-100">إجمالي</div>
        </div>
    </div>
    <div data-slot="card" class="bg-gradient-to-r from-green-500 to-green-600 text-white flex flex-col gap-6 rounded-xl border py-4 shadow-sm">
        <div data-slot="card-content" class="px-4 text-center">
            <div class="text-xl font-bold"><?php echo e($stats['published']); ?></div>
            <div class="text-xs text-green-100">منشور</div>
        </div>
    </div>
    <div data-slot="card" class="bg-gradient-to-r from-yellow-500 to-yellow-600 text-white flex flex-col gap-6 rounded-xl border py-4 shadow-sm">
        <div data-slot="card-content" class="px-4 text-center">
            <div class="text-xl font-bold"><?php echo e($stats['scheduled']); ?></div>
            <div class="text-xs text-yellow-100">مجدول</div>
        </div>
    </div>
    <div data-slot="card" class="bg-gradient-to-r from-gray-500 to-gray-600 text-white flex flex-col gap-6 rounded-xl border py-4 shadow-sm">
        <div data-slot="card-content" class="px-4 text-center">
            <div class="text-xl font-bold"> <?php echo e($stats['drafts']); ?></div>
            <div class="text-xs text-gray-100">مسودة</div>
        </div>
    </div>

  </div>
   </div>
 
  

 

<!-- شبكة المنشورات -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm h-full <?php echo e($post->status === 'failed' ? 'border-red-300' : ''); ?>">
            
            <!-- معاينة المنشور -->
            <?php if($post->getPreviewImage()): ?>
                <div class="relative">
                    <img src="<?php echo e($post->getPreviewImage()); ?>" class="w-full h-48 object-cover rounded-t-xl" alt="Preview">
                    <div class="absolute top-2 left-2">
                        <?php echo $post->getStatusBadge(); ?>

                    </div>
                </div>
            <?php else: ?>
                <div class="flex justify-between items-center p-4 bg-muted/50 rounded-t-xl">
                    <div><?php echo $post->getTypeBadge(); ?></div>
                    <div><?php echo $post->getStatusBadge(); ?></div>
                </div>
            <?php endif; ?>

            <div class="flex flex-col flex-1 p-4 gap-4">
                
                <!-- المحتوى -->
                <p class="text-sm line-clamp-3"><?php echo e($post->getTruncatedContent(120)); ?></p>
                
                <!-- المعلومات الأساسية -->
                <div class="flex justify-between items-center text-xs text-muted-foreground">
                    <div class="flex items-center gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M14 2H8a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V6z"/>
                            <polyline points="14 2 14 8 20 8"/>
                            <line x1="16" y1="13" x2="8" y2="13"/>
                            <line x1="16" y1="17" x2="8" y2="17"/>
                            <polyline points="10 9 9 9 8 9"/>
                        </svg>
                        <?php echo e($post->facebookPage->name ?? 'صفحة محذوفة'); ?>

                    </div>
                    <div class="flex items-center gap-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect width="18" height="18" x="3" y="4" rx="2" ry="2"/>
                            <line x1="16" y1="2" x2="16" y2="6"/>
                            <line x1="8" y1="2" x2="8" y2="6"/>
                            <line x1="3" y1="10" x2="21" y2="10"/>
                        </svg>
                        <?php echo e($post->created_at->diffForHumans()); ?>

                    </div>
                </div>

                <!-- تنبيه الجدولة -->
                <?php if($post->isScheduled()): ?>
                    <div class="bg-yellow-50 border border-yellow-200 text-yellow-700 px-3 py-2 rounded-lg">
                        <div class="flex items-center gap-2 text-xs">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <polyline points="12 6 12 12 16 14"/>
                            </svg>
                            <span class="font-medium">مُجدول:</span>
                        </div>
                        <div class="text-xs mt-1">
                            <?php echo e(auth()->user()->toUserTime($post->scheduled_at)->format('Y-m-d H:i')); ?>

                            <small class="block text-yellow-600">(<?php echo e($post->scheduled_at->diffForHumans()); ?>)</small>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- رسالة الخطأ -->
                <?php if($post->error_message): ?>
                    <div class="bg-red-50 border border-red-200 text-red-700 px-3 py-2 rounded-lg">
                        <div class="flex items-center gap-2 text-xs">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="12" cy="12" r="10"/>
                                <line x1="15" y1="9" x2="9" y2="15"/>
                                <line x1="9" y1="9" x2="15" y2="15"/>
                            </svg>
                            <span class="font-medium">خطأ:</span>
                        </div>
                        <p class="text-xs mt-1"><?php echo e(Str::limit($post->error_message, 80)); ?></p>
                    </div>
                <?php endif; ?>

                <!-- إحصائيات المنشور -->
                <?php if($post->isPublished()): ?>
                    <div class="flex justify-center items-center gap-4 pt-3 border-t border-border text-xs text-muted-foreground">
                        <div class="flex items-center gap-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-500">
                                <path d="M7 10v12"/>
                                <path d="M15 5v14"/>
                                <path d="M12 8v8"/>
                                <path d="M2 4v16l7-7-7-9z"/>
                            </svg>
                            <?php echo e($post->likes_count); ?>

                        </div>
                        <div class="flex items-center gap-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-500">
                                <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                            </svg>
                            <?php echo e($post->comments_count); ?>

                        </div>
                        <div class="flex items-center gap-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-cyan-500">
                                <path d="M4 12v8a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-8"/>
                                <polyline points="16 6 12 2 8 6"/>
                                <line x1="12" y1="2" x2="12" y2="15"/>
                            </svg>
                            <?php echo e($post->shares_count); ?>

                        </div>
                    </div>
                <?php endif; ?>

                <!-- أزرار الإجراءات -->
                <div class="flex gap-2 mt-auto">
                    <a href="<?php echo e(route('facebook-posts.show', $post)); ?>" 
                       class="inline-flex items-center justify-center whitespace-nowrap text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive hover:bg-accent hover:text-accent-foreground dark:hover:bg-accent/50 h-8 rounded-md gap-1.5 px-3 has-[>svg]:px-2.5 flex-1"
                       title="عرض">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                            <circle cx="12" cy="12" r="3"/>
                        </svg>
                    </a>
                    
                    <?php if($post->canEdit()): ?>
                        <a href="<?php echo e(route('facebook-posts.edit', $post)); ?>" 
                           class="inline-flex items-center justify-center whitespace-nowrap text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive hover:bg-accent hover:text-accent-foreground dark:hover:bg-accent/50 h-8 rounded-md gap-1.5 px-3 has-[>svg]:px-2.5 flex-1 text-yellow-600"
                           title="تعديل">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/>
                                <path d="M18.5 2.5a2.12 2.12 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/>
                            </svg>
                        </a>
                    <?php endif; ?>

                    <?php if(!$post->isPublished() && $post->status !== 'failed'): ?>
                        <button class="publish-post inline-flex items-center justify-center whitespace-nowrap text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive hover:bg-accent hover:text-accent-foreground dark:hover:bg-accent/50 h-8 rounded-md gap-1.5 px-3 has-[>svg]:px-2.5 flex-1 text-green-600" 
                                data-post-id="<?php echo e($post->id); ?>"
                                title="نشر">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect width="18" height="18" x="3" y="3" rx="2"/>
                                <path d="M9 9h6v6"/>
                                <path d="m21 3-12 12"/>
                            </svg>
                        </button>
                    <?php endif; ?>

                    <?php if($post->canDelete()): ?>
                        <button class="delete-post inline-flex items-center justify-center whitespace-nowrap text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive hover:bg-accent hover:text-accent-foreground dark:hover:bg-accent/50 h-8 rounded-md gap-1.5 px-3 has-[>svg]:px-2.5 flex-1 text-red-600" 
                                data-post-id="<?php echo e($post->id); ?>"
                                data-post-title="<?php echo e(Str::limit($post->content, 50)); ?>"
                                title="حذف">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <polyline points="3 6 5 6 21 6"/>
                                <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/>
                                <line x1="10" y1="11" x2="10" y2="17"/>
                                <line x1="14" y1="11" x2="14" y2="17"/>
                            </svg>
                        </button>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-span-full">
            <div class="text-center py-12">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-file-text text-muted-foreground mx-auto mb-4">
                    <path d="M14 2H8a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V6z"/>
                    <polyline points="14 2 14 8 20 8"/>
                    <line x1="16" y1="13" x2="8" y2="13"/>
                    <line x1="16" y1="17" x2="8" y2="17"/>
                    <polyline points="10 9 9 9 8 9"/>
                </svg>
                <h5 class="text-lg font-medium mb-2">لا توجد منشورات</h5>
                <p class="text-muted-foreground mb-4">
                    <?php if(request()->hasAny(['search', 'page_id', 'status', 'type'])): ?>
                        لا توجد نتائج تطابق البحث الحالي
                        <br>
                        <a href="<?php echo e(route('facebook-posts.index')); ?>" class="inline-block mt-2 text-primary hover:underline">
                            مسح الفلاتر
                        </a>
                    <?php else: ?>
                        ابدأ بإنشاء أول منشور فيسبوك
                    <?php endif; ?>
                </p>
                <?php if(!request()->hasAny(['search', 'page_id', 'status', 'type'])): ?>
                    <a href="<?php echo e(route('facebook-posts.create')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive text-primary-foreground shadow-xs h-9 px-4 py-2 has-[>svg]:px-3 bg-primary hover:bg-primary/90">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <line x1="12" y1="5" x2="12" y2="19"/>
                            <line x1="5" y1="12" x2="19" y2="12"/>
                        </svg>
                        إنشاء منشور جديد
                    </a>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Pagination -->
<?php if($posts->hasPages()): ?>
    <div class="flex justify-center mt-6">
        <?php echo e($posts->appends(request()->query())->links()); ?>

    </div>
<?php endif; ?>

</div>

<!-- نافذة تأكيد -->
<div id="confirmModal" class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 hidden">
    <div class="bg-card rounded-lg border shadow-lg w-full max-w-md mx-4">
        <div class="flex items-center justify-between p-4 border-b border-border">
            <h5 class="font-semibold">تأكيد العملية</h5>
            <button type="button" class="text-muted-foreground hover:text-foreground" id="close-confirm-modal">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </button>
        </div>
        <div class="p-4">
            <p id="confirm-message" class="text-sm"></p>
        </div>
        <div class="flex items-center justify-end gap-2 p-4 border-t border-border">
            <button type="button" class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 text-sm font-medium transition-all" id="cancel-confirm">إلغاء</button>
            <button type="button" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90" id="confirm-action">تأكيد</button>
        </div>
    </div>
</div>

<!-- مكان للتنبيهات -->
<div id="alerts-container" class="fixed top-4 right-4 z-50 space-y-2"></div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    let currentAction = null;

    // نشر المنشور
    document.addEventListener('click', function(e) {
        if (e.target.closest('.publish-post')) {
            const postId = e.target.closest('.publish-post').dataset.postId;
            const btn = e.target.closest('.publish-post');
            const originalHtml = btn.innerHTML;
            
            btn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="animate-spin"><path d="M21 12a9 9 0 0 0-9-9 9.75 9.75 0 0 0-6.74 2.74L3 8"/><path d="M3 21v-5h5"/><path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/></svg>';
            btn.disabled = true;
            
            fetch(`/facebook-posts/${postId}/publish`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert('success', 'تم نشر المنشور بنجاح!');
                    setTimeout(() => location.reload(), 1500);
                } else {
                    showAlert('error', data.message || 'فشل في نشر المنشور');
                    btn.innerHTML = originalHtml;
                    btn.disabled = false;
                }
            })
            .catch(error => {
                showAlert('error', 'حدث خطأ أثناء النشر');
                btn.innerHTML = originalHtml;
                btn.disabled = false;
            });
        }
    });

    // حذف المنشور
    document.addEventListener('click', function(e) {
        if (e.target.closest('.delete-post')) {
            const postId = e.target.closest('.delete-post').dataset.postId;
            const postTitle = e.target.closest('.delete-post').dataset.postTitle;
            
            document.getElementById('confirm-message').textContent = `هل أنت متأكد من حذف المنشور "${postTitle}"؟`;
            document.getElementById('confirmModal').classList.remove('hidden');
            
            currentAction = function() {
                fetch(`/facebook-posts/${postId}`, {
                    method: 'DELETE',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                })
                .then(response => response.json())
                .then(data => {
                    showAlert('success', 'تم حذف المنشور بنجاح');
                    setTimeout(() => location.reload(), 1500);
                })
                .catch(error => {
                    showAlert('error', 'حدث خطأ أثناء حذف المنشور');
                });
            };
        }
    });

    // إدارة نافذة التأكيد
    document.getElementById('confirm-action').addEventListener('click', function() {
        if (currentAction) {
            currentAction();
            document.getElementById('confirmModal').classList.add('hidden');
            currentAction = null;
        }
    });

    document.getElementById('cancel-confirm').addEventListener('click', function() {
        document.getElementById('confirmModal').classList.add('hidden');
        currentAction = null;
    });

    document.getElementById('close-confirm-modal').addEventListener('click', function() {
        document.getElementById('confirmModal').classList.add('hidden');
        currentAction = null;
    });

    // إغلاق النافذة عند النقر خارجها
    window.addEventListener('click', function(e) {
        if (e.target === document.getElementById('confirmModal')) {
            document.getElementById('confirmModal').classList.add('hidden');
            currentAction = null;
        }
    });

    function showAlert(type, message) {
        const container = document.getElementById('alerts-container');
        const alertDiv = document.createElement('div');
        const bgColor = type === 'success' ? 'bg-green-500' : 'bg-red-500';
        const icon = type === 'success' ? 
            '<path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/>' :
            '<circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/>';
        
        alertDiv.className = `${bgColor} text-white px-4 py-3 rounded shadow-lg flex items-center gap-2 min-w-80 max-w-md`;
        alertDiv.innerHTML = `
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                ${icon}
            </svg>
            <span class="flex-1">${message}</span>
            <button type="button" class="text-white/80 hover:text-white" onclick="this.parentElement.remove()">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </button>
        `;
        
        container.appendChild(alertDiv);
        
        // إزالة التنبيه تلقائياً بعد 4 ثوانٍ
        setTimeout(() => {
            alertDiv.style.opacity = '0';
            alertDiv.style.transform = 'translateX(100%)';
            setTimeout(() => alertDiv.remove(), 300);
        }, 4000);
    }
});
</script>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/facebook-posts/index.blade.php ENDPATH**/ ?>