
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> تعليقات إنستقرام <?php $__env->endSlot(); ?>

<div class="p-6 space-y-6" >

<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">

<div>
    <h1 class="text-3xl font-bold text-foreground flex items-center gap-2">
        <div class="w-8 h-8 bg-gradient-to-br from-purple-600 via-pink-600 to-orange-500 rounded-lg flex items-center justify-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                <rect width="20" height="20" x="2" y="2" rx="5" ry="5"/>
                <path d="m13.5 8.5 2-2"/>
                <path d="m7.5 15.5 2-2"/>
                <circle cx="9" cy="9" r="2"/>
                <path d="m13.5 15.5 2 2"/>
            </svg>
        </div>
        تعليقات إنستقرام
    </h1>
    <p class="text-muted-foreground">إدارة ومراقبة تعليقات حسابات إنستقرام</p>
</div>

<button class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 text-sm font-medium transition-all" onclick="refreshComments()">
    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
        <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
        <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
        <path d="M8 12l5 5L22 8"/>
    </svg>
    تحديث
</button>

</div>

<!-- بطاقات الإحصائيات -->
<div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
    <div data-slot="card" class="bg-gradient-to-r from-blue-500 to-blue-600 text-white flex flex-col gap-4 rounded-xl py-4 shadow-sm stats-card">
        <div data-slot="card-content" class="px-4">
            <div class="flex justify-between items-center">
                <div>
                    <div class="text-2xl font-bold"><?php echo e(number_format($stats['total'])); ?></div>
                    <div class="text-xs text-blue-100">إجمالي التعليقات</div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-75">
                    <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                    <path d="M16 14a9 9 0 1 0-3.9 5.9L22 16Z"/>
                </svg>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-gradient-to-r from-green-500 to-green-600 text-white flex flex-col gap-4 rounded-xl py-4 shadow-sm stats-card">
        <div data-slot="card-content" class="px-4">
            <div class="flex justify-between items-center">
                <div>
                    <div class="text-2xl font-bold"><?php echo e(number_format($stats['today'])); ?></div>
                    <div class="text-xs text-green-100">اليوم</div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-75">
                    <rect width="18" height="18" x="3" y="4" rx="2" ry="2"/>
                    <line x1="16" y1="2" x2="16" y2="6"/>
                    <line x1="8" y1="2" x2="8" y2="6"/>
                    <line x1="3" y1="10" x2="21" y2="10"/>
                </svg>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-gradient-to-r from-cyan-500 to-cyan-600 text-white flex flex-col gap-4 rounded-xl py-4 shadow-sm stats-card">
        <div data-slot="card-content" class="px-4">
            <div class="flex justify-between items-center">
                <div>
                    <div class="text-2xl font-bold"><?php echo e(number_format($stats['replied'])); ?></div>
                    <div class="text-xs text-cyan-100">تم الرد عليها</div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-75">
                    <polyline points="9 17 4 12 9 7"/>
                    <path d="m20 18-7-7 7-7"/>
                </svg>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-gradient-to-r from-yellow-500 to-yellow-600 text-white flex flex-col gap-4 rounded-xl py-4 shadow-sm stats-card">
        <div data-slot="card-content" class="px-4">
            <div class="flex justify-between items-center">
                <div>
                    <div class="text-2xl font-bold"><?php echo e(number_format($stats['not_replied'])); ?></div>
                    <div class="text-xs text-yellow-100">بدون رد</div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-75">
                    <circle cx="12" cy="12" r="10"/>
                    <polyline points="12 6 12 12 16 14"/>
                </svg>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-gradient-to-r from-purple-500 to-purple-600 text-white flex flex-col gap-4 rounded-xl py-4 shadow-sm stats-card">
        <div data-slot="card-content" class="px-4">
            <div class="flex justify-between items-center">
                <div>
                    <div class="text-2xl font-bold"><?php echo e(number_format($stats['public_replies'])); ?></div>
                    <div class="text-xs text-purple-100">ردود علنية</div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-75">
                    <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                    <circle cx="12" cy="12" r="3"/>
                </svg>
            </div>
        </div>
    </div>

    <div data-slot="card" class="bg-gradient-to-r from-gray-500 to-gray-600 text-white flex flex-col gap-4 rounded-xl py-4 shadow-sm stats-card">
        <div data-slot="card-content" class="px-4">
            <div class="flex justify-between items-center">
                <div>
                    <div class="text-2xl font-bold"><?php echo e(number_format($stats['private_replies'])); ?></div>
                    <div class="text-xs text-gray-100">رسائل خاصة</div>
                </div>
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="opacity-75">
                    <rect width="20" height="16" x="2" y="4" rx="2"/>
                    <path d="m22 7-10 5L2 7"/>
                </svg>
            </div>
        </div>
    </div>
</div>

<!-- الفلاتر -->
<div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border py-6 shadow-sm">
    <div data-slot="card-content" class="px-6">
        <form method="GET" action="<?php echo e(route('instagram.comments.index')); ?>" id="filter-form">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">البحث</label>
                    <input type="text" name="search" class="file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground dark:bg-input/30 border-input flex h-9 w-full min-w-0 rounded-md border bg-transparent px-3 py-1 text-base shadow-xs transition-[color,box-shadow] outline-none md:text-sm focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]" 
                           value="<?php echo e(request('search')); ?>" placeholder="البحث في التعليقات...">
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">الحساب</label>
                    <select name="account_id" class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30 flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full">
                        <option value="">جميع الحسابات</option>
                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($account->id); ?>" <?php echo e(request('account_id') == $account->id ? 'selected' : ''); ?>>
                                <?php echo e('@' . $account->username); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">حالة الرد</label>
                    <select name="reply_status" class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30 flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full">
                        <option value="">جميع الحالات</option>
                        <option value="replied" <?php echo e(request('reply_status') == 'replied' ? 'selected' : ''); ?>>تم الرد</option>
                        <option value="not_replied" <?php echo e(request('reply_status') == 'not_replied' ? 'selected' : ''); ?>>لم يتم الرد</option>
                    </select>
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">نوع الرد</label>
                    <select name="reply_type" class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30 flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full">
                        <option value="">جميع الأنواع</option>
                        <option value="public" <?php echo e(request('reply_type') == 'public' ? 'selected' : ''); ?>>رد علني</option>
                        <option value="private" <?php echo e(request('reply_type') == 'private' ? 'selected' : ''); ?>>رسالة خاصة</option>
                    </select>
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">الرد التلقائي</label>
                    <select name="auto_reply_id" class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30 flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full">
                        <option value="">جميع الردود</option>
                        <?php $__currentLoopData = $autoReplies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $autoReply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($autoReply->id); ?>" <?php echo e(request('auto_reply_id') == $autoReply->id ? 'selected' : ''); ?>>
                                <?php echo e($autoReply->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">&nbsp;</label>
                    <div class="flex gap-2">
                        <button type="submit" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90 flex-1">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <circle cx="11" cy="11" r="8"/>
                                <path d="m21 21-4.3-4.3"/>
                            </svg>
                            بحث
                        </button>
                        <a href="<?php echo e(route('instagram.comments.index')); ?>" class="inline-flex items-center justify-center whitespace-nowrap text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive hover:bg-accent hover:text-accent-foreground dark:hover:bg-accent/50 h-9 rounded-md px-3 border border-border">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M18 6 6 18"/>
                                <path d="m6 6 12 12"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-4">
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">من تاريخ</label>
                    <input type="date" name="date_from" class="file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground dark:bg-input/30 border-input flex h-9 w-full min-w-0 rounded-md border bg-transparent px-3 py-1 text-base shadow-xs transition-[color,box-shadow] outline-none md:text-sm focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]" 
                           value="<?php echo e(request('date_from')); ?>">
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">إلى تاريخ</label>
                    <input type="date" name="date_to" class="file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground dark:bg-input/30 border-input flex h-9 w-full min-w-0 rounded-md border bg-transparent px-3 py-1 text-base shadow-xs transition-[color,box-shadow] outline-none md:text-sm focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]" 
                           value="<?php echo e(request('date_to')); ?>">
                </div>
                <div>
                    <label class="text-sm font-medium text-foreground mb-1 block">حالة الإخفاء</label>
                    <select name="hidden_status" class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30 flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 py-2 text-sm shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full">
                        <option value="">جميع التعليقات</option>
                        <option value="visible" <?php echo e(request('hidden_status') == 'visible' ? 'selected' : ''); ?>>مرئية</option>
                        <option value="hidden" <?php echo e(request('hidden_status') == 'hidden' ? 'selected' : ''); ?>>مخفية</option>
                    </select>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- قائمة التعليقات -->
<div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
    <div data-slot="card-header" class="@container/card-header auto-rows-min grid-rows-[auto_auto] gap-1.5 px-6 py-4 has-data-[slot=card-action]:grid-cols-[1fr_auto] [.border-b]:pb-6 flex flex-row items-center justify-between border-b border-border">
        <div data-slot="card-title" class="font-semibold text-base sm:text-lg flex items-center gap-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary">
                <line x1="3" y1="6" x2="21" y2="6"/>
                <line x1="3" y1="12" x2="21" y2="12"/>
                <line x1="3" y1="18" x2="21" y2="18"/>
            </svg>
            التعليقات (<?php echo e($comments->total()); ?>)
        </div>
        <div class="flex items-center gap-2">
            <button class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-8 px-3 text-sm font-medium transition-all" onclick="selectAll()">
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <polyline points="9 11 12 14 22 4"/>
                    <path d="m21 3-6.5 18a.55.55 0 0 1-1 0L7 14l-7-3.5a.55.55 0 0 1 0-1z"/>
                </svg>
                تحديد الكل
            </button>
            <button class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-8 px-3 text-sm font-medium transition-all text-red-600 border-red-300 hover:bg-red-50" onclick="bulkAction('hide')" id="bulk-hide">
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="m9.88 9.88a3 3 0 1 0 4.24 4.24"/>
                    <path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"/>
                    <path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"/>
                    <line x1="2" y1="2" x2="22" y2="22"/>
                </svg>
                إخفاء المحدد
            </button>
            <button class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-8 px-3 text-sm font-medium transition-all text-green-600 border-green-300 hover:bg-green-50" onclick="bulkAction('unhide')" id="bulk-unhide">
                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                    <circle cx="12" cy="12" r="3"/>
                </svg>
                إظهار المحدد
            </button>
        </div>
    </div>

    <div data-slot="card-content" class="p-0">
        <?php $__empty_1 = true; $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="comment-item border-b border-border p-4 hover:bg-accent/20 transition-colors <?php echo e($comment->is_hidden ? 'bg-muted/30 opacity-75' : ''); ?>" 
                 data-comment-id="<?php echo e($comment->id); ?>">
                <div class="flex gap-4">
                    <!-- مربع الاختيار -->
                    <div class="flex-shrink-0 pt-1">
                        <input type="checkbox" class="h-4 w-4 text-primary focus:ring-primary border-gray-300 rounded comment-checkbox" 
                               value="<?php echo e($comment->id); ?>">
                    </div>

                    <!-- محتوى التعليق -->
                    <div class="flex-1 min-w-0">
                        <!-- الرأس -->
                        <div class="flex flex-col sm:flex-row sm:items-center justify-between gap-2 mb-3">
                            <div class="flex items-center gap-4">
                                <!-- معلومات المعلق -->
                                <div class="flex items-center gap-3">
                                    <div class="w-8 h-8 bg-gradient-to-br from-purple-600 via-pink-600 to-orange-500 rounded-full flex items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                            <rect width="20" height="20" x="2" y="2" rx="5" ry="5"/>
                                            <path d="m13.5 8.5 2-2"/>
                                            <path d="m7.5 15.5 2-2"/>
                                            <circle cx="9" cy="9" r="2"/>
                                            <path d="m13.5 15.5 2 2"/>
                                        </svg>
                                    </div>
                                    <div>
                                        <div class="font-medium text-sm"><?php echo e('@' . $comment->commenter_username); ?></div>
                                        <div class="text-xs text-muted-foreground flex items-center gap-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <circle cx="12" cy="12" r="10"/>
                                                <polyline points="12 6 12 12 16 14"/>
                                            </svg>
                                            <?php echo e($comment->timestamp->diffForHumans()); ?>

                                        </div>
                                    </div>
                                </div>

                                <!-- الحساب -->
                                <span class="inline-flex items-center rounded-full bg-primary px-2 py-1 text-xs font-medium text-primary-foreground">
                                    <?php echo e('@' . $comment->instagramAccount->username); ?>

                                </span>
                            </div>

                            <!-- شارات الحالة -->
                            <div class="flex flex-wrap gap-1">
                                <?php if($comment->is_hidden): ?>
                                    <span class="inline-flex items-center rounded-full bg-gray-500 px-2 py-1 text-xs font-medium text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                            <path d="m9.88 9.88a3 3 0 1 0 4.24 4.24"/>
                                            <path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"/>
                                            <path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"/>
                                            <line x1="2" y1="2" x2="22" y2="22"/>
                                        </svg>
                                        مخفي
                                    </span>
                                <?php endif; ?>
                                
                                <?php if($comment->replied_to): ?>
                                    <span class="inline-flex items-center rounded-full bg-green-500 px-2 py-1 text-xs font-medium text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                            <polyline points="20 6 9 17 4 12"/>
                                        </svg>
                                        تم الرد
                                    </span>
                                <?php else: ?>
                                    <span class="inline-flex items-center rounded-full bg-yellow-500 px-2 py-1 text-xs font-medium text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                            <circle cx="12" cy="12" r="10"/>
                                            <polyline points="12 6 12 12 16 14"/>
                                        </svg>
                                        بدون رد
                                    </span>
                                <?php endif; ?>

                                <?php if($comment->public_reply_sent): ?>
                                    <span class="inline-flex items-center rounded-full bg-cyan-500 px-2 py-1 text-xs font-medium text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                            <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                                            <circle cx="12" cy="12" r="3"/>
                                        </svg>
                                        رد علني
                                    </span>
                                <?php endif; ?>

                                <?php if($comment->private_reply_sent): ?>
                                    <span class="inline-flex items-center rounded-full bg-purple-500 px-2 py-1 text-xs font-medium text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                            <rect width="20" height="16" x="2" y="4" rx="2"/>
                                            <path d="m22 7-10 5L2 7"/>
                                        </svg>
                                        رسالة خاصة
                                    </span>
                                <?php endif; ?>

                                <?php if($comment->autoReply): ?>
                                    <span class="inline-flex items-center rounded-full bg-indigo-500 px-2 py-1 text-xs font-medium text-white">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="ml-1">
                                            <path d="M12 2a2 2 0 0 1 2 2c0 .74-.4 1.39-1 1.73V7h4a2 2 0 0 1 2 2v1.28c.6-.35 1-.99 1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V22a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V10.28c-.6-.35-1-.99-1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V11h4V9.27c-.6-.34-1-.99-1-1.73a2 2 0 0 1 4 0z"/>
                                        </svg>
                                        تلقائي
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- نص التعليق -->
                        <div class="mb-3">
                            <p class="text-sm leading-relaxed break-words"><?php echo e($comment->text); ?></p>
                        </div>

                        <!-- رسائل الرد (إذا تم إرسالها) -->
                        <?php if($comment->public_reply_sent || $comment->private_reply_sent): ?>
                            <div class="space-y-2 mr-8">
                                <?php if($comment->public_reply_sent): ?>
                                    <div class="reply-message">
                                        <div class="flex items-center gap-2 mb-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-cyan-600">
                                                <polyline points="9 17 4 12 9 7"/>
                                                <path d="m20 18-7-7 7-7"/>
                                            </svg>
                                            <span class="text-xs font-medium">رد علني:</span>
                                            <?php if($comment->replied_at): ?>
                                                <span class="text-xs text-muted-foreground"><?php echo e($comment->replied_at->diffForHumans()); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="bg-muted p-3 rounded-lg text-sm">
                                            <?php echo e($comment->public_reply_message); ?>

                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if($comment->private_reply_sent): ?>
                                    <div class="reply-message">
                                        <div class="flex items-center gap-2 mb-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                                                <rect width="20" height="16" x="2" y="4" rx="2"/>
                                                <path d="m22 7-10 5L2 7"/>
                                            </svg>
                                            <span class="text-xs font-medium">رسالة خاصة:</span>
                                            <?php if($comment->replied_at): ?>
                                                <span class="text-xs text-muted-foreground"><?php echo e($comment->replied_at->diffForHumans()); ?></span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="bg-primary/10 p-3 rounded-lg text-sm">
                                            <?php echo e($comment->private_reply_message); ?>

                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <!-- معلومات الرد التلقائي -->
                        <?php if($comment->autoReply): ?>
                            <div class="mt-3">
                                <div class="text-xs text-muted-foreground flex items-center gap-1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M12 2a2 2 0 0 1 2 2c0 .74-.4 1.39-1 1.73V7h4a2 2 0 0 1 2 2v1.28c.6-.35 1-.99 1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V22a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V10.28c-.6-.35-1-.99-1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V11h4V9.27c-.6-.34-1-.99-1-1.73a2 2 0 0 1 4 0z"/>
                                    </svg>
                                    تم الرد تلقائياً بواسطة: <span class="font-medium"><?php echo e($comment->autoReply->name); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- قائمة الإجراءات -->
                    <div class="flex-shrink-0">
                        <div class="relative">
                            <button class="comment-menu-btn inline-flex items-center justify-center whitespace-nowrap text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive hover:bg-accent hover:text-accent-foreground dark:hover:bg-accent/50 h-8 rounded-md px-2"
                                    data-comment-id="<?php echo e($comment->id); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="1"/>
                                    <circle cx="12" cy="5" r="1"/>
                                    <circle cx="12" cy="19" r="1"/>
                                </svg>
                            </button>
                            
                            <!-- قائمة منسدلة -->
                            <div class="comment-menu hidden absolute left-0 top-full mt-1 w-48 rounded-md border border-border bg-card shadow-lg z-10" data-comment-id="<?php echo e($comment->id); ?>">
                                <div class="py-1">
                                    <a href="<?php echo e(route('instagram.comments.show', $comment)); ?>" class="block w-full text-right px-4 py-2 text-sm hover:bg-accent hover:text-accent-foreground">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                            <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                                            <circle cx="12" cy="12" r="3"/>
                                        </svg>
                                        عرض التفاصيل
                                    </a>
                                    <hr class="my-1 border-border">
                                    <button class="reply-public block w-full text-right px-4 py-2 text-sm hover:bg-accent hover:text-accent-foreground"
                                            data-comment-id="<?php echo e($comment->id); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                            <polyline points="9 17 4 12 9 7"/>
                                            <path d="m20 18-7-7 7-7"/>
                                        </svg>
                                        رد علني
                                    </button>
                                    <button class="reply-private block w-full text-right px-4 py-2 text-sm hover:bg-accent hover:text-accent-foreground"
                                            data-comment-id="<?php echo e($comment->id); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                            <rect width="20" height="16" x="2" y="4" rx="2"/>
                                            <path d="m22 7-10 5L2 7"/>
                                        </svg>
                                        رسالة خاصة
                                    </button>
                                    <hr class="my-1 border-border">
                                    <?php if(!$comment->is_hidden): ?>
                                        <form method="POST" action="<?php echo e(route('instagram.comments.hide', $comment)); ?>" class="block">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="block w-full text-right px-4 py-2 text-sm text-yellow-600 hover:bg-yellow-50 hover:text-yellow-700">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                                    <path d="m9.88 9.88a3 3 0 1 0 4.24 4.24"/>
                                                    <path d="M10.73 5.08A10.43 10.43 0 0 1 12 5c7 0 10 7 10 7a13.16 13.16 0 0 1-1.67 2.68"/>
                                                    <path d="M6.61 6.61A13.526 13.526 0 0 0 2 12s3 7 10 7a9.74 9.74 0 0 0 5.39-1.61"/>
                                                    <line x1="2" y1="2" x2="22" y2="22"/>
                                                </svg>
                                                إخفاء
                                            </button>
                                        </form>
                                    <?php else: ?>
                                        <form method="POST" action="<?php echo e(route('instagram.comments.unhide', $comment)); ?>" class="block">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="block w-full text-right px-4 py-2 text-sm text-green-600 hover:bg-green-50 hover:text-green-700">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                                    <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                                                    <circle cx="12" cy="12" r="3"/>
                                                </svg>
                                                إظهار
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <form method="POST" action="<?php echo e(route('instagram.comments.process-auto-reply', $comment)); ?>" class="block">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="block w-full text-right px-4 py-2 text-sm text-cyan-600 hover:bg-cyan-50 hover:text-cyan-700">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                                <path d="M12 2a2 2 0 0 1 2 2c0 .74-.4 1.39-1 1.73V7h4a2 2 0 0 1 2 2v1.28c.6-.35 1-.99 1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V22a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V10.28c-.6-.35-1-.99-1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V11h4V9.27c-.6-.34-1-.99-1-1.73a2 2 0 0 1 4 0z"/>
                                            </svg>
                                            تشغيل الرد التلقائي
                                        </button>
                                    </form>
                                    <hr class="my-1 border-border">
                                    <button class="delete-comment block w-full text-right px-4 py-2 text-sm text-red-600 hover:bg-red-50 hover:text-red-700"
                                            data-comment-id="<?php echo e($comment->id); ?>">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline ml-2">
                                            <polyline points="3 6 5 6 21 6"/>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/>
                                            <line x1="10" y1="11" x2="10" y2="17"/>
                                            <line x1="14" y1="11" x2="14" y2="17"/>
                                        </svg>
                                        حذف
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-12">
                <div class="w-16 h-16 bg-gradient-to-br from-purple-600 via-pink-600 to-orange-500 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                        <rect width="20" height="20" x="2" y="2" rx="5" ry="5"/>
                        <path d="m13.5 8.5 2-2"/>
                        <path d="m7.5 15.5 2-2"/>
                        <circle cx="9" cy="9" r="2"/>
                        <path d="m13.5 15.5 2 2"/>
                    </svg>
                </div>
                <h5 class="text-muted-foreground text-lg font-medium mb-2">لا توجد تعليقات</h5>
                <p class="text-muted-foreground">لم يتم العثور على تعليقات بالمعايير المحددة</p>
            </div>
        <?php endif; ?>
    </div>
    
    <?php if($comments->hasPages()): ?>
        <div data-slot="card-footer" class="px-6 py-4 border-t border-border">
            <?php echo e($comments->links()); ?>

        </div>
    <?php endif; ?>
</div>

</div>

<!-- نافذة الرد -->
<div id="replyModal" class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 hidden">
    <div class="bg-card rounded-lg border shadow-lg w-full max-w-md mx-4">
        <form id="reply-form" method="POST">
            <?php echo csrf_field(); ?>
            <div class="flex items-center justify-between p-4 border-b border-border">
                <h5 class="font-semibold" id="reply-modal-title">إرسال رد</h5>
                <button type="button" class="text-muted-foreground hover:text-foreground" onclick="closeReplyModal()">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M18 6 6 18"/>
                        <path d="m6 6 12 12"/>
                    </svg>
                </button>
            </div>
            <div class="p-4 space-y-4">
                <input type="hidden" name="type" id="reply-type">
                
                <div>
                    <label class="text-sm font-medium text-foreground mb-2 block">الرسالة</label>
                    <textarea name="message" class="file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground dark:bg-input/30 border-input flex min-w-0 rounded-md border bg-transparent px-3 py-2 text-base shadow-xs transition-[color,box-shadow] outline-none resize-none md:text-sm focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full" rows="4" required 
                              placeholder="اكتب رسالة الرد هنا..."></textarea>
                </div>
                
                <div class="bg-blue-50 border border-blue-200 text-blue-700 px-4 py-3 rounded-lg flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <path d="m9 12 2 2 4-4"/>
                    </svg>
                    <span class="text-sm" id="reply-info-text">سيتم إرسال الرد</span>
                </div>
            </div>
            <div class="flex items-center justify-end gap-2 p-4 border-t border-border">
                <button type="button" class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 text-sm font-medium transition-all" onclick="closeReplyModal()">إلغاء</button>
                <button type="submit" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="m22 2-7 20-4-9-9-4Z"/>
                        <path d="M22 2L11 13"/>
                    </svg>
                    إرسال
                </button>
            </div>
        </form>
    </div>
</div>

<!-- نافذة تأكيد الحذف -->
<div id="deleteModal" class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 hidden">
    <div class="bg-card rounded-lg border shadow-lg w-full max-w-md mx-4">
        <div class="flex items-center justify-between p-4 border-b border-border">
            <h5 class="font-semibold">تأكيد الحذف</h5>
            <button type="button" class="text-muted-foreground hover:text-foreground" onclick="closeDeleteModal()">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </button>
        </div>
        <div class="p-4 space-y-4">
            <p>هل أنت متأكد من حذف هذا التعليق؟</p>
            <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3Z"/>
                    <line x1="12" y1="9" x2="12" y2="13"/>
                    <line x1="12" y1="17" x2="12.01" y2="17"/>
                </svg>
                <span class="text-sm"><strong>تحذير:</strong> هذا الإجراء لا يمكن التراجع عنه وسيحذف التعليق نهائياً من إنستقرام.</span>
            </div>
        </div>
        <div class="flex items-center justify-end gap-2 p-4 border-t border-border">
            <button type="button" class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 text-sm font-medium transition-all" onclick="closeDeleteModal()">إلغاء</button>
            <form id="delete-form" method="POST" class="inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-red-600 hover:bg-red-600/90">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="3 6 5 6 21 6"/>
                        <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/>
                        <line x1="10" y1="11" x2="10" y2="17"/>
                        <line x1="14" y1="11" x2="14" y2="17"/>
                    </svg>
                    حذف نهائي
                </button>
            </form>
        </div>
    </div>
</div>

<!-- مكان للتنبيهات -->
<div id="alerts-container" class="fixed top-4 right-4 z-50 space-y-2"></div>
<script>
  document.addEventListener("DOMContentLoaded", function() {
        // عرض رسائل الجلسة
        <?php if(session('error')): ?>
            showAlert('error', "<?php echo e(session('error')); ?>");
        <?php endif; ?>

        <?php if(session('success')): ?>
            showAlert('success', "<?php echo e(session('success')); ?>");
        <?php endif; ?>

        <?php if(session('warning')): ?>
            showAlert('warning', "<?php echo e(session('warning')); ?>");
        <?php endif; ?>

        <?php if(session('info')): ?>
            showAlert('info', "<?php echo e(session('info')); ?>");
        <?php endif; ?>
    });

    function showAlert(type, message) {
        const container = document.getElementById('alerts-container');
        if (!container) {
            console.error('Alerts container not found');
            return;
        }

        const bgColor = 
            type === 'success' ? 'bg-green-500' : 
            type === 'error' ? 'bg-red-500' :
            type === 'warning' ? 'bg-yellow-500' :
            'bg-blue-500';

        const icon = 
            type === 'success' ? 
                '<path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/>' :
            type === 'error' ?
                '<circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/>' :
            type === 'warning' ?
                '<path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/>' :
            '<circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/>';

        const alertDiv = document.createElement('div');
        alertDiv.className = `${bgColor} text-white px-4 py-3 rounded shadow-lg flex items-center gap-2 min-w-80 max-w-md transform transition-all duration-300 ease-in-out translate-x-0 opacity-100`;
        alertDiv.innerHTML = `
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                ${icon}
            </svg>
            <span class="flex-1">${message}</span>
            <button type="button" class="text-white/80 hover:text-white close-alert">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </button>
        `;

        container.appendChild(alertDiv);

        // إضافة حدث إغلاق للزر
        const closeButton = alertDiv.querySelector('.close-alert');
        closeButton.addEventListener('click', function() {
            alertDiv.style.opacity = '0';
            alertDiv.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 300);
        });

        // إزالة التنبيه تلقائياً بعد 4 ثوانٍ
        setTimeout(() => {
            alertDiv.style.opacity = '0';
            alertDiv.style.transform = 'translateX(100%)';
            setTimeout(() => {
                if (alertDiv.parentNode) {
                    alertDiv.remove();
                }
            }, 300);
        }, 4000);
    }
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    
    // إدارة القوائم المنسدلة
    document.addEventListener('click', function(e) {
        if (e.target.closest('.comment-menu-btn')) {
            const commentId = e.target.closest('.comment-menu-btn').dataset.commentId;
            const menu = document.querySelector(`.comment-menu[data-comment-id="${commentId}"]`);
            
            // إخفاء جميع القوائم الأخرى
            document.querySelectorAll('.comment-menu').forEach(m => {
                if (m !== menu) m.classList.add('hidden');
            });
            
            menu.classList.toggle('hidden');
            return;
        }

        // إخفاء القوائم عند النقر خارجها
        if (!e.target.closest('.comment-menu')) {
            document.querySelectorAll('.comment-menu').forEach(menu => {
                menu.classList.add('hidden');
            });
        }
    });

    // معالج الرد العلني
    document.addEventListener('click', function(e) {
        if (e.target.closest('.reply-public')) {
            const commentId = e.target.closest('.reply-public').dataset.commentId;
            showReplyModal(commentId, 'public');
        }
    });

    // معالج الرسالة الخاصة
    document.addEventListener('click', function(e) {
        if (e.target.closest('.reply-private')) {
            const commentId = e.target.closest('.reply-private').dataset.commentId;
            showReplyModal(commentId, 'private');
        }
    });

    // معالج حذف التعليق
    document.addEventListener('click', function(e) {
        if (e.target.closest('.delete-comment')) {
            const commentId = e.target.closest('.delete-comment').dataset.commentId;
            confirmDelete(commentId);
        }
    });
});

function showReplyModal(commentId, type) {
    const modal = document.getElementById('replyModal');
    const form = document.getElementById('reply-form');
    const title = document.getElementById('reply-modal-title');
    const typeInput = document.getElementById('reply-type');
    const infoText = document.getElementById('reply-info-text');
    
    form.action = `/instagram/comments/${commentId}/reply`;
    typeInput.value = type;
    
    if (type === 'public') {
        title.textContent = 'إرسال رد علني';
        infoText.textContent = 'سيتم نشر هذا الرد كتعليق علني على المنشور';
    } else {
        title.textContent = 'إرسال رسالة خاصة';
        infoText.textContent = 'سيتم إرسال هذه الرسالة كرسالة خاصة للمعلق';
    }
    
    modal.classList.remove('hidden');
}

function closeReplyModal() {
    document.getElementById('replyModal').classList.add('hidden');
}

function confirmDelete(commentId) {
    const form = document.getElementById('delete-form');
    form.action = `/instagram/comments/${commentId}`;
    document.getElementById('deleteModal').classList.remove('hidden');
}

function closeDeleteModal() {
    document.getElementById('deleteModal').classList.add('hidden');
}

function selectAll() {
    const checkboxes = document.querySelectorAll('.comment-checkbox');
    const allChecked = Array.from(checkboxes).every(cb => cb.checked);
    checkboxes.forEach(cb => cb.checked = !allChecked);
}

function bulkAction(action) {
    const selectedIds = Array.from(document.querySelectorAll('.comment-checkbox:checked'))
        .map(cb => cb.value);
    
    if (selectedIds.length === 0) {
        alert('يرجى تحديد التعليقات أولاً');
        return;
    }
    
    if (confirm(`هل أنت متأكد من ${action === 'hide' ? 'إخفاء' : 'إظهار'} ${selectedIds.length} تعليق؟`)) {
        selectedIds.forEach(id => {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/instagram/comments/${id}/${action}`;
            form.innerHTML = '<?php echo csrf_field(); ?>';
            document.body.appendChild(form);
            form.submit();
        });
    }
}

function refreshComments() {
    window.location.reload();
}

// إغلاق النوافذ عند النقر خارجها أو الضغط على Escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeReplyModal();
        closeDeleteModal();
    }
});

window.addEventListener('click', function(e) {
    if (e.target === document.getElementById('replyModal')) {
        closeReplyModal();
    }
    if (e.target === document.getElementById('deleteModal')) {
        closeDeleteModal();
    }
});

// تحديث تلقائي كل 30 ثانية
setInterval(function() {
    if (!document.hidden) {
        // اختياري: إضافة تحديث AJAX بدلاً من إعادة تحميل الصفحة الكاملة
        // refreshComments();
    }
}, 30000);
</script>

<style>
/* تأثيرات إضافية للبطاقات */
.stats-card {
    transition: all 0.2s ease;
}

.stats-card:hover {
    transform: translateY(-2px);
}

.comment-item:hover {
    background-color: rgb(248 250 252 / 0.5);
}

/* تحسين مظهر النصوص */
.comment-text p {
    line-height: 1.6;
    word-break: break-word;
}

/* تحسين الشارات */
.reply-message {
    margin-right: 2rem;
}

/* تأثيرات الانتقال للنوافذ المنبثقة */
#replyModal, #deleteModal {
    animation: fadeIn 0.2s ease-out;
}

@keyframes fadeIn {
    from {
        opacity: 0;
        transform: scale(0.95);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}

/* تحسين التجاوب */
@media (max-width: 1024px) {
    .grid.grid-cols-2.md\\:grid-cols-3.lg\\:grid-cols-6 {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 768px) {
    .grid.grid-cols-2.md\\:grid-cols-3.lg\\:grid-cols-6 {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .grid.grid-cols-1.md\\:grid-cols-2.lg\\:grid-cols-6 {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 640px) {
    .grid.grid-cols-2.md\\:grid-cols-3.lg\\:grid-cols-6 {
        grid-template-columns: 1fr;
    }
}
</style>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/instagram/comments/index.blade.php ENDPATH**/ ?>