<div class="flex-shrink-0">
    <header class="bg-card border-b border-border p-2 sm:p-4 shadow-sm">
        <div class="flex items-center justify-between gap-4 max-w-full mx-auto">
        
            <!-- زر القائمة للعرض على الأجهزة الصغيرة -->
            <div class="flex items-center gap-4">
                <button data-slot="button" class="lg:hidden inline-flex items-center justify-center gap-2 rounded-md text-sm font-medium transition hover:bg-accent hover:text-accent-foreground p-2">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                        <line x1="4" y1="6" x2="20" y2="6"/>
                        <line x1="4" y1="12" x2="20" y2="12"/>
                        <line x1="4" y1="18" x2="20" y2="18"/>
                    </svg>
                </button>

               
            </div>
            
            <!-- أزرار التحكم والتبديل -->
            <div class="flex items-center gap-3 sm:gap-4">
                
                <?php if(session()->has('impersonate')): ?>
                    <form method="POST" action="<?php echo e(route('admin.users.stopImpersonate')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-emerald-700 text-white rounded-md px-3 py-1 text-sm hover:bg-emerald-600">
                            <?php echo e(__('إيقاف التمثيل')); ?>

                        </button>
                    </form>
                <?php endif; ?>

                <!-- زر تبديل الوضع (داكن/فاتح) -->
                <button id="toggleModeBtn" class="inline-flex items-center justify-center rounded-md p-2 text-sm text-muted hover:bg-accent hover:text-accent-foreground transition focus:outline-none focus:ring-2 focus:ring-ring">
                    <span id="modeIcon">
                        <svg id="sunIcon" class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24" style="display:none;">
                            <circle cx="12" cy="12" r="4"/>
                            <path d="M12 2v2M12 20v2M4.93 4.93l1.41 1.41M17.66 17.66l1.41 1.41M2 12h2M20 12h2M6.34 17.66l-1.41 1.41M19.07 4.93l-1.41 1.41"/>
                        </svg>
                        <svg id="moonIcon" class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24" style="display:none;">
                            <path d="M12 3a6 6 0 0 0 9 9 9 9 0 1 1-9-9Z"/>
                        </svg>
                    </span>
                </button>

                <!-- زر تغيير اللغة -->
                <a href="<?php echo e(route('lang.switch', app()->getLocale() === 'ar' ? 'en' : 'ar')); ?>" class="inline-flex items-center gap-1 rounded-md bg-primary px-4 py-2 text-primary-foreground shadow hover:bg-primary/90 transition text-sm">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <circle cx="12" cy="12" r="10"/>
                        <line x1="2" y1="12" x2="22" y2="12"/>
                        <path d="M12 2a15.3 15.3 0 0 1 0 20"/>
                        <path d="M12 2a15.3 15.3 0 0 0 0 20"/>
                    </svg>
                    <span class="font-bold">
                        <?php echo e(app()->getLocale() === 'ar' ? 'EN' : 'AR'); ?>

                    </span>
                </a>

                <!-- زر الملف الشخصي -->
             <!-- زر الملف الشخصي مع القائمة المنسدلة -->
 <div class="relative lg:hidden">
    <button id="profile-menu-button" class="inline-flex items-center rounded-md bg-primary px-3 py-2 text-primary-foreground shadow hover:bg-primary/90 transition focus:outline-none focus:ring-2 focus:ring-ring" aria-expanded="false" aria-haspopup="true">
        <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
            <path d="M12 12c2.7 0 4.8-2.1 4.8-4.8S14.7 2.4 12 2.4 7.2 4.5 7.2 7.2 9.3 12 12 12z"/>
            <path d="M21 21v-2a4 4 0 0 0-4-4H7a4 4 0 0 0-4 4v2"/>
        </svg>
        <svg class="h-4 w-4 ml-1" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
            <path d="M6 9l6 6 6-6"/>
        </svg>
    </button>
    
    <!-- القائمة المنسدلة -->
    <div id="profile-dropdown" class="hidden absolute left-0 mt-2 w-56 bg-white dark:bg-gray-800 rounded-md shadow-lg z-50 border border-gray-200 dark:border-gray-700">
        <div class="py-1">
            <!-- معلومات المستخدم -->
            <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 bg-primary rounded-full flex items-center justify-center">
                        <span class="text-primary-foreground text-sm font-medium">
                            <?php echo e(strtoupper(substr(auth()->user()->name, 0, 2))); ?>

                        </span>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-gray-900 dark:text-white truncate"><?php echo e(auth()->user()->name); ?></p>
                        <p class="text-xs text-gray-500 dark:text-gray-400 truncate"><?php echo e(auth()->user()->email); ?></p>
                    </div>
                </div>
            </div>

            <!-- خيارات القائمة -->
            <a href="<?php echo e(route('profile.update')); ?>" class="flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <path d="M12 12c2.7 0 4.8-2.1 4.8-4.8S14.7 2.4 12 2.4 7.2 4.5 7.2 7.2 9.3 12 12 12z"/>
                    <path d="M21 21v-2a4 4 0 0 0-4-4H7a4 4 0 0 0-4 4v2"/>
                </svg>
                <?php echo e(__('الملف الشخصي')); ?>

            </a>

            <a href="/plans" class="flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"/>
                </svg>
                <?php echo e(__('الباقات والاشتراكات')); ?>

            
                <?php if(auth()->user()->plan_id): ?>
                <span class="ml-auto bg-green-100 text-green-800 text-xs px-2 py-0.5 rounded-full">
                    <?php echo e(__('نشط')); ?>

                </span>
                <?php endif; ?>
            </a>


            <div class="border-t border-gray-200 dark:border-gray-700">
                <form method="POST" action="<?php echo e(route('logout')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full flex items-center gap-3 px-4 py-2 text-sm text-red-600 dark:text-red-400 hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M16 17l5-5-5-5"/>
                            <path d="M19 12H9"/>
                            <path d="M10 3H4v18h6"/>
                        </svg>
                        <?php echo e(__('تسجيل الخروج')); ?>

                    </button>
                </form>
            </div>
        </div>
    </div>
</div>   

<!-- JavaScript للتحكم في القائمة المنسدلة -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const button = document.getElementById('profile-menu-button');
    const dropdown = document.getElementById('profile-dropdown');

    button.addEventListener('click', function (e) {
        e.stopPropagation();
        dropdown.classList.toggle('hidden');
        
        // تحديث حالة aria-expanded
        const isExpanded = !dropdown.classList.contains('hidden');
        button.setAttribute('aria-expanded', isExpanded);
    });

    // إغلاق القائمة عند النقر خارجها
    document.addEventListener('click', function (e) {
        if (!button.contains(e.target) && !dropdown.contains(e.target)) {
            dropdown.classList.add('hidden');
            button.setAttribute('aria-expanded', 'false');
        }
    });

    // إغلاق القائمة عند الضغط على Escape
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape' && !dropdown.classList.contains('hidden')) {
            dropdown.classList.add('hidden');
            button.setAttribute('aria-expanded', 'false');
            button.focus();
        }
    });
});
</script>
        <!-- إعدادات المسؤول (يظهر للمسؤول فقط) -->
                <?php if(auth()->user()->role === 'admin'): ?>
                    <a href="<?php echo e(route('admin.settings.edit')); ?>" class="hidden sm:inline-flex items-center rounded-md p-2 text-muted hover:bg-accent hover:text-accent-foreground transition" title="<?php echo e(__('الإعدادات')); ?>">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-.09a1.65 1.65 0 0 0-1-1.51 1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82A1.65 1.65 0 0 0 3 12.91V12a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v.09c0 .67.39 1.26.99 1.51z"/>
                        </svg>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </header>
</div>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/partials/navbar.blade.php ENDPATH**/ ?>