<!-- Desktop Sidebar -->
<div class="hidden lg:flex w-64 bg-sidebar text-sidebar-foreground flex-col h-screen overflow-hidden">

    <!-- Logo Header -->
    <div class="p-4 border-b border-sidebar-border flex-shrink-0 flex items-center gap-2">
        <?php echo $__env->make('components.application-logo', ['class' => 'w-8 h-8 text-primary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <span class="text-2xl font-bold text-flex items-center gap-2"><?php echo e(config('app.name', 'Laravel')); ?></span>
    </div>

    <!-- Navigation -->
    <div class="flex-1 p-4 overflow-y-auto">
        <nav class="space-y-6">

            <!-- Dashboard -->
            <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('dashboard') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-layout-dashboard h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <rect x="3" y="3" width="7" height="9" rx="1"/>
                    <rect x="14" y="3" width="7" height="5" rx="1"/>
                    <rect x="14" y="12" width="7" height="9" rx="1"/>
                    <rect x="3" y="16" width="7" height="5" rx="1"/>
                </svg>
                <span class="flex-1 truncate"><?php echo e(__('messages.dashboard')); ?></span>
            </a>

            <!-- Facebook Section -->
            <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">FACEBOOK</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('auto-replies.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('auto-replies.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-bolt h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Comment Automation')); ?> </span>
                    </a>
                    
                      <a href="<?php echo e(route('messenger-flows.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('messenger-flows.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-robot h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
        <rect width="18" height="18" x="3" y="11" rx="2"></rect>
        <circle cx="12" cy="5" r="2"></circle>
        <path d="M12 7v4"></path>
        <path d="M8 16h.01"></path>
        <path d="M16 16h.01"></path>
    </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Chatbot')); ?> </span>
                    </a>
                    

                      <a href="<?php echo e(route('messenger-inbox.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('messenger-inbox.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-message-circle h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M21 11.5a8.38 8.38 0 0 1-7 8.38c-4.39.42-8-3.29-8-7.6C6 7 9.66 3.5 14 3.5c1.74 0 3.41.73 4.59 2"/>
                            <path d="M22 2l-9.5 9.5"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Live Chat')); ?> </span>
                    </a> 

                    <a href="<?php echo e(route('facebook-pages.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('facebook-pages.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-layout h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <rect x="3" y="3" width="18" height="7" rx="1"/>
                            <rect x="3" y="14" width="18" height="7" rx="1"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Pages Manager')); ?></span>
                        <span class="bg-primary text-primary-foreground text-xs px-2 py-0.5 rounded-full flex-shrink-0"><?php echo e(auth()->user()->facebookPages()->count()); ?></span>
                    </a>

                    <a href="<?php echo e(route('facebook-posts.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('facebook-posts.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-send h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <line x1="22" y1="2" x2="11" y2="13"/>
                            <polygon points="22 2 15 22 11 13 2 9 22 2"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Pages Posting')); ?></span>
                    </a>

                    <a href="<?php echo e(route('comments.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('comments.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-message-square h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Comment Logs')); ?></span>
                    </a>
                </nav>
            </div>

            <!-- Instagram Section -->
            <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">INSTAGRAM</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('instagram.auto-replies.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.auto-replies.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-zap h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.IG Comment Automation')); ?></span>
                    </a>
                     <a href="<?php echo e(route('instagram.chatbot.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.chatbot.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-robot h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
        <rect width="18" height="18" x="3" y="11" rx="2"></rect>
        <circle cx="12" cy="5" r="2"></circle>
        <path d="M12 7v4"></path>
        <path d="M8 16h.01"></path>
        <path d="M16 16h.01"></path>
    </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Chatbot')); ?></span>
                    </a>

                    <a href="<?php echo e(route('instagram.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-users h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.IG Account Management')); ?> </span>
                        <span class="bg-primary text-primary-foreground text-xs px-2 py-0.5 rounded-full flex-shrink-0"><?php echo e(auth()->user()->instagramAccounts()->count()); ?></span>
                    </a>

                    <a href="<?php echo e(route('instagram.posts.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.posts.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-image h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                            <circle cx="8.5" cy="8.5" r="1.5"/>
                            <path d="M21 15l-5-5L5 21"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.IG Posting')); ?> </span>
                    </a>

                    <a href="<?php echo e(route('instagram.comments.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.comments.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-message-square h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Comment Moderation')); ?> </span>
                    </a>
                </nav>
            </div>
            
             <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">AI keys</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('ai-keys.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('ai-keys.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
       <svg width="1em" height="1em" viewBox="0 0 24 24" class="lucide lucide-message-square h-5 w-5 flex-shrink-0"  fill="currentColor"><path fill-rule="evenodd" clip-rule="evenodd" d="M15 4C12.2386 4 10 6.23858 10 9C10 9.50683 10.0751 9.99431 10.2141 10.4529C10.3211 10.8059 10.225 11.1892 9.96418 11.45L5.14645 16.2678C5.05268 16.3615 5 16.4887 5 16.6213V19H7.37868C7.51129 19 7.63847 18.9473 7.73223 18.8536L8.5 18.0858V16.5C8.5 15.9477 8.94772 15.5 9.5 15.5H11.0858L12.55 14.0358C12.8108 13.775 13.1941 13.6789 13.5471 13.7859C14.0057 13.9249 14.4932 14 15 14C17.7614 14 20 11.7614 20 9C20 6.23858 17.7614 4 15 4ZM8 9C8 5.13401 11.134 2 15 2C18.866 2 22 5.13401 22 9C22 12.866 18.866 16 15 16C14.508 16 14.0269 15.9491 13.5622 15.852L12.2071 17.2071C12.0196 17.3946 11.7652 17.5 11.5 17.5H10.5V18.5C10.5 18.7652 10.3946 19.0196 10.2071 19.2071L9.14645 20.2678C8.67761 20.7366 8.04172 21 7.37868 21H4C3.44772 21 3 20.5523 3 20V16.6213C3 15.9583 3.26339 15.3224 3.73223 14.8536L8.14801 10.4378C8.05092 9.97307 8 9.49204 8 9Z"></path><path d="M17.75 8C17.75 8.9665 16.9665 9.75 16 9.75C15.0335 9.75 14.25 8.9665 14.25 8C14.25 7.0335 15.0335 6.25 16 6.25C16.9665 6.25 17.75 7.0335 17.75 8Z"></path></svg>
                        <span class="truncate"><?php echo e(__('messages.AI api token')); ?></span>
                    </a>
                </nav>
            </div>
            

            <!-- Admin Section -->
            <?php if(auth()->user()->role === 'admin'): ?>
            <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">Admin</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('admin.settings.edit')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/settings') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-settings-2 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-.09a1.65 1.65 0 0 0-1-1.51 1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82A1.65 1.65 0 0 0 3 12.91V12a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v.09c0 .67.39 1.26.99 1.51z"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.settings')); ?></span>
                    </a>

                    <a href="<?php echo e(route('admin.plans.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/plans') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-shield h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.plan')); ?></span>
                    </a>

                    <a href="<?php echo e(route('admin.users.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/users') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-users h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.users')); ?></span>
                    </a>

                    <a href="<?php echo e(route('admin.coupons.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/coupons') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-ticket h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M3 10v4a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-4"/>
                            <path d="M7 10V7a5 5 0 0 1 10 0v3"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.coupons')); ?></span>
                    </a>
                       <a href="<?php echo e(route('admin.email-logs.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/coupons') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-ticket h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M3 10v4a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-4"/>
                            <path d="M7 10V7a5 5 0 0 1 10 0v3"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.email logs')); ?></span>
                    </a>
                </nav>
            </div>
            <?php endif; ?>
        </nav>
    </div>

    <!-- User info and logout -->
   <!-- User info and profile menu -->
<div class="p-4 border-t border-sidebar-border flex-shrink-0 sticky bottom-0">
    <div class="relative">
        <button id="user-profile-button" class="w-full flex items-center gap-3 p-2 rounded-lg hover:bg-sidebar-accent transition-colors focus:outline-none focus:ring-2 focus:ring-ring" aria-expanded="false" aria-haspopup="true">
            <div class="w-8 h-8 bg-primary rounded-full flex items-center justify-center flex-shrink-0">
                <span class="text-primary-foreground text-sm font-medium"><?php echo e(strtoupper(substr(auth()->user()->name, 0, 2))); ?></span>
            </div>
            <div class="flex-1 min-w-0 text-left">
                <p class="text-sm font-medium text-sidebar-foreground truncate"><?php echo e(auth()->user()->name); ?></p>
                <p class="text-xs text-sidebar-foreground/60 truncate"><?php echo e(auth()->user()->email); ?></p>
            </div>
            <div class="flex-shrink-0">
                <svg id="user-profile-arrow" class="h-4 w-4 text-sidebar-foreground/60 transition-transform" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <path d="M6 9l6 6 6-6"/>
                </svg>
            </div>
        </button>
        
        <!-- القائمة المنسدلة -->
        <div id="user-profile-dropdown" class="hidden absolute bottom-full left-0 right-0 mb-2 bg-white dark:bg-gray-800 rounded-lg shadow-lg border border-gray-200 dark:border-gray-700 z-50">
            <div class="py-2">
                <!-- معلومات المستخدم -->
                <div class="px-4 py-3 border-b border-gray-200 dark:border-gray-700">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 bg-primary rounded-full flex items-center justify-center">
                            <span class="text-primary-foreground text-base font-medium">
                                <?php echo e(strtoupper(substr(auth()->user()->name, 0, 2))); ?>

                            </span>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-sm font-medium text-gray-900 dark:text-white truncate"><?php echo e(auth()->user()->name); ?></p>
                            <p class="text-xs text-gray-500 dark:text-gray-400 truncate"><?php echo e(auth()->user()->email); ?></p>
                            
                        </div>
                    </div>
                </div>

                <!-- خيارات القائمة -->
                <div class="py-1">
               

                    <a href="<?php echo e(route('plans.index')); ?>" class="flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"/>
                        </svg>
                        <?php echo e(__('en.Subscription & Credits')); ?>

                      <?php if(auth()->user()->plan): ?>
                                <span class="inline-flex items-center rounded-full bg-green-100 px-2 py-0.5 text-xs font-medium text-green-800 mt-1">
                                    <?php echo e(__('نشط')); ?>

                                </span>
                            <?php endif; ?>
                    </a>

                  

                    <a href="/profile" class="flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M12 12c2.7 0 4.8-2.1 4.8-4.8S14.7 2.4 12 2.4 7.2 4.5 7.2 7.2 9.3 12 12 12z"/>
                            <path d="M21 21v-2a4 4 0 0 0-4-4H7a4 4 0 0 0-4 4v2"/>
                        </svg>
                        <?php echo e(__('en.Account')); ?>

                    </a>
                </div>

                <!-- خط فاصل وزر تسجيل الخروج -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-1">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full flex items-center gap-3 px-4 py-2 text-sm text-red-600 dark:text-red-400 hover:bg-gray-100 dark:hover:bg-gray-700 transition">
                            <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                <path d="M16 17l5-5-5-5"/>
                                <path d="M19 12H9"/>
                                <path d="M10 3H4v18h6"/>
                            </svg>
                            <?php echo e(__('en.Log Out')); ?>

                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript للتحكم في القائمة المنسدلة -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const button = document.getElementById('user-profile-button');
    const dropdown = document.getElementById('user-profile-dropdown');
    const arrow = document.getElementById('user-profile-arrow');

    button.addEventListener('click', function (e) {
        e.stopPropagation();
        const isHidden = dropdown.classList.contains('hidden');
        
        if (isHidden) {
            dropdown.classList.remove('hidden');
            arrow.style.transform = 'rotate(180deg)';
            button.setAttribute('aria-expanded', 'true');
        } else {
            dropdown.classList.add('hidden');
            arrow.style.transform = 'rotate(0deg)';
            button.setAttribute('aria-expanded', 'false');
        }
    });

    // إغلاق القائمة عند النقر خارجها
    document.addEventListener('click', function (e) {
        if (!button.contains(e.target) && !dropdown.contains(e.target)) {
            dropdown.classList.add('hidden');
            arrow.style.transform = 'rotate(0deg)';
            button.setAttribute('aria-expanded', 'false');
        }
    });

    // إغلاق القائمة عند الضغط على Escape
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape' && !dropdown.classList.contains('hidden')) {
            dropdown.classList.add('hidden');
            arrow.style.transform = 'rotate(0deg)';
            button.setAttribute('aria-expanded', 'false');
            button.focus();
        }
    });
});
</script>

</div>

<!-- Mobile Sidebar -->
<div class="fixed inset-y-0 left-0 z-50 w-64 bg-sidebar text-sidebar-foreground flex flex-col transform transition-transform duration-300 ease-in-out lg:hidden overflow-hidden -translate-x-full">

    <div class="flex items-center justify-between p-6 border-b border-sidebar-border flex-shrink-0">
        <div class="flex items-center gap-2">
            <?php echo $__env->make('components.application-logo', ['class' => 'w-8 h-8 text-primary'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <span class="text-2xl font-bold text-flex items-center gap-2"><?php echo e(config('app.name', 'Laravel')); ?></span>
        </div>
        <button data-slot="button" class="inline-flex items-center justify-center rounded-md p-2 text-sidebar-foreground hover:bg-accent-foreground dark:hover:bg-accent/50 focus:outline-none focus:ring-2 focus:ring-ring">
            <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-x h-6 w-6" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                <path d="M18 6 6 18"/>
                <path d="M6 6l12 12"/>
            </svg>
        </button>
    </div>

 

    <!-- Navigation -->
    <div class="flex-1 p-4 overflow-y-auto">
        <nav class="space-y-6">

            <!-- Dashboard -->
            <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('dashboard') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-layout-dashboard h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <rect x="3" y="3" width="7" height="9" rx="1"/>
                    <rect x="14" y="3" width="7" height="5" rx="1"/>
                    <rect x="14" y="12" width="7" height="9" rx="1"/>
                    <rect x="3" y="16" width="7" height="5" rx="1"/>
                </svg>
                <span class="flex-1 truncate"><?php echo e(__('messages.dashboard')); ?></span>
            </a>

            <!-- Facebook Section -->
            <!-- Facebook Section -->
            <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">FACEBOOK</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('auto-replies.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('auto-replies.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-bolt h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Comment Automation')); ?> </span>
                    </a>

   <a href="<?php echo e(route('messenger-flows.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('messenger-flows.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-robot h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
        <rect width="18" height="18" x="3" y="11" rx="2"></rect>
        <circle cx="12" cy="5" r="2"></circle>
        <path d="M12 7v4"></path>
        <path d="M8 16h.01"></path>
        <path d="M16 16h.01"></path>
    </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Chatbot')); ?> </span>
                    </a>
                    

                      <a href="<?php echo e(route('messenger-inbox.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('messenger-inbox.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-message-circle h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M21 11.5a8.38 8.38 0 0 1-7 8.38c-4.39.42-8-3.29-8-7.6C6 7 9.66 3.5 14 3.5c1.74 0 3.41.73 4.59 2"/>
                            <path d="M22 2l-9.5 9.5"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Live Chat')); ?> </span>
                    </a> 


              

                    <a href="<?php echo e(route('facebook-pages.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('facebook-pages.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-layout h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <rect x="3" y="3" width="18" height="7" rx="1"/>
                            <rect x="3" y="14" width="18" height="7" rx="1"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Pages Manager')); ?></span>
                        <span class="bg-primary text-primary-foreground text-xs px-2 py-0.5 rounded-full flex-shrink-0"><?php echo e(auth()->user()->facebookPages()->count()); ?></span>
                    </a>

                    <a href="<?php echo e(route('facebook-posts.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('facebook-posts.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-send h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <line x1="22" y1="2" x2="11" y2="13"/>
                            <polygon points="22 2 15 22 11 13 2 9 22 2"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Pages Posting')); ?></span>
                    </a>

                    <a href="<?php echo e(route('comments.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('comments.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-message-square h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Comment Logs')); ?></span>
                    </a>
                </nav>
            </div>

            <!-- Instagram Section -->
            <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">INSTAGRAM</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('instagram.auto-replies.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.auto-replies.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-zap h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.IG Comment Automation')); ?></span>
                    </a>
          <a href="<?php echo e(route('instagram.chatbot.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.chatbot.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-robot h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
        <rect width="18" height="18" x="3" y="11" rx="2"></rect>
        <circle cx="12" cy="5" r="2"></circle>
        <path d="M12 7v4"></path>
        <path d="M8 16h.01"></path>
        <path d="M16 16h.01"></path>
    </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Chatbot')); ?></span>
                    </a>
                    <a href="<?php echo e(route('instagram.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.index') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-users h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.IG Account Management')); ?> </span>
                        <span class="bg-primary text-primary-foreground text-xs px-2 py-0.5 rounded-full flex-shrink-0"><?php echo e(auth()->user()->instagramAccounts()->count()); ?></span>
                    </a>

                    <a href="<?php echo e(route('instagram.posts.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.posts.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-image h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                            <circle cx="8.5" cy="8.5" r="1.5"/>
                            <path d="M21 15l-5-5L5 21"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.IG Posting')); ?> </span>
                    </a>

                    <a href="<?php echo e(route('instagram.comments.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm transition-colors <?php echo e(request()->routeIs('instagram.comments.*') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-message-square h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2z"/>
                        </svg>
                        <span class="flex-1 truncate"><?php echo e(__('en.Comment Moderation')); ?> </span>
                    </a>
                </nav>
            </div>
             <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">API keys</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('admin.settings.edit')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/settings') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                          <svg width="1em" height="1em" viewBox="0 0 24 24" class="lucide lucide-message-square h-5 w-5 flex-shrink-0"  fill="currentColor"><path fill-rule="evenodd" clip-rule="evenodd" d="M15 4C12.2386 4 10 6.23858 10 9C10 9.50683 10.0751 9.99431 10.2141 10.4529C10.3211 10.8059 10.225 11.1892 9.96418 11.45L5.14645 16.2678C5.05268 16.3615 5 16.4887 5 16.6213V19H7.37868C7.51129 19 7.63847 18.9473 7.73223 18.8536L8.5 18.0858V16.5C8.5 15.9477 8.94772 15.5 9.5 15.5H11.0858L12.55 14.0358C12.8108 13.775 13.1941 13.6789 13.5471 13.7859C14.0057 13.9249 14.4932 14 15 14C17.7614 14 20 11.7614 20 9C20 6.23858 17.7614 4 15 4ZM8 9C8 5.13401 11.134 2 15 2C18.866 2 22 5.13401 22 9C22 12.866 18.866 16 15 16C14.508 16 14.0269 15.9491 13.5622 15.852L12.2071 17.2071C12.0196 17.3946 11.7652 17.5 11.5 17.5H10.5V18.5C10.5 18.7652 10.3946 19.0196 10.2071 19.2071L9.14645 20.2678C8.67761 20.7366 8.04172 21 7.37868 21H4C3.44772 21 3 20.5523 3 20V16.6213C3 15.9583 3.26339 15.3224 3.73223 14.8536L8.14801 10.4378C8.05092 9.97307 8 9.49204 8 9Z"></path><path d="M17.75 8C17.75 8.9665 16.9665 9.75 16 9.75C15.0335 9.75 14.25 8.9665 14.25 8C14.25 7.0335 15.0335 6.25 16 6.25C16.9665 6.25 17.75 7.0335 17.75 8Z"></path></svg>
                        <span class="truncate"><?php echo e(__('messages.AI api token')); ?></span>
                    </a>
                </nav>
            </div>
    
            <!-- Admin Section -->
            <?php if(auth()->user()->role === 'admin'): ?>
            <div>
                <h3 class="text-xs font-semibold text-sidebar-foreground/60 uppercase tracking-wider mb-3">Admin</h3>
                <nav class="space-y-1">
                    <a href="<?php echo e(route('admin.settings.edit')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/settings') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-settings-2 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2h-1a2 2 0 0 1-2-2v-.09a1.65 1.65 0 0 0-1-1.51 1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82A1.65 1.65 0 0 0 3 12.91V12a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2h1a2 2 0 0 1 2 2v.09c0 .67.39 1.26.99 1.51z"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.settings')); ?></span>
                    </a>

                    <a href="<?php echo e(route('admin.plans.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/plans') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-shield h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.plan')); ?></span>
                    </a>

                    <a href="<?php echo e(route('admin.users.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/users') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-users h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.users')); ?></span>
                    </a>

                    <a href="<?php echo e(route('admin.coupons.index')); ?>" class="flex items-center gap-3 px-3 py-2 rounded-lg text-sm <?php echo e(request()->is('admin/coupons') ? 'bg-primary text-primary-foreground' : 'text-sidebar-foreground/80 hover:bg-sidebar-accent hover:text-sidebar-accent-foreground'); ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" class="lucide lucide-ticket h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M3 10v4a1 1 0 0 0 1 1h16a1 1 0 0 0 1-1v-4"/>
                            <path d="M7 10V7a5 5 0 0 1 10 0v3"/>
                        </svg>
                        <span class="truncate"><?php echo e(__('messages.coupons')); ?></span>
                    </a>
                </nav>
            </div>
            <?php endif; ?>
        </nav>
    </div>

  
    
    </div>

<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/partials/sidebar.blade.php ENDPATH**/ ?>