<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            الباقات المتاحة
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto p-6">
        <!-- رأس الصفحة -->
        <div class="text-center mb-6">
            <h1 class="text-4xl font-bold text-foreground mb-4"><?php echo e(__('messages.choose_your_plan')); ?></h1>
            <p class="text-xl text-muted-foreground max-w-2xl mx-auto"><?php echo e(__('messages.select_perfect_plan')); ?></p>
        </div>

        <?php
        // Helper function to get feature names in Arabic
        function getFeatureName($key) {
            $names = [
                'facebook_accounts' => 'حسابات فيسبوك',
                'instagram_accounts' => 'حسابات إنستقرام',
                'facebook_pages' => 'صفحات فيسبوك',
                'facebook_groups' => 'مجموعات فيسبوك',
                'facebook_posts' => 'منشورات فيسبوك شهرياً',
                'instagram_posts' => 'منشورات إنستقرام شهرياً',
                'scheduled_posts' => 'منشورات مجدولة',
                'facebook_auto_replies' => 'ردود فيسبوك التلقائية',
                'instagram_auto_replies' => 'ردود إنستقرام التلقائية',
                'auto_replies' => 'إجمالي الردود التلقائية',
                'quick_replies' => 'ردود سريعة محفوظة',
                'team_members' => 'أعضاء الفريق',
                'api_requests' => 'طلبات API شهرياً',
                'integrations' => 'تكاملات خارجية',
                'analytics_retention_days' => 'الاحتفاظ بالتحليلات (يوم)',
                'report_exports' => 'تصدير التقارير شهرياً',
                'media_storage' => 'مساحة تخزين الوسائط (GB)',
                'support_level' => 'مستوى الدعم',
                'advanced_analytics' => 'تحليلات متقدمة',
                'white_label' => 'علامة تجارية مخصصة',
                'priority_support' => 'دعم فني أولوية',
                'custom_branding' => 'شعار مخصص',
                'bulk_operations' => 'عمليات مجمعة',
                'webhook_access' => 'الوصول لـ Webhooks'
            ];
            
            return $names[$key] ?? ucfirst(str_replace('_', ' ', $key));
        }
        ?>
           
        <!-- رسائل النجاح والخطأ -->
        <?php if(request('success')): ?>
            <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <h3 class="text-green-800 font-medium">تم الدفع بنجاح!</h3>
                        <p class="text-green-700 text-sm"><?php echo e(__('messages.✅ Payment successful! Your subscription is activated and you can now enjoy the plan benefits.')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg">
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-red-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <h3 class="text-red-800 font-medium">وصلت للحد الأقصى!</h3>
                        <p class="text-red-700 text-sm mt-1"><?php echo e(session('error')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if(session('success')): ?>
            <div class="mb-6 p-4 bg-green-50 border border-green-200 rounded-lg">
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-green-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <p class="text-green-700 font-medium"><?php echo e(session('success')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

        <!-- عرض الاستخدام الحالي للباقة النشطة -->
<!-- عرض الاستخدام الحالي للباقة النشطة - تصميم مضغوط -->
<?php if(auth()->user()->plan): ?>
    <?php
        $user = auth()->user();
        $currentPlan = $user->plan;
        
        // تجميع المزايا الأساسية فقط
        $usageData = [
            'facebook_accounts' => [
                'name' => 'حسابات FB',
                'icon' => 'fab fa-facebook-f',
                'color' => 'blue',
                'current' => $user->getFeatureUsage('facebook_accounts'),
                'max' => $currentPlan->getFeatureLimit('facebook_accounts'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('facebook_accounts')
            ],
            'instagram_accounts' => [
                'name' => 'حسابات IG',
                'icon' => 'fab fa-instagram',
                'color' => 'pink',
                'current' => $user->getFeatureUsage('instagram_accounts'),
                'max' => $currentPlan->getFeatureLimit('instagram_accounts'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('instagram_accounts')
            ],
            'facebook_pages' => [
                'name' => 'صفحات FB',
                'icon' => 'fas fa-users',
                'color' => 'indigo',
                'current' => $user->getFeatureUsage('facebook_pages'),
                'max' => $currentPlan->getFeatureLimit('facebook_pages'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('facebook_pages')
            ],
            'facebook_auto_replies' => [
                'name' => 'ردود FB',
                'icon' => 'fas fa-robot',
                'color' => 'green',
                'current' => $user->getFeatureUsage('facebook_auto_replies'),
                'max' => $currentPlan->getFeatureLimit('facebook_auto_replies'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('facebook_auto_replies')
            ],
            'instagram_auto_replies' => [
                'name' => 'ردود IG',
                'icon' => 'fas fa-reply-all',
                'color' => 'purple',
                'current' => $user->getFeatureUsage('instagram_auto_replies'),
                'max' => $currentPlan->getFeatureLimit('instagram_auto_replies'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('instagram_auto_replies')
            ]
        ];

        // فلترة المزايا المتاحة فقط
        $usageData = array_filter($usageData, function($data) {
            return $data['max'] != 0;
        });
        
        // حساب التحذيرات
        $reachedLimits = array_filter($usageData, function($data) {
            return !$data['unlimited'] && $data['max'] > 0 && $data['current'] >= $data['max'];
        });
        
        $daysRemaining = $user->access_expires_at ? now()->diffInDays($user->access_expires_at, false) : 0;
        $isExpired = $daysRemaining < 0;
        $isExpiringSoon = $daysRemaining >= 0 && $daysRemaining <= 7;
    ?>

    <!-- عرض مضغوط -->
    <div class="mb-10 bg-gradient-to-r from-blue-50 to-indigo-50 border <?php echo e($isExpired ? 'border-red-300' : ($isExpiringSoon ? 'border-yellow-300' : 'border-blue-200')); ?> rounded-lg shadow-sm overflow-hidden">
        <!-- Header قابل للنقر -->
        <button type="button" onclick="document.getElementById('usage-details').classList.toggle('hidden')" class="w-full p-4 flex items-center justify-between hover:bg-blue-100/50 transition-colors">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-lg <?php echo e($isExpired ? 'bg-red-100' : 'bg-blue-100'); ?> flex items-center justify-center">
                    <?php if($isExpired): ?>
                        <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                        </svg>
                    <?php elseif(count($reachedLimits) > 0): ?>
                        <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                        </svg>
                    <?php elseif($isExpiringSoon): ?>
                        <svg class="w-5 h-5 text-yellow-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd"></path>
                        </svg>
                    <?php else: ?>
                        <svg class="w-5 h-5 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    <?php endif; ?>
                </div>
                
                <div class="text-left">
                    <h3 class="font-bold <?php echo e($isExpired ? 'text-red-800' : 'text-blue-900'); ?> text-base">
                        <?php echo e($currentPlan->title); ?>

                        <?php if($isExpired): ?>
                            <span class="text-xs font-normal text-red-600">(منتهية)</span>
                        <?php elseif($isExpiringSoon): ?>
                            <span class="text-xs font-normal text-yellow-600">(تنتهي قريباً)</span>
                        <?php endif; ?>
                    </h3>
                    <p class="text-xs text-gray-600">
                        <?php if($user->access_expires_at): ?>
                            <?php if($isExpired): ?>
                                انتهت منذ <?php echo e(abs($daysRemaining)); ?> يوم
                            <?php elseif($daysRemaining == 0): ?>
                                تنتهي اليوم
                            <?php else: ?>
                                متبقي <?php echo e($daysRemaining); ?> يوم • <?php echo e($user->access_expires_at->format('d M Y')); ?>

                            <?php endif; ?>
                        <?php endif; ?>
                    </p>
                </div>
            </div>

            <!-- ملخص سريع -->
            <div class="flex items-center gap-4">
                <?php if(count($reachedLimits) > 0): ?>
                    <span class="px-3 py-1 bg-red-100 text-red-700 text-xs font-medium rounded-full">
                        ⚠️ <?php echo e(count($reachedLimits)); ?> حد أقصى
                    </span>
                <?php endif; ?>
                
                <!-- عداد مضغوط -->
                <div class="hidden sm:flex items-center gap-2 text-xs">
                    <?php $__currentLoopData = array_slice($usageData, 0, 3, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center gap-1">
                            <i class="<?php echo e($data['icon']); ?> text-<?php echo e($data['color']); ?>-600"></i>
                            <span class="font-medium"><?php echo e($data['current']); ?>/<?php echo e($data['unlimited'] ? '∞' : $data['max']); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if(count($usageData) > 3): ?>
                        <span class="text-gray-500">+<?php echo e(count($usageData) - 3); ?></span>
                    <?php endif; ?>
                </div>
                
                <svg class="w-5 h-5 text-gray-400 transition-transform" id="usage-chevron" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                </svg>
            </div>
        </button>

        <!-- التفاصيل المخفية (قابلة للطي) -->
        <div id="usage-details" class="hidden border-t border-blue-200">
            <div class="p-4">
                <!-- شبكة مضغوطة -->
                <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 gap-3">
                    <?php $__currentLoopData = $usageData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $percentage = $data['max'] > 0 && !$data['unlimited'] ? ($data['current'] / $data['max']) * 100 : 0;
                            $remaining = max(0, $data['max'] - $data['current']);
                        ?>
                        
                        <div class="bg-white p-3 rounded-lg border hover:shadow-sm transition-shadow">
                            <div class="flex items-center gap-2 mb-2">
                                <div class="w-6 h-6 rounded bg-<?php echo e($data['color']); ?>-100 flex items-center justify-center flex-shrink-0">
                                    <i class="<?php echo e($data['icon']); ?> text-<?php echo e($data['color']); ?>-600 text-xs"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700 truncate"><?php echo e($data['name']); ?></span>
                            </div>
                            
                            <div class="text-lg font-bold text-gray-900 mb-1">
                                <span class="text-<?php echo e($data['color']); ?>-600"><?php echo e($data['current']); ?></span>
                                <span class="text-gray-400 text-sm">/</span>
                                <span class="text-sm"><?php echo e($data['unlimited'] ? '∞' : $data['max']); ?></span>
                            </div>
                            
                            <?php if(!$data['unlimited']): ?>
                                <div class="w-full bg-gray-200 rounded-full h-1.5 mb-1">
                                    <div class="h-1.5 rounded-full transition-all <?php echo e($percentage >= 100 ? 'bg-red-500' : ($percentage >= 80 ? 'bg-yellow-500' : 'bg-green-500')); ?>" 
                                         style="width: <?php echo e(min($percentage, 100)); ?>%"></div>
                                </div>
                                
                                <div class="text-xs <?php echo e($percentage >= 100 ? 'text-red-600 font-medium' : 'text-gray-500'); ?>">
                                    <?php echo e($percentage >= 100 ? 'مكتمل' : "باقي {$remaining}"); ?>

                                </div>
                            <?php else: ?>
                                <div class="text-xs text-green-600 font-medium">غير محدود ✓</div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- تحذيرات مضغوطة -->
                <?php if(count($reachedLimits) > 0): ?>
                    <div class="mt-3 p-3 bg-red-50 border border-red-200 rounded-lg flex items-center justify-between">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-red-500 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="text-sm text-red-800">
                                <span class="font-semibold">وصلت للحد الأقصى</span> في <?php echo e(count($reachedLimits)); ?> من المزايا
                            </span>
                        </div>
                        <a href="#plans" class="px-3 py-1.5 bg-red-600 text-white text-xs font-medium rounded hover:bg-red-700 transition-colors whitespace-nowrap">
                            ترقية الآن
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
    // تأثير الطي/الفتح
    document.getElementById('usage-details').addEventListener('transitionend', function() {
        const chevron = document.getElementById('usage-chevron');
        if (this.classList.contains('hidden')) {
            chevron.style.transform = 'rotate(0deg)';
        } else {
            chevron.style.transform = 'rotate(180deg)';
        }
    });
    </script>
<?php endif; ?>

        <!-- عرض الباقات -->
        <div id="plans" class="grid gap-6 lg:grid-cols-3 mt-4">
            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if(auth()->user()->plan_id === $plan->id): ?>
    <!-- الباقة الحالية -->
    <?php
        $daysRemaining = auth()->user()->access_expires_at ? now()->diffInDays(auth()->user()->access_expires_at, false) : 0;
        $isExpired = $daysRemaining < 0;
        $isExpiringSoon = $daysRemaining >= 0 && $daysRemaining <= 7;
    ?>
    
    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border py-6 relative <?php echo e($isExpired ? 'border-red-500' : 'border-primary'); ?> shadow-lg scale-103 transform transition-all duration-300">
        <span data-slot="badge" class="mb-6 inline-flex items-center justify-center rounded-md border px-3 py-1 text-xs font-bold w-fit whitespace-nowrap shrink-0 absolute -top-6 left-1/2 transform -translate-x-1/2 <?php echo e($isExpired ? 'bg-red-600' : 'bg-primary'); ?> text-white shadow-lg">
            <?php if($isExpired): ?>
                ⚠️ باقة منتهية
            <?php elseif($isExpiringSoon): ?>
                ⏰ تنتهي قريباً
            <?php else: ?>
                ✅ <?php echo e(__('messages.current_plan')); ?>

            <?php endif; ?>
        </span>
        
        <div data-slot="card-header" class="text-center pb-4 px-6">
            <div class="flex justify-center mb-4">
                <div class="p-4 <?php echo e($isExpired ? 'bg-red-100' : 'bg-primary/10'); ?> rounded-full <?php echo e($isExpired ? 'text-red-600' : 'text-primary'); ?>">
                    <?php if($isExpired): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <line x1="15" y1="9" x2="9" y2="15"/>
                            <line x1="9" y1="9" x2="15" y2="15"/>
                        </svg>
                    <?php else: ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    <?php endif; ?>
                </div>
            </div>
            <div data-slot="card-title" class="font-bold text-3xl <?php echo e($isExpired ? 'text-red-600' : 'text-primary'); ?> mb-2"><?php echo e($plan->title); ?></div>
            <div data-slot="card-description" class="text-muted-foreground text-base mb-4"><?php echo e($plan->description); ?></div>
            <div class="mt-4">
                <span class="text-4xl font-bold text-foreground">$<?php echo e(number_format($plan->price, 2)); ?></span>
                <span class="text-muted-foreground">/ <?php echo e($plan->period_text); ?></span>
            </div>
        </div>
        
        <div data-slot="card-content" class="px-6 flex-grow">
            <?php if($plan->features): ?>
                <ul class="space-y-3">
                    <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($value != 0): ?>
                            <li class="flex items-center gap-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary flex-shrink-0">
                                    <path d="M20 6 9 17l-5-5"></path>
                                </svg>
                                <span class="text-sm font-medium">
                                    <?php echo e(getFeatureName($key)); ?>: 
                                    <?php if($value == -1): ?>
                                        <span class="text-green-600 font-semibold">غير محدود</span>
                                    <?php else: ?>
                                        <span class="font-semibold"><?php echo e($value); ?></span>
                                    <?php endif; ?>
                                </span>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            <?php endif; ?>
        </div>
        
        <div data-slot="card-footer" class="px-6 space-y-3">
            <!-- حالة الباقة -->
            <div class="p-4 rounded-lg <?php echo e($isExpired ? 'bg-red-50 border-2 border-red-200' : ($isExpiringSoon ? 'bg-yellow-50 border-2 border-yellow-200' : 'bg-blue-50 border border-blue-200')); ?>">
                <div class="text-center">
                    <?php if($isExpired): ?>
                        <div class="text-red-600 font-bold text-lg mb-2">⚠️ الباقة منتهية</div>
                        <div class="text-red-700 text-sm">انتهت منذ <?php echo e(abs($daysRemaining)); ?> يوم</div>
                    <?php elseif($isExpiringSoon): ?>
                        <div class="text-yellow-700 font-bold text-lg mb-2">⏰ الباقة تنتهي قريباً</div>
                        <div class="text-yellow-600 text-sm">متبقي <?php echo e($daysRemaining); ?> <?php echo e($daysRemaining == 1 ? 'يوم' : 'أيام'); ?> فقط</div>
                    <?php else: ?>
                        <div class="text-blue-700 font-medium"><?php echo e(__('messages.next_payment_due')); ?></div>
                    <?php endif; ?>
                    
                    <?php if(auth()->user()->access_expires_at): ?>
                        <div class="text-lg font-bold <?php echo e($isExpired ? 'text-red-700' : ($isExpiringSoon ? 'text-yellow-700' : 'text-blue-700')); ?> mt-2">
                            <?php echo e(auth()->user()->access_expires_at->format('d M Y')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <?php if($isExpired): ?>
                <!-- زر تجديد للباقة المنتهية -->
                <a href="https://api.whatsapp.com/send?phone=218914492424&text=%D8%AA%D8%AC%D8%AF%D9%8A%D8%AF%20%D8%A7%D9%84%D8%A8%D8%A7%D9%82%D8%A9" class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-gradient-to-r from-green-600 to-emerald-600 text-white shadow-lg hover:from-green-700 hover:to-emerald-700 h-12 px-6 py-3 animate-pulse">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                        <path d="M21 3v5h-5"/>
                        <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                        <path d="M3 21v-5h5"/>
                    </svg>
                    <span class="font-bold text-base"> تجديد الباقة الآن</span>
                </a>
                
                <p class="text-center text-xs text-red-600 font-medium">
                    جدد باقتك الآن لاستعادة الوصول إلى جميع المزايا
                </p>
                
            <?php elseif($isExpiringSoon): ?>
                <!-- زر تمديد للباقة القريبة من الانتهاء -->
                <div class="space-y-2">
                    <a href="https://api.whatsapp.com/send?phone=218914492424&text=%D8%AA%D9%85%D8%AF%D9%8A%D8%AF%20%D8%A7%D9%84%D8%A8%D8%A7%D9%82%D8%A9" class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-gradient-to-r from-yellow-500 to-orange-500 text-white shadow-lg hover:from-yellow-600 hover:to-orange-600 h-11 px-5 py-2.5">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <polyline points="12 6 12 12 16 14"/>
                        </svg>
                        <span class="font-bold">⏳ تمديد الباقة</span>
                    </a>
                    
                    <p class="text-center text-xs text-yellow-700 font-medium">
                        مدد باقتك الآن بسعر $<?php echo e(number_format($plan->price, 2)); ?>

                    </p>
                </div>
                
            <?php else: ?>
                <!-- الأزرار العادية للباقة النشطة -->
                <div class="space-y-2">
                    <a href="https://api.whatsapp.com/send?phone=218914492424&text=%D8%AA%D8%AC%D8%AF%D9%8A%D8%AF%20%D8%A7%D9%84%D8%A8%D8%A7%D9%82%D8%A9" class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-primary text-primary-foreground shadow-sm hover:bg-primary/90 h-10 px-4 py-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <polyline points="12 6 12 12 16 14"/>
                        </svg>
                        تمديد الباقة
                    </a>
                </div>
            <?php endif; ?>

            <?php if(!$isExpired): ?>
                <!-- زر إلغاء الاشتراك -->
                <form method="POST" action="<?php echo e(route('plans.cancel-subscription')); ?>" onsubmit="return confirm('<?php echo e(__('messages.are_you_sure')); ?>');" class="w-full">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-red-50 text-red-600 border border-red-200 shadow-xs hover:bg-red-100 h-10 px-4 py-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M18 6 6 18"/>
                            <path d="m6 6 12 12"/>
                        </svg>
                        <?php echo e(__('messages.cancel_subscription')); ?>

                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>


                <?php elseif($plan->active && auth()->user()->plan_id !== $plan->id): ?>
                    <!-- الباقات الأخرى -->
                    <div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border py-6 shadow-sm relative hover:shadow-lg transition-all duration-300 group">
                        <!-- مقارنة مع الباقة الحالية -->
                        <?php if(auth()->user()->plan): ?>
                            <?php
                                $currentPlan = auth()->user()->plan;
                                $isUpgrade = $plan->price > $currentPlan->price;
                                $improvements = [];
                                
                                if($plan->features && $currentPlan->features) {
                                    foreach($plan->features as $key => $value) {
                                        $currentValue = $currentPlan->features[$key] ?? 0;
                                        if($value > $currentValue || ($value == -1 && $currentValue != -1)) {
                                            $improvements[] = getFeatureName($key);
                                        }
                                    }
                                }
                            ?>
                            
                            <?php if($isUpgrade && count($improvements) > 0): ?>
                                <span data-slot="badge" class="mb-6 inline-flex items-center justify-center rounded-md border px-3 py-1 text-xs font-bold w-fit whitespace-nowrap shrink-0 absolute -top-6 left-1/2 transform -translate-x-1/2 bg-gradient-to-r from-green-500 to-emerald-500 text-white shadow-lg animate-pulse">
                                    ⭐ ترقية موصى بها
                                </span>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <div data-slot="card-header" class="text-center pb-4 px-6">
                            <div class="flex justify-center mb-4">
                                <div class="p-4 bg-primary/10 rounded-full text-primary group-hover:bg-primary/20 transition-colors">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M4 14a1 1 0 0 1-.78-1.63l9.9-10.2a.5.5 0 0 1 .86.46l-1.92 6.02A1 1 0 0 0 13 10h7a1 1 0 0 1 .78 1.63l-9.9 10.2a.5.5 0 0 1-.86-.46l1.92-6.02A1 1 0 0 0 11 14z"></path>
                                    </svg>
                                </div>
                            </div>
                            <div data-slot="card-title" class="font-bold text-2xl mb-2"><?php echo e($plan->title); ?></div>
                            <div data-slot="card-description" class="text-muted-foreground text-base mb-4"><?php echo e($plan->description); ?></div>
                            <div class="mt-4">
                                <span class="text-4xl font-bold text-foreground" dir="rtl">LYD <?php echo e(number_format($plan->price, 0)); ?></span>
                                <span class="text-muted-foreground">/ <?php echo e($plan->period_days); ?> <?php echo e($plan->period_type == 'days' ? 'يوم' : ($plan->period_type == 'months' ? 'شهر' : 'سنة')); ?></span>
                            </div>
                        </div>
                        
                        <div data-slot="card-content" class="px-6 flex-grow">
                            <?php if($plan->features): ?>
                                <ul class="space-y-3">
                                    <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($value != 0): ?>
                                            <li class="flex items-center gap-3">
                                                <?php
                                                    $isImproved = false;
                                                    if(auth()->user()->plan && isset(auth()->user()->plan->features[$key])) {
                                                        $currentValue = auth()->user()->plan->features[$key];
                                                        $isImproved = $value > $currentValue || ($value == -1 && $currentValue != -1);
                                                    }
                                                ?>
                                                
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="<?php echo e($isImproved ? 'text-green-500' : 'text-primary'); ?> flex-shrink-0">
                                                    <path d="M20 6 9 17l-5-5"></path>
                                                </svg>
                                                <span class="text-sm font-medium <?php echo e($isImproved ? 'text-green-700' : ''); ?>">
                                                    <?php echo e(getFeatureName($key)); ?>: 
                                                    <?php if($value == -1): ?>
                                                        <span class="text-green-600 font-bold">غير محدود</span>
                                                    <?php else: ?>
                                                        <span class="font-semibold"><?php echo e($value); ?></span>
                                                    <?php endif; ?>
                                                    <?php if($isImproved): ?>
                                                        <span class="text-xs text-green-600 font-bold"> ⬆</span>
                                                    <?php endif; ?>
                                                </span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                            
                            <!-- عرض التحسينات -->
                            <?php if(isset($improvements) && count($improvements) > 0): ?>
                                <div class="mt-4 p-3 bg-green-50 border border-green-200 rounded-lg">
                                    <div class="text-xs font-semibold text-green-800 mb-1">تحسينات هذه الباقة:</div>
                                    <div class="text-xs text-green-700">
                                        <?php echo e(implode(' • ', array_slice($improvements, 0, 3))); ?>

                                        <?php if(count($improvements) > 3): ?>
                                            <span class="font-medium">+ <?php echo e(count($improvements) - 3); ?> أخرى</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div data-slot="card-footer" class="px-6">
                            <a href="https://api.whatsapp.com/send?phone=218914492424&text=%D8%A7%D8%B4%D8%AA%D8%B1%D8%A7%D9%83%20%D9%81%D9%8A%20%D9%85%D8%AC%D9%8A%D8%A8" class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-primary text-primary-foreground shadow-xs hover:bg-primary/90 h-10 px-4 py-2 group-hover:scale-105">
                                <?php if(auth()->user()->plan && $plan->price > auth()->user()->plan->price): ?>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M7 11l5-5m0 0l5 5m-5-5v12"/>
                                    </svg>
                                    ترقية الآن
                                <?php else: ?>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    <?php echo e(__('messages.subscribe_now')); ?>

                                <?php endif; ?>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- قسم الأسئلة الشائعة -->
        <div class="mt-16 text-center">
            <h2 class="text-2xl font-bold text-foreground mb-4">لديك أسئلة؟</h2>
            <p class="text-muted-foreground mb-6">نحن هنا لمساعدتك في اختيار الباقة المناسبة</p>
            <a href="https://api.whatsapp.com/send?phone=218914492424&text=%D9%85%D8%B3%D8%A7%D8%B9%D8%AF%D8%A9" class="inline-flex items-center gap-2 px-6 py-3 bg-muted text-foreground rounded-lg hover:bg-muted/80 transition-colors">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                </svg>
                اتصل بنا
            </a>
        </div>
    </div>

    <style>
    /* تحسينات CSS إضافية */
    .scale-105 {
        transform: scale(1.05);
    }
    
    .group:hover .group-hover\:scale-105 {
        transform: scale(1.05);
    }
    
    .animate-pulse {
        animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
    }
    
    @keyframes pulse {
        0%, 100% {
            opacity: 1;
        }
        50% {
            opacity: .7;
        }
    }
    
    /* ألوان مخصصة */
    .bg-blue-100 { background-color: rgb(219 234 254); }
    .bg-pink-100 { background-color: rgb(252 231 243); }
    .bg-indigo-100 { background-color: rgb(224 231 255); }
    .bg-green-100 { background-color: rgb(220 252 231); }
    .bg-purple-100 { background-color: rgb(237 233 254); }
    .bg-gray-100 { background-color: rgb(243 244 246); }
    
    .text-blue-600 { color: rgb(37 99 235); }
    .text-pink-600 { color: rgb(219 39 119); }
    .text-indigo-600 { color: rgb(79 70 229); }
    .text-green-600 { color: rgb(22 163 74); }
    .text-purple-600 { color: rgb(147 51 234); }
    .text-gray-600 { color: rgb(75 85 99); }
    
    /* تحسين المظهر العام */
    .transition-all {
        transition: all 0.3s ease;
    }
    
    .hover\:shadow-lg:hover {
        box-shadow: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
    }
    
    </style>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/plans/index.blade.php ENDPATH**/ ?>