<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> إضافة باقة جديدة <?php $__env->endSlot(); ?>

<div class="p-6 space-y-6" dir="rtl">

<!-- رأس الصفحة -->
<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
    <div>
        <h1 class="text-3xl font-bold text-foreground flex items-center gap-2">
            <div class="w-8 h-8 bg-gradient-to-r from-green-600 to-emerald-600 rounded-lg flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                    <path d="M5 12h14"/>
                    <path d="m12 5 7 7-7 7"/>
                </svg>
            </div>
            إضافة باقة جديدة
        </h1>
        <p class="text-muted-foreground">إنشاء باقة اشتراك جديدة مع تحديد المميزات والأسعار</p>
    </div>
    
    <a href="<?php echo e(route('admin.plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 [&_svg]:pointer-events-none [&_svg:not([class*='size-'])]:size-4 shrink-0 [&_svg]:shrink-0 outline-none focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px] aria-invalid:ring-destructive/20 dark:aria-invalid:ring-destructive/40 aria-invalid:border-destructive border border-input bg-background hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 has-[>svg]:px-3">
        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
            <circle cx="12" cy="12" r="10"/>
            <path d="M12 8l-4 4 4 4M16 12H9"/>
        </svg>
        عودة
    </a>
</div>

<!-- عرض الأخطاء -->
<?php if($errors->any()): ?>
    <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl">
        <div class="flex items-start gap-3">
            <div class="w-8 h-8 bg-red-500 rounded-full flex items-center justify-center flex-shrink-0">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                    <circle cx="12" cy="12" r="10"/>
                    <line x1="15" y1="9" x2="9" y2="15"/>
                    <line x1="9" y1="9" x2="15" y2="15"/>
                </svg>
            </div>
            <div>
                <h3 class="font-medium text-red-800 mb-2">يرجى تصحيح الأخطاء التالية:</h3>
                <ul class="list-disc list-inside space-y-1 text-sm">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- نموذج الإضافة -->
<form method="POST" action="<?php echo e(route('admin.plans.store')); ?>" id="plan-form">
    <?php echo csrf_field(); ?>
    
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- العمود الرئيسي -->
        <div class="lg:col-span-2 space-y-6">
            
            <!-- المعلومات الأساسية -->
            <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-6 py-4 border-b border-border">
                    <h2 class="text-xl font-semibold flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary">
                            <circle cx="12" cy="12" r="10"/>
                            <line x1="12" y1="16" x2="12" y2="12"/>
                            <line x1="12" y1="8" x2="12.01" y2="8"/>
                        </svg>
                        المعلومات الأساسية
                    </h2>
                </div>
                <div data-slot="card-content" class="p-6 space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="space-y-2">
                            <label class="text-sm font-medium text-foreground">اسم الباقة <span class="text-red-500">*</span></label>
                            <input type="text" name="title" 
                                   class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('title', $plan->title ?? '')); ?>" 
                                   placeholder="اسم الباقة..."
                                   required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm font-medium text-foreground">السعر <span class="text-red-500">*</span></label>
                            <div class="relative">
                                <input type="number" step="0.01" name="price" 
                                       class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 pl-8 <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       value="<?php echo e(old('price', $plan->price ?? '')); ?>" 
                                       placeholder="0.00"
                                       required>
                                <span class="absolute left-3 top-2 text-muted-foreground text-sm">$</span>
                            </div>
                            <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="space-y-2">
                            <label class="text-sm font-medium text-foreground">عدد الأيام <span class="text-red-500">*</span></label>
                            <input type="number" name="period_days" 
                                   class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 <?php $__errorArgs = ['period_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   value="<?php echo e(old('period_days', $plan->period_days ?? '')); ?>" 
                                   placeholder="30"
                                   required>
                            <?php $__errorArgs = ['period_days'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="space-y-2">
                            <label class="text-sm font-medium text-foreground">نوع المدة <span class="text-red-500">*</span></label>
                            <select name="period_type" 
                                    class="flex h-9 w-full items-center justify-between rounded-md border border-input bg-background px-3 py-2 text-sm ring-offset-background placeholder:text-muted-foreground focus:outline-none focus:ring-1 focus:ring-ring disabled:cursor-not-allowed disabled:opacity-50 <?php $__errorArgs = ['period_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="days" <?php if(old('period_type', $plan->period_type ?? '') == 'days'): echo 'selected'; endif; ?>>أيام</option>
                                <option value="months" <?php if(old('period_type', $plan->period_type ?? '') == 'months'): echo 'selected'; endif; ?>>شهور</option>
                                <option value="years" <?php if(old('period_type', $plan->period_type ?? '') == 'years'): echo 'selected'; endif; ?>>سنوات</option>
                            </select>
                            <?php $__errorArgs = ['period_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-red-500 text-sm"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground">وصف الباقة</label>
                        <textarea name="description" rows="3" 
                                  class="flex min-h-[60px] w-full rounded-md border border-input bg-background px-3 py-2 text-sm shadow-xs placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  placeholder="وصف مختصر للباقة..."><?php echo e(old('description', $plan->description ?? '')); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-red-500 text-sm"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- إعدادات Stripe -->
            <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-6 py-4 border-b border-border">
                    <h2 class="text-xl font-semibold flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                            <rect x="1" y="4" width="22" height="16" rx="2" ry="2"/>
                            <line x1="1" y1="10" x2="23" y2="10"/>
                        </svg>
                        إعدادات الدفع
                    </h2>
                </div>
                <div data-slot="card-content" class="p-6 space-y-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground">معرف السعر في Stripe <span class="text-muted-foreground">(اختياري)</span></label>
                        <input type="text" name="price_id" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50 <?php $__errorArgs = ['price_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               value="<?php echo e(old('price_id', $plan->price_id ?? '')); ?>" 
                               placeholder="price_1234567890">
                        <p class="text-xs text-muted-foreground">يمكنك ربط الباقة بمعرف السعر من Stripe للاشتراكات الدورية</p>
                        <?php $__errorArgs = ['price_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-red-500 text-sm"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- المميزات -->
                        
<!-- المميزات -->
<div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
    <div data-slot="card-header" class="px-6 py-4 border-b border-border">
        <h2 class="text-xl font-semibold flex items-center gap-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                <polyline points="20 6 9 17 4 12"/>
            </svg>
            مميزات الباقة
        </h2>
        <p class="text-sm text-muted-foreground mt-2">حدد قيود وحدود المزايا المتاحة في هذه الباقة</p>
    </div>
    <div data-slot="card-content" class="p-6 space-y-6">
        
        <!-- قسم حسابات التواصل الاجتماعي -->
        <div class="space-y-4">
            <div class="flex items-center gap-2 pb-2 border-b">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                    <path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/>
                    <polyline points="22 4 12 14.01 9 11.01"/>
                </svg>
                <h3 class="text-lg font-semibold">حسابات التواصل الاجتماعي</h3>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-facebook-f text-blue-600"></i>
                        حسابات فيسبوك
                    </label>
                    <input type="number" name="features[facebook_accounts]" 
                           class="form-control" value="<?php echo e(old('features.facebook_accounts', 1)); ?>"
                           placeholder="عدد حسابات فيسبوك المسموحة (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>
                
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-instagram text-pink-600"></i>
                        حسابات إنستقرام
                    </label>
                    <input type="number" name="features[instagram_accounts]" 
                           class="form-control" value="<?php echo e(old('features.instagram_accounts', 1)); ?>"
                           placeholder="عدد حسابات إنستقرام المسموحة (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>
            </div>
        </div>

        <!-- قسم الصفحات والمجتمعات -->
        <div class="space-y-4">
            <div class="flex items-center gap-2 pb-2 border-b">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                    <rect x="3" y="3" width="18" height="18" rx="2" ry="2"/>
                    <circle cx="8.5" cy="8.5" r="1.5"/>
                    <polyline points="21 15 16 10 5 21"/>
                </svg>
                <h3 class="text-lg font-semibold">الصفحات والمجتمعات</h3>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-facebook-f text-blue-600"></i>
                        صفحات فيسبوك
                    </label>
                    <input type="number" name="features[facebook_pages]" 
                           class="form-control" value="<?php echo e(old('features.facebook_pages', 5)); ?>"
                           placeholder="عدد صفحات فيسبوك المسموحة (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>
                
                
            </div>
        </div>

        <!-- قسم المنشورات والمحتوى -->
        <div class="space-y-4">
            <div class="flex items-center gap-2 pb-2 border-b">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-orange-600">
                    <path d="M14.5 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V7.5L14.5 2z"/>
                    <polyline points="14 2 14 8 20 8"/>
                </svg>
                <h3 class="text-lg font-semibold">المنشورات والمحتوى</h3>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-facebook-f text-blue-600"></i>
                        منشورات فيسبوك (شهرياً)
                    </label>
                    <input type="number" name="features[facebook_posts]" 
                           class="form-control" value="<?php echo e(old('features.facebook_posts', 50)); ?>"
                           placeholder="عدد منشورات فيسبوك المسموحة شهرياً (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>
                
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-instagram text-pink-600"></i>
                        منشورات إنستقرام (شهرياً)
                    </label>
                    <input type="number" name="features[instagram_posts]" 
                           class="form-control" value="<?php echo e(old('features.instagram_posts', 50)); ?>"
                           placeholder="عدد منشورات إنستقرام المسموحة شهرياً (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>

               
            </div>
        </div>

        <!-- قسم الأتمتة والردود -->
        <div class="space-y-4">
            <div class="flex items-center gap-2 pb-2 border-b">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-red-600">
                    <circle cx="12" cy="12" r="3"/>
                    <path d="M12 1v6m0 6v6m11-7h-6m-6 0H1"/>
                </svg>
                <h3 class="text-lg font-semibold">الأتمتة والردود التلقائية</h3>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-facebook-f text-blue-600"></i>
                        ردود فيسبوك التلقائية
                    </label>
                    <input type="number" name="features[facebook_auto_replies]" 
                           class="form-control" value="<?php echo e(old('features.facebook_auto_replies', 10)); ?>"
                           placeholder="عدد الردود التلقائية لفيسبوك (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>
                
                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fab fa-instagram text-pink-600"></i>
                        ردود إنستقرام التلقائية
                    </label>
                    <input type="number" name="features[instagram_auto_replies]" 
                           class="form-control" value="<?php echo e(old('features.instagram_auto_replies', 10)); ?>"
                           placeholder="عدد الردود التلقائية لإنستقرام (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>

                <div class="space-y-2">
                    <label class="text-sm font-medium flex items-center gap-2">
                        <i class="fas fa-robot text-gray-600"></i>
                        إجمالي الردود التلقائية
                    </label>
                    <input type="number" name="features[auto_replies]" 
                           class="form-control" value="<?php echo e(old('features.auto_replies', 20)); ?>"
                           placeholder="إجمالي الردود التلقائية المسموحة (-1 لغير محدود)">
                    <small class="text-muted">-1 = غير محدود، 0 = غير متاح</small>
                </div>

                
            </div>
        </div>



        <!-- ملاحظة توضيحية -->
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
            <div class="flex items-start gap-3">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600 mt-0.5 flex-shrink-0">
                    <circle cx="12" cy="12" r="10"/>
                    <path d="M12 16v-4"/>
                    <path d="M12 8h.01"/>
                </svg>
                <div class="text-sm">
                    <p class="font-medium text-blue-900 mb-1">ملاحظات مهمة:</p>
                    <ul class="text-blue-800 space-y-1 list-disc list-inside">
                        <li>استخدم <strong>-1</strong> لجعل الميزة غير محدودة</li>
                        <li>استخدم <strong>0</strong> لإلغاء الميزة نهائياً</li>
                        <li>القيم الموجبة تحدد العدد الأقصى المسموح</li>
                        <li>بعض المزايا قد تتطلب مزايا أخرى لتعمل بشكل صحيح</li>
                    </ul>
                </div>
            </div>
        </div>
        
  </div>
               
            </div>
        </div>
        <!-- العمود الجانبي -->
        <div class="space-y-6">
            <!-- الإعدادات -->
            <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-6 py-4 border-b border-border">
                    <h3 class="text-lg font-semibold flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-gray-600">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M12 1v6m0 6v6"/>
                            <path d="m21 12-6 6-6-6"/>
                        </svg>
                        الإعدادات
                    </h3>
                </div>
                <div data-slot="card-content" class="p-6 space-y-4">
                    <div class="flex items-center justify-between p-3 bg-muted/30 rounded-lg">
                        <div>
                            <label for="active" class="text-sm font-medium text-foreground">الباقة مفعلة</label>
                            <p class="text-xs text-muted-foreground">هل يمكن للمستخدمين الاشتراك في هذه الباقة؟</p>
                        </div>
                        <div class="flex items-center">
                            <input type="checkbox" name="active" value="1" id="active" 
                                   class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary focus:ring-2"
                                   <?php echo e(old('active', $plan->active ?? true) ? 'checked' : ''); ?>>
                        </div>
                    </div>

                    <div class="flex items-center justify-between p-3 bg-muted/30 rounded-lg">
                        <div>
                            <label for="auto_renew" class="text-sm font-medium text-foreground">التجديد التلقائي</label>
                            <p class="text-xs text-muted-foreground">هل يتم تجديد الاشتراك تلقائياً؟</p>
                        </div>
                        <div class="flex items-center">
                            <input type="checkbox" name="auto_renew" value="1" id="auto_renew" 
                                   class="h-4 w-4 rounded border-gray-300 text-primary focus:ring-primary focus:ring-2"
                                   <?php echo e(old('auto_renew', $plan->auto_renew ?? false) ? 'checked' : ''); ?>>
                        </div>
                    </div>
                </div>
            </div>

            <!-- معاينة الباقة -->
            <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-6 py-4 border-b border-border">
                    <h3 class="text-lg font-semibold flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                            <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                            <circle cx="12" cy="12" r="3"/>
                        </svg>
                        معاينة الباقة
                    </h3>
                </div>
                <div data-slot="card-content" class="p-6">
                    <div id="plan-preview" class="text-center">
                        <div class="w-16 h-16 bg-gradient-to-br from-blue-500 to-purple-600 rounded-xl flex items-center justify-center mx-auto mb-4">
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                                <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                            </svg>
                        </div>
                        <h4 id="preview-title" class="text-lg font-bold text-foreground mb-2">اسم الباقة</h4>
                        <div class="flex items-center justify-center gap-1 mb-3">
                            <span id="preview-price" class="text-3xl font-bold text-primary">$0</span>
                            <div class="text-left">
                                <div class="text-xs text-muted-foreground">/</div>
                                <div id="preview-period" class="text-xs text-muted-foreground">شهر</div>
                            </div>
                        </div>
                        <p id="preview-description" class="text-sm text-muted-foreground mb-4">وصف الباقة سيظهر هنا</p>
                        <div id="preview-features" class="text-left space-y-1">
                            <!-- المميزات ستظهر هنا -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- أزرار الحفظ -->
            <div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
                <div data-slot="card-content" class="p-6">
                    <div class="flex flex-col gap-3">
                        <button type="submit" 
                                class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90 w-full"
                                id="submit-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                                <polyline points="17,21 17,13 7,13 7,21"/>
                                <polyline points="7,3 7,8 15,8"/>
                            </svg>
                            حفظ الباقة
                        </button>
                        
                        <a href="<?php echo e(route('admin.plans.index')); ?>" 
                           class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 border border-input bg-background hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 w-full">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M18 6 6 18"/>
                                <path d="m6 6 12 12"/>
                            </svg>
                            إلغاء
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // عناصر النموذج
    const titleInput = document.querySelector('input[name="title"]');
    const priceInput = document.querySelector('input[name="price"]');
    const periodDaysInput = document.querySelector('input[name="period_days"]');
    const periodTypeSelect = document.querySelector('select[name="period_type"]');
    const descriptionTextarea = document.querySelector('textarea[name="description"]');
    const featuresTextarea = document.querySelector('textarea[name="features"]');
    
    // عناصر المعاينة
    const previewTitle = document.getElementById('preview-title');
    const previewPrice = document.getElementById('preview-price');
    const previewPeriod = document.getElementById('preview-period');
    const previewDescription = document.getElementById('preview-description');
    const previewFeatures = document.getElementById('preview-features');
    
    // تحديث المعاينة
    function updatePreview() {
        // تحديث العنوان
        const title = titleInput.value || 'اسم الباقة';
        previewTitle.textContent = title;
        
        // تحديث السعر
        const price = priceInput.value || '0';
        previewPrice.textContent = `$${price}`;
        
        // تحديث المدة
        const periodDays = periodDaysInput.value || '30';
        const periodType = periodTypeSelect.value;
        let periodText = '';
        
        if (periodType === 'days') {
            periodText = periodDays === '1' ? 'يوم' : `${periodDays} أيام`;
        } else if (periodType === 'months') {
            periodText = periodDays === '1' ? 'شهر' : `${periodDays} شهور`;
        } else if (periodType === 'years') {
            periodText = periodDays === '1' ? 'سنة' : `${periodDays} سنوات`;
        }
        
        previewPeriod.textContent = periodText;
        
        // تحديث الوصف
        const description = descriptionTextarea.value || 'وصف الباقة سيظهر هنا';
        previewDescription.textContent = description;
        
        // تحديث المميزات
        const features = featuresTextarea.value.split('\n').filter(feature => feature.trim());
        previewFeatures.innerHTML = '';
        
        if (features.length > 0) {
            features.forEach(feature => {
                const div = document.createElement('div');
                div.className = 'flex items-center gap-2 text-xs text-muted-foreground';
                div.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-500">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                    <span>${feature.trim()}</span>
                `;
                previewFeatures.appendChild(div);
            });
        } else {
            previewFeatures.innerHTML = '<div class="text-xs text-muted-foreground">لا توجد مميزات مضافة بعد</div>';
        }
    }
    
    // ربط الأحداث
    [titleInput, priceInput, periodDaysInput, periodTypeSelect, descriptionTextarea, featuresTextarea].forEach(element => {
        if (element) {
            element.addEventListener('input', updatePreview);
            element.addEventListener('change', updatePreview);
        }
    });
    
    // تحديث أولي
    updatePreview();
    
    // فاليديشن النموذج
    const form = document.getElementById('plan-form');
    const submitBtn = document.getElementById('submit-btn');
    
    form.addEventListener('submit', function(e) {
        const title = titleInput.value.trim();
        const price = priceInput.value;
        const periodDays = periodDaysInput.value;
        
        if (!title || !price || !periodDays) {
            e.preventDefault();
            showAlert('danger', 'يرجى ملء جميع الحقول المطلوبة');
            return false;
        }
        
        if (parseFloat(price) < 0) {
            e.preventDefault();
            showAlert('danger', 'السعر يجب أن يكون أكبر من أو يساوي صفر');
            priceInput.focus();
            return false;
        }
        
        if (parseInt(periodDays) <= 0) {
            e.preventDefault();
            showAlert('danger', 'عدد الأيام يجب أن يكون أكبر من صفر');
            periodDaysInput.focus();
            return false;
        }
        
        // تحديث زر الإرسال
        submitBtn.disabled = true;
        submitBtn.innerHTML = `
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="animate-spin">
                <path d="M21 12a9 9 0 11-6.219-8.56"/>
            </svg>
            جاري الحفظ...
        `;
    });
    
    // دالة عرض التنبيهات
    function showAlert(type, message) {
        const alertColors = {
            'success': 'bg-green-50 border-green-200 text-green-700',
            'danger': 'bg-red-50 border-red-200 text-red-700',
            'warning': 'bg-yellow-50 border-yellow-200 text-yellow-700',
            'info': 'bg-blue-50 border-blue-200 text-blue-700'
        };
        
        const alertIcons = {
            'success': '<polyline points="20 6 9 17 4 12"/>',
            'danger': '<circle cx="12" cy="12" r="10"/><line x1="15" y1="9" x2="9" y2="15"/><line x1="9" y1="9" x2="15" y2="15"/>',
            'warning': '<path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3Z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/>',
            'info': '<circle cx="12" cy="12" r="10"/><line x1="12" y1="16" x2="12" y2="12"/><line x1="12" y1="8" x2="12.01" y2="8"/>'
        };
        
        const alert = document.createElement('div');
        alert.className = `${alertColors[type]} px-6 py-4 rounded-xl border flex items-start gap-3 fixed top-4 right-4 z-50 max-w-md`;
        alert.innerHTML = `
            <div class="w-8 h-8 bg-current rounded-full flex items-center justify-center flex-shrink-0 opacity-20">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    ${alertIcons[type]}
                </svg>
            </div>
            <div class="flex-1">
                <div class="text-sm font-medium">${message}</div>
            </div>
            <button class="text-current hover:opacity-70" onclick="this.parentElement.remove()">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M18 6 6 18"/>
                    <path d="m6 6 12 12"/>
                </svg>
            </button>
        `;
        
        document.body.appendChild(alert);
        
        // إزالة التنبيه تلقائياً
        setTimeout(() => {
            alert.style.opacity = '0';
            alert.style.transform = 'translateY(-20px)';
            setTimeout(() => alert.remove(), 300);
        }, 5000);
    }
    
    // تحسين تجربة المستخدم - تنسيق السعر
    priceInput.addEventListener('input', function() {
        let value = this.value;
        if (value && !isNaN(value)) {
            // تنسيق السعر إلى رقمين عشريين
            if (value.includes('.')) {
                const parts = value.split('.');
                if (parts[1] && parts[1].length > 2) {
                    this.value = parseFloat(value).toFixed(2);
                }
            }
        }
    });
    
    // تحسين تجربة المستخدم - منع القيم السالبة
    [priceInput, periodDaysInput].forEach(input => {
        input.addEventListener('keydown', function(e) {
            if (e.key === '-' || e.key === '+') {
                e.preventDefault();
            }
        });
    });
});
</script>

<style>
/* تحسينات إضافية للتصميم */
.period-btn {
    transition: all 0.2s ease;
}

.period-btn:hover {
    background-color: rgba(59, 130, 246, 0.1);
}

/* تحسين المعاينة */
#plan-preview {
    transition: all 0.3s ease;
}

/* تحسين النموذج */
.space-y-2 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 0.5rem;
}

.space-y-4 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 1rem;
}

.space-y-6 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 1.5rem;
}

/* تحسين الإدخال */
input:focus, select:focus, textarea:focus {
    box-shadow: 0 0 0 2px rgba(59, 130, 246, 0.2);
}

/* تحسين الأزرار */
button, a {
    transition: all 0.2s ease;
}

button:hover, a:hover {
    transform: translateY(-1px);
}

/* تحسين التأثيرات البصرية */
.shadow-xs {
    box-shadow: 0 1px 2px 0 rgb(0 0 0 / 0.05);
}

/* تحسين الاستجابة */
@media (max-width: 768px) {
    .lg\:col-span-2 {
        grid-column: span 1 / span 1;
    }
    
    .grid-cols-1.md\:grid-cols-2 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
    }
}

/* تحسين ألوان الحالة */
.text-red-500 {
    color: rgb(239 68 68);
}

.border-red-500 {
    border-color: rgb(239 68 68);
}

.text-green-500 {
    color: rgb(34 197 94);
}

/* تحسين الانتقالات */
.transition-all {
    transition: all 0.2s ease;
}

/* تحسين الظلال */
.bg-card:hover {
    box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -1px rgb(0 0 0 / 0.06);
}
</style>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/admin/plans/create.blade.php ENDPATH**/ ?>