<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> إدارة مفاتيح AI <?php $__env->endSlot(); ?>

    <div class="container mx-auto px-4 py-8 max-w-4xl">
        
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-800 dark:text-white mb-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 text-indigo-600 inline-block align-text-bottom ml-2" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0Z"/><path d="M12 10a3 3 0 1 0 0 6 3 3 0 0 0 0-6Z"/>
                </svg>
                إدارة مفاتيح الذكاء الاصطناعي
            </h1>
            <p class="text-gray-600 dark:text-gray-400">
                قم بإضافة مفاتيح API الخاصة بك لاستخدام خدمات الذكاء الاصطناعي
            </p>
        </div>

        
        <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-700 rounded-lg p-4 mb-6">
            <div class="flex items-start gap-3">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 text-blue-600 dark:text-blue-400 mt-1 shrink-0" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    ircle cx="12" cy="12" r="10"/><path d="M12 16v-4"/><path d="M12 8h.01"/>
                </svg>
                <div class="text-sm text-blue-800 dark:text-blue-200">
                    <p class="font-semibold mb-1">لماذا نحتاج مفاتيح API الخاصة بك؟</p>
                    <ul class="list-disc list-inside space-y-1">
                        <li>لضمان خصوصية وأمان مفاتيحك</li>
                        <li>لتجنب حدود الاستخدام المشتركة</li>
                        <li>للتحكم الكامل في تكاليف الاستخدام</li>
                    </ul>
                </div>
            </div>
        </div>

        
        <div class="space-y-4">
            <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $providerId => $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $userKey = $userKeys->get($providerId);
                    $hasKey = $userKey && $userKey->getRawOriginal('api_key');

                    $svgIcon = match($providerId) {
                        'openai' => '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 3a9 9 0 0 0-9 9c0 4.97 4.03 9 9 9s9-4.03 9-9a9 9 0 0 0-9-9z"/><path d="M8 12c0 2.21 1.79 4 4 4s4-1.79 4-4-1.79-4-4-4-4 1.79-4 4z"/></svg>',
                        'anthropic' => '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 2a10 10 0 0 0-3 19.86l3-8.86 3 8.86a10 10 0 0 0-3-19.86z"/><path d="M12 2v20"/></svg>',
                        'gemini' => '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16.5 6l-9 9m9 0l-9-9m0 9l9-9"/>ircle cx="7.5" cy="7.5" r="2.5"/>ircle cx="16.5" cy="16.5" r="2.5"/></svg>',
                        default => ''
                    };
                ?>

                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
                    
                    <div class="p-6 border-b border-gray-200 dark:border-gray-700">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-4">
                                <div class="w-12 h-12 bg-<?php echo e($provider['color']); ?>-100 dark:bg-<?php echo e($provider['color']); ?>-900/20 rounded-lg flex items-center justify-center text-<?php echo e($provider['color']); ?>-600 dark:text-<?php echo e($provider['color']); ?>-400">
                                    <?php echo $svgIcon; ?>

                                </div>
                                <div>
                                    <h3 class="text-lg font-semibold text-gray-800 dark:text-white">
                                        <?php echo e($provider['name']); ?>

                                    </h3>
                                    <p class="text-sm text-gray-600 dark:text-gray-400">
                                        <?php echo e($provider['description']); ?>

                                    </p>
                                </div>
                            </div>

                            <?php if($hasKey): ?>
                                <div class="flex items-center gap-2">
                                    <?php if($userKey->is_active): ?>
                                        <span class="px-3 py-1 bg-green-100 text-green-800 dark:bg-green-900/20 dark:text-green-400 rounded-full text-xs font-medium">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><path d="M22 4L12 14.01l-3-3"/></svg>
                                            مفعّل
                                        </span>
                                    <?php else: ?>
                                        <span class="px-3 py-1 bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-400 rounded-full text-xs font-medium">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">ircle cx="12" cy="12" r="10"/><path d="M10 10l4 4m0-4l-4 4"/></svg>
                                            معطّل
                                        </span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="p-6">
                        <?php if($hasKey): ?>
                            
                            <div class="space-y-4">
                                <div class="flex flex-col md:flex-row items-start md:items-center justify-between p-3 bg-gray-50 dark:bg-gray-900/50 rounded-lg gap-3">
                                    <div>
                                        <p class="text-xs text-gray-500 dark:text-gray-400 mb-1">المفتاح الحالي</p>
                                        <p class="font-mono text-sm text-gray-800 dark:text-gray-200">
                                            <?php echo e($userKey->masked_key); ?>

                                        </p>
                                    </div>
                                    <div class="flex items-center gap-2 flex-wrap">
                                        <button onclick="editKey('<?php echo e($providerId); ?>', <?php echo e($userKey->id); ?>)"
                                                class="px-3 py-2 text-xs bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"/><path d="M18.5 2.5a2.12 2.12 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"/></svg>
                                            تعديل
                                        </button>
                                        <button onclick="toggleKey(<?php echo e($userKey->id); ?>)"
                                                class="px-3 py-2 text-xs bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18.36 6.64a9 9 0 1 1-12.73 0"/><line x1="12" y1="2" x2="12" y2="12"/></svg>
                                            <?php echo e($userKey->is_active ? 'تعطيل' : 'تفعيل'); ?>

                                        </button>
                                        <button onclick="deleteKey(<?php echo e($userKey->id); ?>)"
                                                class="px-3 py-2 text-xs bg-red-50 dark:bg-red-900/20 text-red-600 dark:text-red-400 border border-red-200 dark:border-red-800 rounded-lg hover:bg-red-100 dark:hover:bg-red-900/30 transition-colors">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M3 6h18"/><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"/></svg>
                                            حذف
                                        </button>
                                    </div>
                                </div>

                                <?php if($userKey->last_used_at): ?>
                                    <div class="flex flex-wrap items-center gap-4 text-xs text-gray-600 dark:text-gray-400">
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">ircle cx="12" cy="12" r="10"/><path d="M12 6v6l4 2"/></svg>
                                            آخر استخدام: <?php echo e($userKey->last_used_at->diffForHumans()); ?>

                                        </span>
                                        <span>
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M3 3v18h18"/><path d="M18 17l-6-6-4 4"/></svg>
                                            عدد الاستخدامات: <?php echo e(number_format($userKey->usage_count)); ?>

                                        </span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            
                            <form id="form-<?php echo e($providerId); ?>" onsubmit="saveKey(event, '<?php echo e($providerId); ?>')" class="space-y-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                        مفتاح API
                                        <span class="text-red-500">*</span>
                                    </label>
                                    <div class="relative">
                                        <input type="password"
                                               id="api-key-<?php echo e($providerId); ?>"
                                               name="api_key"
                                               placeholder="أدخل مفتاح API"
                                               required
                                               minlength="20"
                                               class="w-full px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-<?php echo e($provider['color']); ?>-500 focus:border-<?php echo e($provider['color']); ?>-500 dark:bg-gray-700 dark:text-white pr-10">
                                        <button type="button"
                                                onclick="togglePassword('<?php echo e($providerId); ?>')"
                                                class="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" id="eye-icon-<?php echo e($providerId); ?>" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>ircle cx="12" cy="12" r="3"/>
                                            </svg>
                                        </button>
                                    </div>
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-3 h-3 inline-block ml-1" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/><polyline points="15 3 21 3 21 9"/><line x1="10" y1="14" x2="21" y2="3"/></svg>
                                        <a href="<?php echo e($provider['link']); ?>" target="_blank" class="text-<?php echo e($provider['color']); ?>-600 dark:text-<?php echo e($provider['color']); ?>-400 hover:underline">
                                            احصل على مفتاح API من هنا
                                        </a>
                                    </p>
                                </div>

                                <div class="flex items-center justify-between gap-3">
                                    <button type="button"
                                            onclick="testKey('<?php echo e($providerId); ?>')"
                                            class="flex-1 px-4 py-2 border border-gray-300 dark:border-gray-600 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors text-sm">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 inline-block ml-2" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><path d="M22 4L12 14.01l-3-3"/></svg>
                                        اختبار المفتاح
                                    </button>
                                    <button type="submit"
                                            class="flex-1 px-4 py-2 bg-<?php echo e($provider['color']); ?>-600 text-white rounded-lg hover:bg-<?php echo e($provider['color']); ?>-700 transition-colors text-sm">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 inline-block ml-2" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/><polyline points="17 21 17 13 7 13 7 21"/><polyline points="7 3 7 9 17 9"/></svg>
                                        حفظ المفتاح
                                    </button>
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>


    <script>
        function togglePassword(provider) {
            const input = document.getElementById(`api-key-${provider}`);
            const icon = document.getElementById(`eye-icon-${provider}`);
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.innerHTML = '<path d="M17.94 17.94A10.07 10.07 0 0 1 12 20c-7 0-11-8-11-8a18.45 18.45 0 0 1 5.06-5.94M9.9 4.24A9.12 9.12 0 0 1 12 4c7 0 11 8 11 8a18.5 18.5 0 0 1-2.16 3.19m-6.72-1.07a3 3 0 1 1-4.24-4.24"/><line x1="1" y1="1" x2="23" y2="23"/>';
            } else {
                input.type = 'password';
                icon.innerHTML = '<path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"/>ircle cx="12" cy="12" r="3"/>';
            }
        }

        function saveKey(event, provider) {
            event.preventDefault();
            
            const form = event.target;
            const apiKey = form.querySelector('input[name="api_key"]').value.trim();
            const submitBtn = form.querySelector('button[type="submit"]');
            const originalHtml = submitBtn.innerHTML;
            
            if (!apiKey || apiKey.length < 20) {
                alert('❌ يجب أن يكون المفتاح 20 حرفاً على الأقل');
                return;
            }
            
            console.log('🔍 Saving key:', { provider, keyLength: apiKey.length });
            
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<svg class="animate-spin w-4 h-4 inline-block ml-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">ircle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> جاري الحفظ...';
            
            fetch('<?php echo e(route("ai-keys.store")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    provider: provider,
                    api_key: apiKey,
                    is_active: true
                })
            })
            .then(response => response.json())
            .then(data => {
                console.log('✅ Response:', data);
                
                if (data.success) {
                    alert('✅ ' + data.message);
                    location.reload();
                } else {
                    alert('❌ ' + (data.message || 'حدث خطأ'));
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalHtml;
                }
            })
            .catch(error => {
                console.error('❌ Error:', error);
                alert('❌ حدث خطأ في الاتصال');
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalHtml;
            });
        }

        function testKey(provider) {
            const apiKey = document.getElementById(`api-key-${provider}`).value.trim();
            
            if (!apiKey || apiKey.length < 20) {
                alert('❌ يرجى إدخال مفتاح API صالح أولاً (20 حرفاً على الأقل)');
                return;
            }
            
            const testBtn = event.target;
            const originalHtml = testBtn.innerHTML;
            testBtn.disabled = true;
            testBtn.innerHTML = '<svg class="animate-spin w-4 h-4 inline-block ml-2" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">ircle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg> اختبار...';
            
            fetch('<?php echo e(route("ai-keys.test")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    provider: provider,
                    api_key: apiKey
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('✅ ' + data.message);
                } else {
                    alert('❌ ' + data.message);
                }
                testBtn.disabled = false;
                testBtn.innerHTML = originalHtml;
            })
            .catch(error => {
                console.error('Error:', error);
                alert('❌ فشل اختبار المفتاح');
                testBtn.disabled = false;
                testBtn.innerHTML = originalHtml;
            });
        }

        function toggleKey(keyId) {
            if (!confirm('هل تريد تغيير حالة هذا المفتاح؟')) {
                return;
            }
            
            fetch(`/ai-keys/${keyId}/toggle`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('✅ ' + data.message);
                    location.reload();
                } else {
                    alert('❌ حدث خطأ');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('❌ حدث خطأ');
            });
        }

        function deleteKey(keyId) {
            if (!confirm('هل أنت متأكد من حذف هذا المفتاح؟\nسيؤدي ذلك إلى إيقاف جميع الخدمات المرتبطة به.')) {
                return;
            }
            
            fetch(`/ai-keys/${keyId}`, {
                method: 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('✅ ' + data.message);
                    location.reload();
                } else {
                    alert('❌ حدث خطأ');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('❌ حدث خطأ');
            });
        }

        function editKey(provider, keyId) {
            const newKey = prompt('أدخل المفتاح الجديد:');
            
            if (!newKey || newKey.length < 20) {
                if (newKey) alert('❌ يجب أن يكون المفتاح 20 حرفاً على الأقل');
                return;
            }
            
            if (!confirm('هل أنت متأكد من تحديث المفتاح؟')) {
                return;
            }
            
            fetch('<?php echo e(route("ai-keys.store")); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({
                    provider: provider,
                    api_key: newKey,
                    is_active: true
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('✅ ' + data.message);
                    location.reload();
                } else {
                    alert('❌ ' + (data.message || 'حدث خطأ'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('❌ حدث خطأ');
            });
        }
    </script>
  
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/ai-keys/index.blade.php ENDPATH**/ ?>