<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> إعدادات النظام <?php $__env->endSlot(); ?>

<div class="p-6 space-y-6" dir="rtl">

<!-- رأس الصفحة -->
<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
    <div>
        <h1 class="text-3xl font-bold text-foreground flex items-center gap-2">
            <div class="w-8 h-8 bg-gradient-to-r from-teal-500 to-cyan-500 rounded-lg flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                    <path d="M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.39a2 2 0 0 0-.73-2.73l-.15-.08a2 2 0 0 1-1-1.74v-.5a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z"/>
                    <circle cx="12" cy="12" r="3"/>
                </svg>
            </div>
            <?php echo e(__('messages.system_settings')); ?>

        </h1>
        <p class="text-muted-foreground"><?php echo e(__('messages.manage_smtp_payment_gateways')); ?></p>
    </div>
</div>

<!-- رسالة النجاح -->
<?php if(session('success')): ?>
    <div class="bg-green-50 border border-green-200 text-green-700 px-6 py-4 rounded-xl flex items-center gap-3">
        <div class="w-8 h-8 bg-green-500 rounded-full flex items-center justify-center flex-shrink-0">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                <polyline points="20 6 9 17 4 12"/>
            </svg>
        </div>
        <div class="text-sm font-medium"><?php echo e(session('success')); ?></div>
    </div>
<?php endif; ?>

<!-- بطاقة الإعدادات الرئيسية -->
<div data-slot="card" class="bg-card text-card-foreground rounded-xl border shadow-sm">
    
    <!-- شريط التبويب -->
    <div class="px-6 pt-6">
        <div class="flex flex-wrap gap-2 bg-muted rounded-lg p-1">
            <button class="tab-btn flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-md transition-all active" data-tab="smtp">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect width="20" height="16" x="2" y="4" rx="2"/>
                    <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"/>
                </svg>
                <?php echo e(__('messages.smtp_settings')); ?>

            </button>
            <button class="tab-btn flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-md transition-all" data-tab="stripe">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <rect width="20" height="14" x="2" y="5" rx="2"/>
                    <line x1="2" x2="22" y1="10" y2="10"/>
                </svg>
                <?php echo e(__('messages.stripe_settings')); ?>

            </button>
            <button class="tab-btn flex items-center gap-2 px-4 py-2 text-sm font-medium rounded-md transition-all" data-tab="paypal">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <line x1="12" x2="12" y1="2" y2="22"/>
                    <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                </svg>
                <?php echo e(__('messages.paypal_settings')); ?>

            </button>
        </div>
    </div>

    <!-- محتوى التبويب - إعدادات SMTP -->
    <div class="tab-content p-6" id="tab-smtp">
        <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
            <?php echo csrf_field(); ?>
            
            <div data-slot="card-header" class="mb-6">
                <h2 class="text-xl font-semibold flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                        <rect width="20" height="16" x="2" y="4" rx="2"/>
                        <path d="m22 7-8.97 5.7a1.94 1.94 0 0 1-2.06 0L2 7"/>
                    </svg>
                    <?php echo e(__('messages.smtp_settings')); ?>

                </h2>
                <p class="text-sm text-muted-foreground mt-1">قم بتكوين إعدادات خادم البريد الإلكتروني لإرسال الرسائل</p>
            </div>

            <div class="space-y-6">
                <!-- الصف الأول -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_host')); ?></label>
                        <input type="text" name="smtp_host" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_host'] ?? ''); ?>" 
                               placeholder="smtp.gmail.com">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_port')); ?></label>
                        <input type="text" name="smtp_port" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_port'] ?? ''); ?>" 
                               placeholder="587">
                    </div>
                </div>

                <!-- الصف الثاني -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_username')); ?></label>
                        <input type="text" name="smtp_username" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_username'] ?? ''); ?>" 
                               placeholder="your@email.com">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_password')); ?></label>
                        <input type="password" name="smtp_password" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_password'] ?? ''); ?>" 
                               placeholder="••••••••">
                    </div>
                </div>

                <!-- الصف الثالث -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_encryption')); ?></label>
                        <input type="text" name="smtp_encryption" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_encryption'] ?? ''); ?>" 
                               placeholder="tls">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_from_email')); ?></label>
                        <input type="email" name="smtp_from_email" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_from_email'] ?? ''); ?>" 
                               placeholder="noreply@yoursite.com">
                    </div>
                </div>

                <!-- الصف الرابع -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_from_name')); ?></label>
                        <input type="text" name="smtp_from_name" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['smtp_from_name'] ?? ''); ?>" 
                               placeholder="اسم الموقع">
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.smtp_test_recipient')); ?></label>
                        <input type="email" name="smtp_test_recipient" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e(old('smtp_test_recipient')); ?>" 
                               placeholder="test@example.com">
                    </div>
                </div>

                <!-- أزرار الحفظ والاختبار -->
                <div class="flex flex-col sm:flex-row gap-3 pt-4 border-t border-border">
                    <button type="submit" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                            <polyline points="17,21 17,13 7,13 7,21"/>
                            <polyline points="7,3 7,8 15,8"/>
                        </svg>
                        <?php echo e(__('messages.save_settings')); ?>

                    </button>
                    
                    <button type="submit" name="test_smtp" value="1" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 border border-input bg-background hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="m3 11 18-5v12L3 14v-3z"/>
                            <path d="M11.6 16.8a3 3 0 1 1-5.8-1.6"/>
                        </svg>
                        <?php echo e(__('messages.send_test_email')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- محتوى التبويب - إعدادات Stripe -->
    <div class="tab-content p-6 hidden" id="tab-stripe">
        <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
            <?php echo csrf_field(); ?>
            
            <div data-slot="card-header" class="mb-6">
                <h2 class="text-xl font-semibold flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                        <rect width="20" height="14" x="2" y="5" rx="2"/>
                        <line x1="2" x2="22" y1="10" y2="10"/>
                    </svg>
                    <?php echo e(__('messages.stripe_settings')); ?>

                </h2>
                <p class="text-sm text-muted-foreground mt-1">قم بتكوين إعدادات بوابة الدفع Stripe</p>
            </div>

            <div class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.stripe_key')); ?></label>
                        <input type="text" name="stripe_key" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['stripe_key'] ?? ''); ?>" 
                               placeholder="pk_test_...">
                        <p class="text-xs text-muted-foreground">المفتاح العام القابل للنشر</p>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.stripe_secret')); ?></label>
                        <input type="password" name="stripe_secret" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['stripe_secret'] ?? ''); ?>" 
                               placeholder="sk_test_...">
                        <p class="text-xs text-muted-foreground">المفتاح السري</p>
                    </div>
                </div>

                <!-- تنبيه مهم -->
                <div class="bg-blue-50 border border-blue-200 text-blue-700 px-4 py-3 rounded-lg">
                    <div class="flex items-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="flex-shrink-0 mt-0.5">
                            <circle cx="12" cy="12" r="10"/>
                            <path d="m9 12 2 2 4-4"/>
                        </svg>
                        <div class="text-sm">
                            <p class="font-medium mb-1">معلومات مهمة:</p>
                            <ul class="list-disc list-inside space-y-1 text-xs">
                                <li>استخدم مفاتيح الاختبار أثناء التطوير</li>
                                <li>تأكد من إعداد Webhook URLs في لوحة تحكم Stripe</li>
                                <li>احرص على حماية المفتاح السري</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="flex justify-start pt-4 border-t border-border">
                    <button type="submit" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                            <polyline points="17,21 17,13 7,13 7,21"/>
                            <polyline points="7,3 7,8 15,8"/>
                        </svg>
                        <?php echo e(__('messages.save_settings')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- محتوى التبويب - إعدادات PayPal -->
    <div class="tab-content p-6 hidden" id="tab-paypal">
        <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>">
            <?php echo csrf_field(); ?>
            
            <div data-slot="card-header" class="mb-6">
                <h2 class="text-xl font-semibold flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                        <line x1="12" x2="12" y1="2" y2="22"/>
                        <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                    </svg>
                    <?php echo e(__('messages.paypal_settings')); ?>

                </h2>
                <p class="text-sm text-muted-foreground mt-1">قم بتكوين إعدادات بوابة الدفع PayPal</p>
            </div>

            <div class="space-y-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground"><?php echo e(__('messages.paypal_email')); ?></label>
                        <input type="email" name="paypal_email" 
                               class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-sm shadow-xs transition-colors file:border-0 file:bg-transparent file:text-sm file:font-medium file:text-foreground placeholder:text-muted-foreground focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:cursor-not-allowed disabled:opacity-50" 
                               value="<?php echo e($settings['paypal_email'] ?? ''); ?>" 
                               placeholder="business@example.com">
                        <p class="text-xs text-muted-foreground">البريد الإلكتروني للحساب التجاري</p>
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-medium text-foreground">وضع PayPal</label>
                        <select name="paypal_mode" 
                                class="flex h-9 w-full items-center justify-between rounded-md border border-input bg-background px-3 py-2 text-sm ring-offset-background placeholder:text-muted-foreground focus:outline-none focus:ring-1 focus:ring-ring disabled:cursor-not-allowed disabled:opacity-50">
                            <option value="sandbox" <?php if(($settings['paypal_mode'] ?? '') == 'sandbox'): echo 'selected'; endif; ?>><?php echo e(__('messages.sandbox')); ?></option>
                            <option value="live" <?php if(($settings['paypal_mode'] ?? '') == 'live'): echo 'selected'; endif; ?>><?php echo e(__('messages.live')); ?></option>
                        </select>
                        <p class="text-xs text-muted-foreground">اختر وضع الاختبار أو المباشر</p>
                    </div>
                </div>

                <!-- تنبيه مهم -->
                <div class="bg-yellow-50 border border-yellow-200 text-yellow-800 px-4 py-3 rounded-lg">
                    <div class="flex items-start gap-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="flex-shrink-0 mt-0.5">
                            <path d="m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3Z"/>
                            <line x1="12" y1="9" x2="12" y2="13"/>
                            <line x1="12" y1="17" x2="12.01" y2="17"/>
                        </svg>
                        <div class="text-sm">
                            <p class="font-medium mb-1">تنبيه مهم:</p>
                            <ul class="list-disc list-inside space-y-1 text-xs">
                                <li>استخدم وضع Sandbox للاختبار</li>
                                <li>تأكد من التحقق من الحساب التجاري</li>
                                <li>قم بإعداد IPN للإشعارات التلقائية</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="flex justify-start pt-4 border-t border-border">
                    <button type="submit" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"/>
                            <polyline points="17,21 17,13 7,13 7,21"/>
                            <polyline points="7,3 7,8 15,8"/>
                        </svg>
                        <?php echo e(__('messages.save_settings')); ?>

                    </button>
                </div>
            </div>
        </form>
    </div>

    <!-- تذييل البطاقة -->
    <div class="px-6 py-4 border-t border-border bg-muted/30 rounded-b-xl">
        <div class="flex flex-col sm:flex-row justify-between items-center gap-4">
            <div class="text-sm text-muted-foreground">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="inline mr-1">
                    <circle cx="12" cy="12" r="10"/>
                    <polyline points="12 6 12 12 16 14"/>
                </svg>
                <?php echo e(__('messages.Last updated')); ?>: <?php echo e($settings['updated_at'] ?? 'غير محدد'); ?>

            </div>
            
            <div class="flex items-center gap-2">
                <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
                <span class="text-sm text-muted-foreground">النظام يعمل</span>
            </div>
        </div>
    </div>
</div>

</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    // إدارة التبويب
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabButtons.forEach(function (btn) {
        btn.addEventListener('click', function () {
            // إزالة التفعيل من جميع الأزرار
            tabButtons.forEach(b => {
                b.classList.remove('active', 'bg-background', 'text-foreground', 'shadow-sm');
                b.classList.add('text-muted-foreground', 'hover:text-foreground');
            });
            
            // تفعيل الزر المحدد
            btn.classList.add('active', 'bg-background', 'text-foreground', 'shadow-sm');
            btn.classList.remove('text-muted-foreground', 'hover:text-foreground');
            
            // إخفاء جميع المحتويات
            tabContents.forEach(c => c.classList.add('hidden'));
            
            // إظهار المحتوى المحدد
            const targetTab = btn.getAttribute('data-tab');
            const targetContent = document.getElementById('tab-' + targetTab);
            if (targetContent) {
                targetContent.classList.remove('hidden');
            }
        });
    });

    // تفعيل التبويب الأول عند التحميل
    if (tabButtons.length > 0) {
        const firstTab = tabButtons[0];
        firstTab.classList.add('active', 'bg-background', 'text-foreground', 'shadow-sm');
        firstTab.classList.remove('text-muted-foreground');
    }

    // تحسين تجربة المستخدم للنماذج
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function() {
            const submitBtn = this.querySelector('button[type="submit"]');
            if (submitBtn && !submitBtn.name) {
                submitBtn.disabled = true;
                const originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = `
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="animate-spin mr-2">
                        <path d="M21 12a9 9 0 11-6.219-8.56"/>
                    </svg>
                    جاري الحفظ...
                `;
                
                setTimeout(() => {
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = originalText;
                }, 5000);
            }
        });
    });

    // تأثيرات بصرية للحقول
    const inputs = document.querySelectorAll('input, select, textarea');
    inputs.forEach(input => {
        input.addEventListener('focus', function() {
            this.parentElement.classList.add('focused');
        });
        
        input.addEventListener('blur', function() {
            this.parentElement.classList.remove('focused');
        });
    });

    // تنبيه للاختبار
    const testButtons = document.querySelectorAll('button[name="test_smtp"]');
    testButtons.forEach(button => {
        button.addEventListener('click', function() {
            const testEmail = document.querySelector('input[name="smtp_test_recipient"]');
            if (!testEmail.value) {
                alert('يرجى إدخال بريد إلكتروني للاختبار');
                testEmail.focus();
                return false;
            }
        });
    });
});
</script>

<style>
/* تحسين التبويب */
.tab-btn.active {
    background-color: rgb(255 255 255);
    color: rgb(15 23 42);
    box-shadow: 0 1px 2px 0 rgb(0 0 0 / 0.05);
}

.tab-btn:not(.active) {
    color: rgb(100 116 139);
}

.tab-btn:not(.active):hover {
    color: rgb(15 23 42);
    background-color: rgb(248 250 252);
}

/* تحسين الحقول */
.focused {
    transform: scale(1.01);
    transition: transform 0.2s ease;
}

/* تحسين الأزرار */
button, a {
    transition: all 0.2s ease;
}

button:hover:not(:disabled), a:hover {
    transform: translateY(-1px);
}

/* تحسين التأثيرات البصرية */
.shadow-xs {
    box-shadow: 0 1px 2px 0 rgb(0 0 0 / 0.05);
}

/* تحسين الاستجابة */
@media (max-width: 768px) {
    .grid-cols-1.md\:grid-cols-2 {
        grid-template-columns: repeat(1, minmax(0, 1fr));
    }
    
    .flex-col.sm\:flex-row {
        flex-direction: column;
    }
    
    .px-6 {
        padding-left: 1rem;
        padding-right: 1rem;
    }
}

/* تحسين المساحات */
.space-y-2 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 0.5rem;
}

.space-y-4 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 1rem;
}

.space-y-6 > :not([hidden]) ~ :not([hidden]) {
    margin-top: 1.5rem;
}

/* تحسين الألوان */
.bg-muted\/30 {
    background-color: rgb(244 244 245 / 0.3);
}

.text-muted-foreground {
    color: rgb(100 116 139);
}

.border-input {
    border-color: rgb(228 228 231);
}

/* تحسين التأثيرات الديناميكية */
.animate-pulse {
    animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: .5; }
}

.animate-spin {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

/* تحسين الظلال */
.bg-card:hover {
    box-shadow: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -1px rgb(0 0 0 / 0.06);
}

/* تحسين الانتقالات */
.transition-all {
    transition: all 0.2s ease;
}

/* تحسين النصوص */
.text-foreground {
    color: rgb(15 23 42);
}

.bg-background {
    background-color: rgb(255 255 255);
}
</style>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/admin/settings/edit.blade.php ENDPATH**/ ?>