<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            شراء الباقة: <?php echo e($plan->title); ?>

        </h2>
     <?php $__env->endSlot(); ?>

<div class="min-h-screen  p-4 sm:p-6 lg:p-8">
    <div class="max-w-4xl mx-auto">
        <!-- رأس الصفحة -->
        <div class="text-center mb-8">
            <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 mb-4">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M19 12H5m7-7-7 7 7 7"/>
                </svg>
                <?php echo e(__('messages.back_to_plans')); ?>

            </a>
            <h1 class="text-3xl font-bold text-foreground mb-2"><?php echo e(__('messages.complete_purchase')); ?></h1>
            <p class="text-muted-foreground"><?php echo e(__('messages.youre_subscribing_to')); ?> <span class="font-semibold text-primary"><?php echo e($plan->title); ?></span> <?php echo e(__('messages.plan')); ?></p>
        </div>

        <!-- رسائل التحذير والأخطاء -->
        <?php if(session('error')): ?>
            <div class="mb-6 p-4 bg-red-50 border border-red-200 rounded-lg">
                <div class="flex items-center">
                    <svg class="w-5 h-5 text-red-500 mr-3" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                    </svg>
                    <div>
                        <h3 class="text-red-800 font-medium">خطأ في الدفع</h3>
                        <p class="text-red-700 text-sm"><?php echo e(session('error')); ?></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="grid gap-6 lg:grid-cols-2">
            <!-- ملخص الطلب -->
            <div class="bg-card text-card-foreground rounded-xl border shadow-sm overflow-hidden">
                <div class="px-6 py-4 border-b border-border bg-muted/30">
                    <h3 class="font-semibold text-lg flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M8 6h13"/>
                            <path d="M6 12h13"/>
                            <path d="M4 18h13"/>
                        </svg>
                        <?php echo e(__('messages.order_summary')); ?>

                    </h3>
                </div>
                
                <div class="p-6 space-y-6">
                    <!-- تفاصيل الباقة -->
                    <div class="flex items-center gap-4 p-4 bg-muted/30 rounded-lg">
                        <div class="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary">
                                <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                            </svg>
                        </div>
                        <div class="flex-grow">
                            <h4 class="font-semibold text-foreground"><?php echo e($plan->title); ?></h4>
                            <p class="text-sm text-muted-foreground"><?php echo e($plan->description ?? 'باقة مميزة للمستخدمين'); ?></p>
                        </div>
                        <div class="text-right">
                            <div class="font-bold text-lg">$<?php echo e(number_format($plan->price, 2)); ?></div>
                            <div class="text-xs text-muted-foreground">/ <?php echo e($plan->period_days); ?> <?php echo e($plan->period_type == 'days' ? 'يوم' : ($plan->period_type == 'months' ? 'شهر' : 'سنة')); ?></div>
                        </div>
                    </div>

                    <!-- عرض المزايا الرئيسية -->
                    <?php if($plan->features): ?>
                        <div class="space-y-3">
                            <h4 class="font-medium text-foreground">المزايا المضمنة:</h4>
                            <div class="grid grid-cols-1 gap-2">
                                <?php
                                    $mainFeatures = array_slice($plan->features, 0, 5, true);
                                ?>
                                <?php $__currentLoopData = $mainFeatures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($value > 0 || $value == -1): ?>
                                        <div class="flex items-center gap-2 text-sm">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                                                <polyline points="20 6 9 17 4 12"/>
                                            </svg>
                                            <span>
                                                <?php echo e(ucfirst(str_replace('_', ' ', $key))); ?>: 
                                                <?php if($value == -1): ?>
                                                    <span class="text-green-600 font-medium">غير محدود</span>
                                                <?php else: ?>
                                                    <span class="font-medium"><?php echo e($value); ?></span>
                                                <?php endif; ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if(count($plan->features) > 5): ?>
                                    <div class="text-xs text-muted-foreground">+ <?php echo e(count($plan->features) - 5); ?> مزايا إضافية</div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- تطبيق كوبون الخصم -->
                    <div class="border-t pt-4">
                        <div class="space-y-3">
                            <label class="flex items-center gap-2 text-sm font-medium" for="coupon_code">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M21 12a9 9 0 1 1-6.219-8.56"/>
                                </svg>
                                <?php echo e(__('messages.have_coupon_code')); ?>

                            </label>
                            
                            <div class="flex gap-2">
                                <input class="flex h-10 w-full rounded-md border border-input bg-background px-3 py-2 text-sm placeholder-muted-foreground focus:border-primary focus:ring-2 focus:ring-primary/20" 
                                       id="coupon_code" 
                                       name="coupon_code" 
                                       placeholder="<?php echo e(__('messages.enter_coupon_code')); ?>" 
                                       value="<?php echo e(old('coupon_code')); ?>"
                                       autocomplete="off">
                                <button type="button" 
                                        id="check-coupon-btn" 
                                        class="inline-flex items-center justify-center gap-2 rounded-md text-sm font-medium bg-primary text-primary-foreground hover:bg-primary/90 h-10 px-4 py-2 whitespace-nowrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <polyline points="20 6 9 17 4 12"/>
                                    </svg>
                                    <?php echo e(__('messages.apply')); ?>

                                </button>
                            </div>
                            
                            <div id="coupon-message" class="min-h-[1rem]"></div>
                            
                            <?php if(session('coupon_success')): ?>
                                <div class="p-3 bg-green-50 border border-green-200 rounded-md text-green-800 text-sm"><?php echo e(session('coupon_success')); ?></div>
                            <?php endif; ?>
                            <?php if(session('coupon_error')): ?>
                                <div class="p-3 bg-red-50 border border-red-200 rounded-md text-red-800 text-sm"><?php echo e(session('coupon_error')); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- إجمالي السعر -->
                    <div class="border-t pt-4">
                        <div class="space-y-2">
                            <div class="flex justify-between text-sm">
                                <span>السعر الأساسي:</span>
                                <span id="original-price">$<?php echo e(number_format($plan->price, 2)); ?></span>
                            </div>
                            <div id="discount-row" class="hidden flex justify-between text-sm text-green-600">
                                <span>الخصم:</span>
                                <span id="discount-amount">-$0.00</span>
                            </div>
                            <div class="flex justify-between font-bold text-lg pt-2 border-t">
                                <span><?php echo e(__('messages.total')); ?>:</span>
                                <span class="text-primary" id="final-total">$<?php echo e(number_format($plan->price, 2)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- تفاصيل الدفع -->
            <div class="bg-card text-card-foreground rounded-xl border shadow-sm overflow-hidden">
                <div class="px-6 py-4 border-b border-border bg-muted/30">
                    <h3 class="font-semibold text-lg flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <rect width="20" height="14" x="2" y="5" rx="2"/>
                            <line x1="2" x2="22" y1="10" y2="10"/>
                        </svg>
                        <?php echo e(__('messages.payment_details')); ?>

                    </h3>
                    <p class="text-sm text-muted-foreground mt-1"><?php echo e(__('messages.your_payment_info_secure')); ?></p>
                </div>
                
                <div class="p-6">
                    <form id="checkout-form" method="POST" action="<?php echo e(route('plans.processCheckout', $plan)); ?>" class="space-y-6">
                        <?php echo csrf_field(); ?>
                        
                        <!-- معلومات المستخدم -->
                        <div class="space-y-4">
                            <div>
                                <label class="block text-sm font-medium mb-2" for="email"><?php echo e(__('messages.email_address')); ?></label>
                                <input class="flex h-10 w-full rounded-md border border-input bg-muted px-3 py-2 text-sm text-muted-foreground" 
                                       id="email" 
                                       name="email" 
                                       type="email" 
                                       value="<?php echo e(old('email', auth()->user()->email ?? '')); ?>" 
                                       disabled>
                            </div>

                            <div>
                                <label class="block text-sm font-medium mb-2" for="payment_method"><?php echo e(__('messages.select_payment_option')); ?></label>
                                <select id="payment-method" 
                                        name="payment_method" 
                                        class="flex h-10 w-full rounded-md border border-input bg-background px-3 py-2 text-sm focus:border-primary focus:ring-2 focus:ring-primary/20" 
                                        required>
                                    <option value="">اختر طريقة الدفع</option>
                                 <!--   <option value="stripe">
                                        💳 <?php echo e(__('messages.credit_card')); ?> (Stripe)
                                    </option> -->
                                    <option value="paypal">
                                        🎯 <?php echo e(__('messages.paypal')); ?>

                                    </option>
                                </select>
                            </div>
                        </div>

                        <!-- رسائل الأمان -->
                        <div class="p-4 bg-blue-50 border border-blue-200 rounded-lg">
                            <div class="flex items-start gap-3">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600 mt-0.5">
                                    <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/>
                                </svg>
                                <div class="text-sm text-blue-800">
                                    <p class="font-medium mb-1">معلوماتك آمنة ومحمية</p>
                                    <p>نستخدم أحدث تقنيات التشفير لحماية بياناتك المالية</p>
                                     <p>لا يتم حفظ بيانات الدفع لدينا اطلاقا</p>
                                </div>
                            </div>
                        </div>

                        <!-- أزرار الدفع -->
                      <!-- أزرار الدفع -->
<div class="space-y-4">
    <!-- زر Stripe -->
    <div id="stripe-submit" style="display:none;">
        <button id="pay-btn" 
                class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 bg-primary text-primary-foreground shadow-xs hover:bg-primary/90 h-12 px-6 py-3" 
                type="submit">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                <rect width="18" height="11" x="3" y="11" rx="2" ry="2"/>
                <path d="M7 11V7a5 5 0 0 1 10 0v4"/>
            </svg>
            <span class="font-semibold">دفع $<span id="pay-amount"><?php echo e(number_format($plan->price, 2)); ?></span></span>
        </button>
    </div>

    <!-- زر PayPal -->
    <div id="paypal-submit" style="display:none;">
        <button 
                class="w-full inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 bg-[#0070BA] text-white shadow-xs hover:bg-[#005EA6] h-12 px-6 py-3" 
                type="submit">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                <path d="M20.067 8.478c.492.88.556 2.014.3 3.327-.74 3.806-3.276 5.12-6.514 5.12h-.5a.805.805 0 0 0-.794.68l-.04.22-.63 3.993-.032.17a.804.804 0 0 1-.794.679H7.72a.483.483 0 0 1-.477-.558L9.426 7.68a.805.805 0 0 1 .794-.68h4.85c1.773 0 2.974.368 3.675 1.114.38.403.625.856.76 1.364h.002c.03.14.05.28.06.42v.58z"/>
            </svg>
            <span class="font-semibold">الدفع عبر PayPal</span>
        </button>
    </div>
    
    <!-- رسالة اختيار طريقة الدفع -->
    <div id="select-payment-message" class="text-center p-6 text-muted-foreground">
        <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mx-auto mb-3 text-muted-foreground/50">
            <rect width="20" height="14" x="2" y="5" rx="2"/>
            <line x1="2" x2="22" y1="10" y2="10"/>
        </svg>
        <p>اختر طريقة الدفع للمتابعة</p>
    </div>
</div>


                        <!-- شروط الخدمة -->
                        <div class="pt-4 border-t">
                            <p class="text-xs text-muted-foreground text-center leading-relaxed">
                                <?php echo e(__('messages.By completing your purchase')); ?>، 
                                <?php echo e(__('messages.you agree to')); ?>

                                <a href="/terms-of-services" class="text-primary hover:underline font-medium"><?php echo e(__('messages.our Terms of Service')); ?></a>
                                <?php echo e(__('messages.and')); ?>

                                <a href="/privacy" class="text-primary hover:underline font-medium"><?php echo e(__('messages.Privacy Policy')); ?></a>.
                                
                            </p>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- معلومات إضافية -->
        <div class="mt-8 text-center">
            <div class="inline-flex items-center gap-6 text-sm text-muted-foreground">
                <div class="flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                        <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10"/>
                    </svg>
                    <span>SSL آمن</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                        <polyline points="20 6 9 17 4 12"/>
                    </svg>
                    <span>إلغاء في أي وقت</span>
                </div>
                <div class="flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                        <circle cx="12" cy="12" r="10"/>
                        <path d="M12 16v-4"/>
                        <path d="M12 8h.01"/>
                    </svg>
                    <span>دعم 24/7</span>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Replace the entire PayPal section with this -->
<script>
// متغيرات عامة
const planPrice = <?php echo e($plan->price); ?>;
let currentDiscount = 0;
let appliedCoupon = null;

// عناصر DOM
const couponInput = document.getElementById('coupon_code');
const couponBtn = document.getElementById('check-coupon-btn');
const couponMessage = document.getElementById('coupon-message');
const paymentMethod = document.getElementById('payment-method');
const stripeSubmit = document.getElementById('stripe-submit');
const paypalSubmit = document.getElementById('paypal-submit');
const selectMessage = document.getElementById('select-payment-message');
const payAmount = document.getElementById('pay-amount');
const finalTotal = document.getElementById('final-total');
const discountRow = document.getElementById('discount-row');
const discountAmount = document.getElementById('discount-amount');

// وظائف مساعدة
function formatPrice(price) {
    return parseFloat(price).toFixed(2);
}

function showMessage(element, message, type = 'info') {
    const colors = {
        success: 'bg-green-50 border-green-200 text-green-800',
        error: 'bg-red-50 border-red-200 text-red-800',
        warning: 'bg-yellow-50 border-yellow-200 text-yellow-800',
        info: 'bg-blue-50 border-blue-200 text-blue-800'
    };
    
    element.innerHTML = `<div class="p-3 rounded-md border ${colors[type]} text-sm">${message}</div>`;
}

function updatePricing(discount = 0, couponData = null) {
    currentDiscount = discount;
    const newPrice = Math.max(0, planPrice - discount);
    
    // تحديث العناصر
    payAmount.textContent = formatPrice(newPrice);
    finalTotal.textContent = '$' + formatPrice(newPrice);
    
    if (discount > 0) {
        discountAmount.textContent = '-$' + formatPrice(discount);
        discountRow.classList.remove('hidden');
    } else {
        discountRow.classList.add('hidden');
    }
}

// التحقق من الكوبون
couponBtn.addEventListener('click', function() {
    const code = couponInput.value.trim();
    
    if (!code) {
        showMessage(couponMessage, '<?php echo e(__("messages.enter_coupon_first")); ?>', 'warning');
        return;
    }
    
    // تعطيل الزر أثناء التحقق
    couponBtn.disabled = true;
    couponBtn.innerHTML = '<svg class="animate-spin w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 0116 0"></path></svg>جارٍ التحقق...';
    
    fetch(`<?php echo e(url('api/coupons/check')); ?>?code=${encodeURIComponent(code)}`)
        .then(response => response.json())
        .then(data => {
            if (data.valid) {
                appliedCoupon = data;
                let discount = 0;
                
                if (data.type === 'percent') {
                    discount = (planPrice * data.value) / 100;
                } else {
                    discount = data.value;
                }
                
                updatePricing(discount, data);
                
                const discountText = data.type === 'percent' ? `${data.value}%` : `$${data.value}`;
                const expiryText = data.expires_at ? ` - ينتهي في: ${data.expires_at}` : '';
                
                showMessage(couponMessage, `
                    <div class="flex items-center gap-2 mb-2">
                        <svg class="w-5 h-5 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="font-medium">تم تطبيق الكوبون بنجاح!</span>
                    </div>
                    <p>خصم ${discountText}${expiryText}</p>
                    <p class="font-medium mt-2">السعر بعد الخصم: $${formatPrice(planPrice - discount)}</p>
                `, 'success');
                
            } else {
                appliedCoupon = null;
                updatePricing(0);
                showMessage(couponMessage, data.message || '<?php echo e(__("messages.coupon_invalid_or_expired")); ?>', 'error');
            }
        })
        .catch(error => {
            console.error('Error checking coupon:', error);
            appliedCoupon = null;
            updatePricing(0);
            showMessage(couponMessage, '<?php echo e(__("messages.error_checking_coupon")); ?>', 'error');
        })
        .finally(() => {
            couponBtn.disabled = false;
            couponBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="20 6 9 17 4 12"/></svg><?php echo e(__("messages.apply")); ?>';
        });
});

// تغيير طريقة الدفع
paymentMethod.addEventListener('change', function() {
    const method = this.value;
    
    // إخفاء جميع خيارات الدفع
    stripeSubmit.style.display = 'none';
    paypalSubmit.style.display = 'none';
    selectMessage.style.display = 'none';
    
    if (method === 'stripe') {
        stripeSubmit.style.display = 'block';
    } else if (method === 'paypal') {
        paypalSubmit.style.display = 'block';
    } else {
        selectMessage.style.display = 'block';
    }
});

// إضافة كوبون إلى النموذج
document.getElementById('checkout-form').addEventListener('submit', function(e) {
    if (appliedCoupon) {
        const couponField = document.createElement('input');
        couponField.type = 'hidden';
        couponField.name = 'coupon_code';
        couponField.value = couponInput.value.trim();
        this.appendChild(couponField);
    }
});

// تحسين تجربة المستخدم
couponInput.addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        couponBtn.click();
    }
});

// تهيئة الصفحة
document.addEventListener('DOMContentLoaded', function() {
    // التركيز على حقل الكوبون إذا كان فارغاً
    if (!couponInput.value) {
        setTimeout(() => couponInput.focus(), 500);
    }
});
</script>


<style>
/* تحسينات CSS إضافية */
.animate-spin {
    animation: spin 1s linear infinite;
}

@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

/* تحسين مظهر حقول الإدخال */
input:focus, select:focus {
    outline: none;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

/* تحسين مظهر الأزرار */
button:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

button:hover:not(:disabled) {
    transform: translateY(-1px);
}

/* تحسين استجابة الشاشة */
@media (max-width: 768px) {
    .grid.lg\\:grid-cols-2 {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .max-w-4xl {
        max-width: 100%;
        padding: 0 1rem;
    }
}

/* تحسين مظهر PayPal container */
#paypal-button-container {
    min-height: 48px;
    border-radius: 6px;
    overflow: hidden;
}

/* تحسين رسائل الحالة */
.alert {
    padding: 0.75rem 1rem;
    border-radius: 0.5rem;
    border: 1px solid;
    font-size: 0.875rem;
}

.alert-success {
    background-color: #f0f9ff;
    border-color: #0ea5e9;
    color: #0c4a6e;
}

.alert-danger {
    background-color: #fef2f2;
    border-color: #f87171;
    color: #991b1b;
}

.alert-warning {
    background-color: #fffbeb;
    border-color: #f59e0b;
    color: #92400e;
}
</style>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/plans/checkout.blade.php ENDPATH**/ ?>