
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> إدارة الردود التلقائية على تعليقات فيسبوك
  <?php $__env->endSlot(); ?>

<div class="p-4 space-y-4 md:space-y-5">
    
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
        <div>
            <h1 class="text-2xl font-bold text-foreground flex items-center gap-2">
                <svg class="h-6 w-6 text-primary" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                </svg>
                <?php echo e(__('الردود التلقائية')); ?>

            </h1>
            <p class="text-sm text-muted-foreground"><?php echo e(__('إدارة الردود التلقائية على تعليقات فيسبوك')); ?></p>
        </div>
        
        <div>
            <?php if(isset($planLimits) && $planLimits['feature_available']): ?>
                <?php if($planLimits['can_create_more']): ?>
                    <a href="<?php echo e(route('auto-replies.create')); ?>" class="inline-flex items-center justify-center gap-1.5 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-primary text-primary-foreground shadow-xs hover:bg-primary/90 h-8 px-3 py-1.5">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <line x1="12" y1="5" x2="12" y2="19"/>
                            <line x1="5" y1="12" x2="19" y2="12"/>
                        </svg>
                        <?php echo e(__('إضافة جديد')); ?> </a>
                <?php else: ?>
                    <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-1.5 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-gradient-to-r from-orange-500 to-orange-600 text-white shadow-xs hover:from-orange-600 hover:to-orange-700 h-8 px-3 py-1.5">
                        <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                            <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                        </svg>
                        <?php echo e(__('ترقية للمزيد')); ?> </a>
                <?php endif; ?>
            <?php else: ?>
                <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-1.5 whitespace-nowrap rounded-md text-sm font-medium transition-all bg-gradient-to-r from-purple-500 to-purple-600 text-white shadow-xs hover:from-purple-600 hover:to-purple-700 h-8 px-3 py-1.5">
                    <svg class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                        <path d="M12 2v20M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"/>
                    </svg>
                    <?php echo e(__('ترقية لتفعيل الميزة')); ?>

                </a>
            <?php endif; ?>
        </div>
    </div>

    <?php if(isset($planLimits)): ?>
        <?php
            $percentage = !$planLimits['unlimited'] && $planLimits['max'] > 0
                ? ($planLimits['current'] / $planLimits['max']) * 100
                : 0;
            $isLow = !$planLimits['unlimited'] && $planLimits['remaining'] <= 2;
            $isFull = !$planLimits['unlimited'] && $planLimits['remaining'] == 0;
            
            // Determine banner color (Logic remains same)
            if (!$planLimits['feature_available']) {
                $bannerColor = 'from-purple-500 to-purple-600';
                $iconBg = 'bg-purple-400/30';
            } elseif ($isFull) {
                $bannerColor = 'from-red-500 to-red-600';
                $iconBg = 'bg-red-400/30';
            } elseif ($isLow) {
                $bannerColor = 'from-orange-500 to-orange-600';
                $iconBg = 'bg-orange-400/30';
            } elseif ($planLimits['unlimited']) {
                $bannerColor = 'from-green-500 to-green-600';
                $iconBg = 'bg-green-400/30';
            } else {
                $bannerColor = 'from-blue-500 to-blue-600';
                $iconBg = 'bg-blue-400/30';
            }
        ?>

        <div class="bg-gradient-to-r <?php echo e($bannerColor); ?> rounded-lg shadow-md overflow-hidden">
            <div class="px-4 py-3">
                <div class="flex items-center justify-between gap-4">
                    <div class="flex items-center gap-3 flex-1 min-w-0">
                        <div class="w-8 h-8 <?php echo e($iconBg); ?> rounded-md flex items-center justify-center flex-shrink-0">
                            <svg class="h-4 w-4 text-white" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                <path d="M13 2L3 14h9l-1 8 10-12h-9l1-8z"/>
                            </svg>
                        </div>
                        
                        <div class="flex-1 min-w-0">
                            <div class="flex items-center gap-2 mb-0.5">
                                <h3 class="text-white font-medium text-sm"><?php echo e(__('الردود النشطة:')); ?></h3>
                                <span class="font-bold text-lg text-white -mr-1"><?php echo e($planLimits['current']); ?></span>
                                <?php if(!$planLimits['unlimited']): ?>
                                    <span class="text-white/80 text-sm">/ <?php echo e($planLimits['max']); ?></span>
                                <?php endif; ?>
                            </div>
                            
                            <?php if(!$planLimits['unlimited']): ?>
                                <div class="flex items-center gap-3 mt-1">
                                    <div class="flex-1 max-w-[150px]">
                                        <div class="w-full bg-white/20 rounded-full h-1.5 overflow-hidden">
                                            <?php
                                                $progressColor = $percentage >= 90 ? 'bg-red-300' : ($percentage >= 70 ? 'bg-yellow-300' : 'bg-green-300');
                                            ?>
                                            <div class="<?php echo e($progressColor); ?> h-full rounded-full transition-all duration-500" style="width: <?php echo e(min($percentage, 100)); ?>%"></div>
                                        </div>
                                    </div>
                                    <div class="text-white/90 text-xs font-medium">
                                        <?php echo e(number_format($percentage, 0)); ?>%
                                    </div>
                                </div>
                            <?php else: ?>
                                <span class="inline-flex items-center rounded-full bg-white/20 px-2 py-0.5 text-xs font-semibold text-white mt-1">
                                    <svg class="h-3 w-3 mr-1" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                                        <polyline points="20,6 9,17 4,12"/>
                                    </svg>
                                    <?php echo e(__('باقة غير محدودة')); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="flex items-center gap-2 flex-shrink-0">
                        <?php if(!$planLimits['feature_available']): ?>
                            <div class="text-white text-right hidden sm:block">
                                <div class="text-xs text-white/80"><?php echo e(__('غير متاحة')); ?></div>
                                <div class="font-medium text-sm"><?php echo e(__('قم بالترقية')); ?></div>
                            </div>
                            <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-1.5 whitespace-nowrap rounded-md text-sm font-medium bg-white text-purple-600 hover:bg-white/90 transition-all h-8 px-3 py-1.5 shadow-sm">
                                <?php echo e(__('ترقية')); ?>

                            </a>
                        <?php elseif($isFull): ?>
                            <div class="text-white text-right hidden sm:block">
                                <div class="text-xs text-white/80"><?php echo e(__('الحد الأقصى')); ?></div>
                                <div class="font-medium text-sm"><?php echo e(__('ترقية للمزيد')); ?></div>
                            </div>
                            <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-1.5 whitespace-nowrap rounded-md text-sm font-medium bg-white text-red-600 hover:bg-white/90 transition-all h-8 px-3 py-1.5 shadow-sm">
                                <?php echo e(__('ترقية')); ?>

                            </a>
                        <?php elseif($isLow): ?>
                            <div class="text-white text-right hidden sm:block">
                                <div class="text-xs text-white/80"><?php echo e(__('متبقي')); ?></div>
                                <div class="font-bold text-lg"><?php echo e($planLimits['remaining']); ?></div>
                            </div>
                            <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-1.5 whitespace-nowrap rounded-md text-sm font-medium bg-white/20 text-white hover:bg-white/30 transition-all h-8 px-3 py-1.5 border border-white/20">
                                <?php echo e(__('عرض الباقات')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 md:gap-5">
        
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 text-white flex flex-col gap-3 rounded-xl border shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex-1">
                    <div class="text-2xl font-bold mb-0.5"><?php echo e($stats['total']); ?></div> <div class="text-xs text-blue-100"><?php echo e(__('إجمالي الردود')); ?></div> </div>
                <div class="w-10 h-10 bg-white/20 rounded-md flex items-center justify-center"> <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                        <polyline points="9 10 4 15 9 20"/>
                        <path d="M20 4v7a4 4 0 0 1-4 4H4"/>
                    </svg>
                </div>
            </div>
            <div class="flex items-center gap-1 text-xs text-blue-100 pt-1 border-t border-white/20">
                <svg class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <polyline points="22,12 18,12 15,21 9,3 6,12 2,12"/>
                </svg>
                <span><?php echo e(__('جميع القواعد المضافة')); ?></span>
            </div>
        </div>

        <div class="bg-gradient-to-br from-green-500 to-green-600 text-white flex flex-col gap-3 rounded-xl border shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex-1">
                    <div class="text-2xl font-bold mb-0.5"><?php echo e($stats['active']); ?></div>
                    <div class="text-xs text-green-100"><?php echo e(__('نشط حالياً')); ?></div>
                </div>
                <div class="w-10 h-10 bg-white/20 rounded-md flex items-center justify-center">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                        <polygon points="5 3 19 12 5 21 5 3"/>
                    </svg>
                </div>
            </div>
            <div class="flex items-center gap-1 text-xs text-green-100 pt-1 border-t border-white/20">
                <div class="w-2 h-2 bg-green-300 rounded-full animate-pulse"></div>
                <span><?php echo e(__('قيد التشغيل')); ?></span>
            </div>
        </div>

        <div class="bg-gradient-to-br from-purple-500 to-purple-600 text-white flex flex-col gap-3 rounded-xl border shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex-1">
                    <div class="text-2xl font-bold mb-0.5"><?php echo e(number_format($stats['total_replies'])); ?></div>
                    <div class="text-xs text-purple-100"><?php echo e(__('ردود مُرسلة')); ?></div>
                </div>
                <div class="w-10 h-10 bg-white/20 rounded-md flex items-center justify-center">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                        <rect width="20" height="16" x="2" y="4" rx="2"/>
                        <path d="m22 7-10 5L2 7"/>
                    </svg>
                </div>
            </div>
            <div class="flex items-center gap-1 text-xs text-purple-100 pt-1 border-t border-white/20">
                <svg class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <polyline points="20,6 9,17 4,12"/>
                </svg>
                <span><?php echo e(__('إجمالي التفاعلات')); ?></span>
            </div>
        </div>

        <div class="bg-gradient-to-br from-cyan-500 to-cyan-600 text-white flex flex-col gap-3 rounded-xl border shadow-sm p-4">
            <div class="flex items-center justify-between">
                <div class="flex-1">
                    <div class="text-2xl font-bold mb-0.5"><?php echo e($stats['success_rate']); ?>%</div>
                    <div class="text-xs text-cyan-100"><?php echo e(__('معدل النجاح')); ?></div>
                </div>
                <div class="w-10 h-10 bg-white/20 rounded-md flex items-center justify-center">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                        <path d="M3 3v18h18"/>
                        <path d="m19 9-5 5-4-4-3 3"/>
                    </svg>
                </div>
            </div>
            <div class="flex items-center gap-1 text-xs text-cyan-100 pt-1 border-t border-white/20">
                <svg class="h-3 w-3" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" viewBox="0 0 24 24">
                    <polyline points="23,6 13.5,15.5 8.5,10.5 1,18"/>
                    <polyline points="17,6 23,6 23,12"/>
                </svg>
                <span><?php echo e(__('أداء ممتاز')); ?></span>
            </div>
        </div>
    </div>

<div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm mb-4">
    <div data-slot="card-content" class="px-4 py-3">
        <form method="GET" action="<?php echo e(route('auto-replies.index')); ?>" class="flex flex-col md:flex-row gap-3 md:items-center">

            <div class="relative flex-1 min-w-[150px]">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                    viewBox="0 0 24 24" fill="none" stroke="currentColor"
                    stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                    class="lucide lucide-search absolute right-3 top-1/2 transform -translate-y-1/2 text-muted-foreground h-3.5 w-3.5">
                    <circle cx="11" cy="11" r="8"></circle>
                    <path d="m21 21-4.3-4.3"></path>
                </svg>
                <input type="text" name="search"
                        value="<?php echo e(request('search')); ?>"
                        placeholder="ابحث في الردود..."
                        class="file:text-foreground placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground
                                dark:bg-input/30 border-input flex h-8 w-full min-w-0 rounded-md border bg-transparent px-3 py-1
                                text-sm shadow-xs transition-[color,box-shadow] outline-none pr-9
                                focus-visible:border-ring focus-visible:ring-ring/50 focus-visible:ring-[3px]" />
            </div>

            <select name="page_id"
                    class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30
                            flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 text-sm
                            shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring
                            focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full md:w-40 h-8 py-0">
                <option value="">جميع الصفحات</option>
                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($page->page_id); ?>" <?php echo e(request('page_id') == $page->page_id ? 'selected' : ''); ?>>
                        <?php echo e($page->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            <select name="status"
                    class="border-input data-[placeholder]:text-muted-foreground dark:bg-input/30
                            flex items-center justify-between gap-2 rounded-md border bg-transparent px-3 text-sm
                            shadow-xs transition-[color,box-shadow] outline-none focus-visible:border-ring
                            focus-visible:ring-ring/50 focus-visible:ring-[3px] w-full md:w-36 h-8 py-0">
                <option value="">جميع الحالات</option>
                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>نشط</option>
                <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>غير نشط</option>
                <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>>مُجدول</option>
            </select>

            <div class="flex gap-2 flex-shrink-0">
                <button type="submit"
                        class="inline-flex items-center justify-center gap-1.5 rounded-md border bg-background shadow-xs
                                hover:bg-accent hover:text-accent-foreground dark:bg-input/30 dark:border-input
                                dark:hover:bg-input/50 h-8 px-3 text-sm font-medium transition-all">
                    <i class="fas fa-search h-3.5 w-3.5"></i> بحث
                </button>
                <a href="<?php echo e(route('auto-replies.index')); ?>"
                   class="inline-flex items-center justify-center gap-1.5 rounded-md border bg-background shadow-xs
                            hover:bg-accent hover:text-accent-foreground dark:bg-input/30 dark:border-input
                            dark:hover:bg-input/50 h-8 px-3 text-sm font-medium transition-all">
                    <i class="fas fa-times h-3.5 w-3.5"></i> مسح
                </a>
            </div>
        </form>
    </div>
</div>

<div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border shadow-lg">
    <div data-slot="card-content" class="p-0">
        <div data-slot="table-container" class="relative w-full overflow-x-auto rounded-xl">
            <?php if($autoReplies->count() > 0): ?>
                <table data-slot="table" class="w-full caption-bottom text-sm rtl:text-right">
                    <thead data-slot="table-header" class="bg-gray-50 dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
                        <tr data-slot="table-row" class="hover:bg-gray-100/50 dark:hover:bg-gray-700/50 transition-colors">
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">الاسم</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">الصفحة</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">نوع التفعيل</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">الحالة</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">عدد الردود</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">معدل النجاح</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">آخر استخدام</th>
                            <th data-slot="table-head" class="px-4 py-3 text-right text-xs font-semibold uppercase tracking-wider text-gray-600 dark:text-gray-400">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody data-slot="table-body" class="divide-y divide-gray-200 dark:divide-gray-700">
                        <?php $__currentLoopData = $autoReplies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $autoReply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-slot="table-row" class="bg-white dark:bg-gray-900 hover:bg-gray-50/70 dark:hover:bg-gray-800/70 transition-colors">
                                <td data-slot="table-cell" class="p-4 align-top font-medium text-gray-900 dark:text-white">
                                    <div class="flex flex-col">
                                        <strong class="text-base font-semibold"><?php echo e($autoReply->name); ?></strong>
                                        <?php if($autoReply->description): ?>
                                            <small class="text-sm text-gray-500 dark:text-gray-400 mt-0.5"><?php echo e(Str::limit($autoReply->description, 50)); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-50 dark:bg-blue-900/50 text-blue-700 dark:text-blue-300">
                                        <?php echo e($autoReply->page->name ?? 'غير محدد'); ?>

                                    </span>
                                    <?php if($autoReply->post_id): ?>
                                        <div class="mt-1"><small class="text-xs text-gray-500 dark:text-gray-400">منشور محدد</small></div>
                                    <?php endif; ?>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top">
                                    <?php switch($autoReply->trigger_type):
                                        case ('all'): ?>
                                            <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-50 dark:bg-green-900/50 text-green-700 dark:text-green-300">جميع التعليقات</span>
                                            <?php break; ?>
                                        <?php case ('keywords'): ?>
                                            <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium bg-yellow-50 dark:bg-yellow-900/50 text-yellow-700 dark:text-yellow-300">كلمات مفتاحية</span>
                                            <?php break; ?>
                                        <?php case ('new_commenters'): ?>
                                            <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium bg-indigo-50 dark:bg-indigo-900/50 text-indigo-700 dark:text-indigo-300">معلقين جدد</span>
                                            <?php break; ?>
                                        <?php default: ?>
                                            <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-50 dark:bg-gray-700/50 text-gray-700 dark:text-gray-300"><?php echo e($autoReply->trigger_type); ?></span>
                                    <?php endswitch; ?>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top" title="انقر لتغير الحالة">
                                    <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium cursor-pointer status-toggle
                                        <?php echo e($autoReply->status === 'active' ? 'bg-green-100 dark:bg-green-800 text-green-800 dark:text-green-200' : ($autoReply->status === 'scheduled' ? 'bg-yellow-100 dark:bg-yellow-800 text-yellow-800 dark:text-yellow-200' : 'bg-gray-100 dark:bg-gray-700 text-gray-800 dark:text-gray-300')); ?>"
                                        data-id="<?php echo e($autoReply->id); ?>">
                                        <?php echo e($autoReply->status === 'active' ? 'نشط' : ($autoReply->status === 'scheduled' ? 'مُجدول' : 'غير نشط')); ?>

                                    </span>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top text-gray-900 dark:text-white">
                                    <strong class="text-sm font-semibold"><?php echo e(number_format($autoReply->reply_count)); ?></strong>
                                    <?php if($autoReply->max_replies): ?>
                                        <small class="text-xs text-gray-500 dark:text-gray-400">/ <?php echo e(number_format($autoReply->max_replies)); ?></small>
                                    <?php endif; ?>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top">
                                    <?php $successRate = $autoReply->getSuccessRate(); ?>
                                    <span class="inline-flex px-2.5 py-0.5 rounded-full text-xs font-medium
                                        <?php echo e($successRate >= 80 ? 'bg-green-100 dark:bg-green-800 text-green-800 dark:text-green-200' : ($successRate >= 60 ? 'bg-yellow-100 dark:bg-yellow-800 text-yellow-800 dark:text-yellow-200' : 'bg-red-100 dark:bg-red-800 text-red-800 dark:text-red-200')); ?>">
                                        <?php echo e($successRate); ?>%
                                    </span>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top text-gray-600 dark:text-gray-400">
                                    <?php if($autoReply->last_used_at): ?>
                                        <small title="<?php echo e($autoReply->last_used_at->format('Y-m-d H:i:s')); ?>" class="text-xs">
                                            <?php echo e($autoReply->last_used_at->diffForHumans()); ?>

                                        </small>
                                    <?php else: ?>
                                        <small class="text-xs text-gray-500 dark:text-gray-500">لم يُستخدم بعد</small>
                                    <?php endif; ?>
                                </td>

                                <td data-slot="table-cell" class="p-4 align-top">
                                    <div class="flex gap-1 justify-end">
                                        <a href="<?php echo e(route('auto-replies.show', $autoReply)); ?>" class="p-2 text-gray-500 dark:text-gray-400 hover:text-blue-600 dark:hover:text-blue-400 rounded-full transition-colors" title="عرض">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-eye"><path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"></path><circle cx="12" cy="12" r="3"></circle></svg>
                                        </a>
                                        <a href="<?php echo e(route('auto-replies.edit', $autoReply)); ?>" class="p-2 text-gray-500 dark:text-gray-400 hover:text-yellow-600 dark:hover:text-yellow-400 rounded-full transition-colors" title="تعديل">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polygon points="14 2 18 6 7 17 3 17 3 13 14 2"></polygon><line x1="3" y1="22" x2="21" y2="22"></line></svg>
                                        </a>
                                        <a href="<?php echo e(route('auto-replies.duplicate', $autoReply)); ?>" class="p-2 text-gray-500 dark:text-gray-400 hover:text-indigo-600 dark:hover:text-indigo-400 rounded-full transition-colors" title="نسخ">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2"></path><rect x="8" y="2" width="8" height="4" rx="1" ry="1"></rect></svg>
                                        </a>
                                        <button type="button" class="p-2 text-gray-500 dark:text-gray-400 hover:text-red-600 dark:hover:text-red-400 rounded-full transition-colors delete-btn" data-id="<?php echo e($autoReply->id); ?>" title="حذف">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div data-slot="table-footer" class="p-4 border-t border-gray-200 dark:border-gray-700">
                    <div class="flex justify-center">
                        <?php echo e($autoReplies->appends(request()->query())->links()); ?>

                    </div>
                </div>
            <?php else: ?>
                <div class="text-center py-10 bg-white dark:bg-gray-900 rounded-xl">
                    <i class="fas fa-robot fa-3x text-gray-400 dark:text-gray-600 mb-4"></i>
                    <h5 class="text-xl font-semibold text-gray-900 dark:text-white mb-2">لا توجد ردود تلقائية</h5>
                    <p class="text-gray-500 dark:text-gray-400 mb-4">
                        <?php if(request()->hasAny(['search', 'page_id', 'status'])): ?>
                            لا توجد نتائج تطابق البحث الحالي
                            <br>
                            <a href="<?php echo e(route('auto-replies.index')); ?>" class="inline-block mt-2 text-blue-600 dark:text-blue-400 hover:underline">
                                مسح الفلاتر
                            </a>
                        <?php else: ?>
                            ابدأ بإنشاء أول رد تلقائي لك
                        <?php endif; ?>
                    </p>
                    <?php if(!request()->hasAny(['search', 'page_id', 'status'])): ?>
                        <a href="<?php echo e(route('auto-replies.create')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-lg text-sm font-medium transition-all disabled:pointer-events-none disabled:opacity-50 h-10 px-4 py-2 bg-blue-600 text-white shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-900">
                            <i class="fas fa-plus me-1"></i> إضافة رد جديد
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

</div>

  



<script>
document.addEventListener("DOMContentLoaded", function () {
    // ✅ Toggle Status
    document.querySelectorAll(".status-toggle").forEach(badge => {
        badge.addEventListener("click", function () {
            const id = this.dataset.id;
            const originalText = this.textContent.trim();
            const originalClass = this.className;

            // Loading state
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
            this.className = "badge bg-secondary";

            fetch(`/auto-replies/${id}/toggle`, {
                method: "POST",
                headers: {
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content,
                    "Accept": "application/json"
                }
            })
                .then(res => res.json())
                .then(response => {
                    if (response.success) {
                        this.classList.remove("bg-success", "bg-secondary", "bg-warning");
                        this.classList.add(response.status === "active" ? "bg-success" : "bg-secondary");
                        this.textContent = response.status === "active" ? "نشط" : "غير نشط";

                        showAlert("success", response.message);
                    } else {
                        this.textContent = originalText;
                        this.className = originalClass;
                        showAlert("error", "حدث خطأ أثناء تغيير الحالة");
                    }
                })
                .catch(() => {
                    this.textContent = originalText;
                    this.className = originalClass;
                    showAlert("error", "حدث خطأ أثناء تغيير الحالة");
                });
        });
    });

    // ✅ Delete Auto Reply
    document.querySelectorAll(".delete-btn").forEach(btn => {
        btn.addEventListener("click", function () {
            const id = this.dataset.id;

            if (confirm("هل أنت متأكد من حذف هذا الرد التلقائي؟\nسيتم حذف جميع البيانات المرتبطة به نهائياً.")) {
                const form = document.createElement("form");
                form.method = "POST";
                form.action = `/auto-replies/${id}`;

                form.innerHTML = `
                    <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').content}">
                    <input type="hidden" name="_method" value="DELETE">
                `;

                document.body.appendChild(form);
                form.submit();
            }
        });
    });

    // ✅ Show Bootstrap Alert
    function showAlert(type, message) {
        const alertClass = type === "success" ? "alert-success" : "alert-danger";
        const icon = type === "success" ? "fa-check-circle" : "fa-exclamation-circle";

        const wrapper = document.createElement("div");
        wrapper.innerHTML = `
            <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
                <i class="fas ${icon} me-2"></i>${message}
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        `;

        const container = document.querySelector(".container-fluid");
        if (container) {
            container.prepend(wrapper.firstElementChild);

            // Auto dismiss after 3s
            setTimeout(() => {
                const alert = container.querySelector(".alert");
                if (alert) alert.style.display = "none";
            }, 3000);

            // Scroll to top
            window.scrollTo({ top: 0, behavior: "smooth" });
        }
    }
});
</script>



 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/auto-replies/index.blade.php ENDPATH**/ ?>