<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> <?php echo e(__('messages.users_manager')); ?> <?php $__env->endSlot(); ?>
<div class="p-6 space-y-6">
<div data-slot="card" class="bg-card text-card-foreground flex flex-col gap-6 rounded-xl border shadow-sm w-full">
    <div data-slot="card-header" class="grid grid-rows-[auto_auto] items-start gap-2 px-6 pb-4 border-b">
        <div class="text-2xl font-bold text-foreground flex items-center gap-3">
            <span class="w-9 h-9 bg-gradient-to-r from-blue-500 to-green-600 rounded-lg flex items-center justify-center">
                <svg width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><circle cx="9" cy="7" r="4"/><path d="M16 21v-2A4 4 0 0 0 12 15H6a4 4 0 0 0-4 4v2"/><polyline points="16 11 18 13 22 9"/></svg>
            </span>
            <?php echo e(__('messages.users_manager')); ?>

        </div>
    </div>
    <div class="px-6 space-y-4">
        <div class="flex flex-col sm:flex-row gap-4 items-start sm:items-center justify-between">
            <form method="GET" class="flex flex-col sm:flex-row gap-2 flex-1 w-full">
                <div class="flex items-center relative max-w-sm w-full">
                    <svg class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><circle cx="11" cy="11" r="8"/><path d="m21 21-4.3-4.3"/></svg>
                    <input class="flex h-9 w-full rounded-md border border-input bg-background px-3 py-1 text-base shadow-xs pr-10 placeholder:text-muted-foreground selection:bg-primary selection:text-primary-foreground focus:outline-none focus:ring-1 focus:ring-ring"
                     placeholder="البحث بالاسم أو البريد الإلكتروني..." name="search" value="<?php echo e(request('search')); ?>">
                </div>
                <div class="flex max-w-xs w-full">
                    <select name="role" class="rounded-md border bg-background px-3 py-2 text-sm w-full sm:w-40 focus:outline-none focus:ring-1 focus:ring-primary">
                        <option value="">جميع الأدوار</option>
                        <option value="admin" <?php if(request('role')=='admin'): echo 'selected'; endif; ?>>أدمن</option>
                        <option value="user" <?php if(request('role')=='user'): echo 'selected'; endif; ?>>مستخدم</option>
                    </select>
                    <button class="ml-2 rounded-md bg-slate-500 text-white px-4 py-2 shadow-xs hover:bg-slate-700 transition-all" type="submit">بحث</button>
                </div>
            </form>
            <a href="<?php echo e(route('admin.users.create')); ?>" class="rounded-md bg-primary text-primary-foreground shadow-xs hover:bg-primary/90 px-4 py-2 mt-2 flex items-center gap-2">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M5 12h14"/><path d="M12 5v14"/></svg>
                إضافة مستخدم
            </a>
        </div>
        <div class="rounded-md border overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="h-10 px-2 font-semibold text-right">#</th>
                            <th class="h-10 px-2 font-semibold text-right">الاسم</th>
                            <th class="h-10 px-2 font-semibold text-right">البريد</th>
                            <th class="h-10 px-2 font-semibold text-right">الدور</th>
                            <th class="h-10 px-2 font-semibold text-right">الباقة</th>
                            <th class="h-10 px-2 font-semibold text-right">تاريخ انتهاء الوصول</th>
                            <th class="h-10 px-2 font-semibold text-right">أنشئ في</th>
                            <th class="h-10 px-2 font-semibold text-right">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="border-b hover:bg-accent/50 transition-colors">
                            <td class="p-2 font-medium"><?php echo e($user->id); ?></td>
                            <td class="p-2 font-medium"><?php echo e($user->name); ?></td>
                            <td class="p-2 text-gray-600"><?php echo e($user->email); ?></td>
                            <td class="p-2">
                                <span class="inline-flex items-center rounded px-2 py-0.5 text-xs font-medium
                                    <?php echo e($user->role === 'admin' ? 'bg-red-600 text-white' : 'bg-green-100 text-green-800'); ?>">
                                    <?php echo e($user->role === 'admin' ? 'أدمن' : 'مستخدم'); ?>

                                </span>
                            </td>
                            <td class="p-2">
                                <span class="inline-flex items-center rounded-md px-2 py-0.5 text-xs font-medium bg-blue-50 text-blue-700 border border-blue-100">
                                   <?php echo e($user->plan ? $user->plan->title : 'لا '); ?>


                                </span>
                            </td>
                            <td class="p-2 text-gray-600">
                                <div class="flex items-center gap-1">
                                    <svg width="16" height="16" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2" class="h-4 w-4"><rect width="18" height="18" x="3" y="4" rx="2"/><path d="M8 2v4"/><path d="M16 2v4"/><path d="M3 10h18"/></svg>
                                    <?php echo e($user->access_expires_at ? $user->access_expires_at->format('Y-m-d') : '-'); ?>

                                </div>
                            </td>
                            <td class="p-2 text-gray-600"><?php echo e($user->created_at->format('Y-m-d')); ?></td>
                            <td class="p-2">
                                <div class="flex gap-1">
                                    <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="inline-flex items-center rounded-md text-xs font-medium px-2 py-1 bg-yellow-400 hover:bg-yellow-500 text-black transition-all">تعديل</a>
                                    <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST" style="display:inline-block" onsubmit="return confirm('تأكيد الحذف؟');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="inline-flex items-center rounded-md text-xs font-medium px-2 py-1 bg-red-500 hover:bg-red-600 text-white transition-all">حذف</button>
                                    </form>
                                    <?php if(auth()->id() !== $user->id && $user->role === 'user'): ?>
                                    <form action="<?php echo e(route('admin.users.impersonate', $user)); ?>" method="POST" style="display:inline-block">
                                        <?php echo csrf_field(); ?>
                                        <button class="inline-flex items-center rounded-md text-xs font-medium px-2 py-1 bg-blue-500 hover:bg-blue-600 text-white transition-all">دخول كمستخدم</button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="p-6 text-center text-gray-500">لا يوجد مستخدمون</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="pt-4">
            <?php echo e($users->links()); ?>

        </div>
    </div>
</div>
</div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/admin/users/index.blade.php ENDPATH**/ ?>