<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('title', null, []); ?> لوحة التحكم <?php $__env->endSlot(); ?>

    <div class="p-4 sm:p-6 space-y-6 overflow-x-hidden">
        <!-- رأس الصفحة -->
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div class="w-full sm:w-auto">
                <h1 class="text-2xl sm:text-3xl font-bold text-foreground flex items-center gap-2">
                    <div class="w-8 h-8 bg-gradient-to-r from-blue-600 to-purple-600 rounded-lg flex items-center justify-center flex-shrink-0">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-white">
                            <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                            <line x1="16" y1="2" x2="16" y2="6"/>
                            <line x1="8" y1="2" x2="8" y2="6"/>
                            <line x1="3" y1="10" x2="21" y2="10"/>
                        </svg>
                    </div>
                    مرحباً <?php echo e(auth()->user()->name); ?>

                </h1>
                <p class="text-muted-foreground text-sm sm:text-base mt-1">نظرة شاملة على أداء حساباتك على فيسبوك وإنستقرام</p>
            </div>
            
            <div class="flex flex-col sm:flex-row items-start sm:items-center gap-3 w-full sm:w-auto">
                <!-- الوقت الحالي -->
                <div class="flex items-center gap-2 text-sm text-muted-foreground border rounded-lg px-3 py-2 w-full sm:w-auto justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <circle cx="12" cy="12" r="10"/>
                        <polyline points="12 6 12 12 16 14"/>
                    </svg>
                    <span id="current-time">--:--</span>
                </div>

                <!-- محدد الفترة الزمنية -->
                <div class="flex items-center bg-muted rounded-lg p-1 w-full sm:w-auto justify-center">
                    <input type="radio" id="period7" name="period" value="7" class="sr-only period-radio" checked>
                    <label for="period7" class="period-btn px-3 py-1.5 text-sm font-medium rounded-md cursor-pointer transition-all whitespace-nowrap">7 أيام</label>
                    
                    <input type="radio" id="period30" name="period" value="30" class="sr-only period-radio">
                    <label for="period30" class="period-btn px-3 py-1.5 text-sm font-medium rounded-md cursor-pointer transition-all whitespace-nowrap">30 يوم</label>
                    
                    <input type="radio" id="period90" name="period" value="90" class="sr-only period-radio">
                    <label for="period90" class="period-btn px-3 py-1.5 text-sm font-medium rounded-md cursor-pointer transition-all whitespace-nowrap">90 يوم</label>
                </div>
                
                <button id="refreshBtn" class="inline-flex items-center justify-center gap-2 rounded-md border bg-background shadow-xs hover:bg-accent hover:text-accent-foreground h-9 px-4 py-2 text-sm font-medium transition-all w-full sm:w-auto">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="refresh-icon">
                        <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                        <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                        <path d="M8 12l5 5L22 8"/>
                    </svg>
                    تحديث
                </button>
            </div>
        </div>

      <!-- عرض الاستخدام الحالي للباقة النشطة - تصميم محسّن مع SVG -->
<?php if(auth()->user()->plan): ?>
    <?php
        $user = auth()->user();
        $currentPlan = $user->plan;
        $daysRemaining = $user->access_expires_at ? now()->diffInDays($user->access_expires_at, false) : 0;
        $isExpired = $daysRemaining < 0;
        $isExpiringSoon = $daysRemaining >= 0 && $daysRemaining <= 7;
        
        // حساب معدل الاستجابة
        $totalComments = ($facebookStats['total_comments'] ?? 0) + ($instagramStats['total_comments'] ?? 0);
        $totalReplied = ($facebookStats['replied_comments'] ?? 0) + ($instagramStats['replied_comments'] ?? 0);
        $overallReplyRate = $totalComments > 0 ? round(($totalReplied / $totalComments) * 100, 1) : 0;
        
        // بيانات الاستخدام المضغوطة مع SVG
        $quickUsage = [
           
            'instagram_accounts' => [
                'name' => 'حسابات IG',
                'svg' => '<rect x="2" y="2" width="20" height="20" rx="5" ry="5"/><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"/><line x1="17.5" y1="6.5" x2="17.51" y2="6.5"/>',
                'color' => 'pink',
                'current' => $user->getFeatureUsage('instagram_accounts'),
                'max' => $currentPlan->getFeatureLimit('instagram_accounts'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('instagram_accounts')
            ],
            'facebook_pages' => [
                'name' => 'صفحات FB',
                'svg' => '<path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/>',
                'color' => 'indigo',
                'current' => $user->getFeatureUsage('facebook_pages'),
                'max' => $currentPlan->getFeatureLimit('facebook_pages'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('facebook_pages')
            ],
            'facebook_auto_replies' => [
                'name' => 'ردود FB',
                'svg' => '<path d="M12 8V4H8"/><rect x="2" y="12" width="20" height="8" rx="2"/><path d="M6 12V8"/><path d="M18 12V8"/><path d="M10 12V8"/>',
                'color' => 'green',
                'current' => $user->getFeatureUsage('facebook_auto_replies'),
                'max' => $currentPlan->getFeatureLimit('facebook_auto_replies'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('facebook_auto_replies')
            ],
            'instagram_auto_replies' => [
                'name' => 'ردود IG',
                'svg' => '<path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/><path d="M8 10h.01"/><path d="M12 10h.01"/><path d="M16 10h.01"/>',
                'color' => 'purple',
                'current' => $user->getFeatureUsage('instagram_auto_replies'),
                'max' => $currentPlan->getFeatureLimit('instagram_auto_replies'),
                'unlimited' => $currentPlan->hasUnlimitedFeature('instagram_auto_replies')
            ]
        ];
        
        // فلترة المتاح فقط
        $quickUsage = array_filter($quickUsage, fn($d) => $d['max'] != 0);
        
        // حساب التحذيرات
        $reachedLimits = array_filter($quickUsage, fn($d) => !$d['unlimited'] && $d['current'] >= $d['max']);
    ?>

    <!-- تنبيه الباقة + الاستخدام السريع في صف واحد -->
    <div class="grid grid-cols-1 lg:grid-cols-12 gap-4 mb-6">
        
        <!-- تنبيه الباقة -->
        <div class="lg:col-span-<?php echo e(($isExpired || $isExpiringSoon) ? '5' : '4'); ?>">
            <?php if($isExpired): ?>
                <!-- باقة منتهية -->
                <div class="bg-gradient-to-r from-red-50 to-red-100 border-2 border-red-300 rounded-xl p-4 h-full flex flex-col justify-between shadow-sm">
                    <div class="flex items-start gap-3">
                        <div class="w-10 h-10 bg-red-200 rounded-lg flex items-center justify-center flex-shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-red-700">
                                <circle cx="12" cy="12" r="10"/>
                                <line x1="15" y1="9" x2="9" y2="15"/>
                                <line x1="9" y1="9" x2="15" y2="15"/>
                            </svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="font-bold text-red-900 text-base">⚠️ باقتك منتهية!</h3>
                            <p class="text-sm text-red-700 mt-1">انتهت منذ <?php echo e(abs($daysRemaining)); ?> يوم</p>
                        </div>
                    </div>
                    <a href="<?php echo e(route('plans.index')); ?>" class="mt-3 w-full bg-red-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-red-700 transition-colors text-center inline-flex items-center justify-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                            <path d="M21 3v5h-5"/>
                            <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                            <path d="M3 21v-5h5"/>
                        </svg>
                        جدد الآن
                    </a>
                </div>
                
            <?php elseif($isExpiringSoon): ?>
                <!-- باقة قريبة من الانتهاء -->
                <div class="bg-gradient-to-r from-yellow-50 to-orange-50 border-2 border-yellow-300 rounded-xl p-4 h-full flex flex-col justify-between shadow-sm">
                    <div class="flex items-start gap-3">
                        <div class="w-10 h-10 bg-yellow-200 rounded-lg flex items-center justify-center flex-shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-700">
                                <circle cx="12" cy="12" r="10"/>
                                <polyline points="12 6 12 12 16 14"/>
                            </svg>
                        </div>
                        <div class="flex-1">
                            <h3 class="font-bold text-yellow-900 text-base">⏰ تنتهي قريباً!</h3>
                            <p class="text-sm text-yellow-700 mt-1">متبقي <?php echo e($daysRemaining); ?> <?php echo e($daysRemaining == 1 ? 'يوم' : 'أيام'); ?></p>
                        </div>
                    </div>
                    <a href="<?php echo e(route('plans.index')); ?>" class="mt-3 w-full bg-yellow-600 text-white px-4 py-2 rounded-lg text-sm font-medium hover:bg-yellow-700 transition-colors text-center inline-flex items-center justify-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"/>
                            <polyline points="12 6 12 12 16 14"/>
                        </svg>
                        مدد الآن
                    </a>
                </div>
                
            <?php else: ?>
                <!-- باقة نشطة - معلومات الباقة -->
                <div class="bg-gradient-to-r from-blue-50 to-indigo-50 border border-blue-200 rounded-xl p-4 h-full">
                    <div class="flex items-center gap-3 mb-3">
                        <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div class="flex-1 min-w-0">
                            <h3 class="font-bold text-blue-900 text-sm truncate"><?php echo e($currentPlan->title); ?></h3>
                            <p class="text-xs text-blue-600">باقة نشطة</p>
                        </div>
                    </div>
                    
                    <?php if($user->access_expires_at): ?>
                        <div class="text-center py-2 bg-white/50 rounded-lg">
                            <div class="text-xs text-blue-700">تنتهي في</div>
                            <div class="text-sm font-bold text-blue-900"><?php echo e($user->access_expires_at->format('d M Y')); ?></div>
                            <div class="text-xs text-blue-600 mt-1"><?php echo e($daysRemaining); ?> يوم متبقي</div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- الاستخدام السريع (مضغوط مع SVG) -->
        <div class="lg:col-span-<?php echo e(($isExpired || $isExpiringSoon) ? '7' : '8'); ?>">
            <div class="bg-white border border-gray-200 rounded-xl p-4 h-full">
                <div class="flex items-center justify-between mb-3">
                    <h3 class="text-sm font-semibold text-gray-800">استخدام الباقة</h3>
                    <a href="<?php echo e(route('plans.index')); ?>" class="text-xs text-blue-600 hover:underline">عرض التفاصيل</a>
                </div>
                
                <div class="grid grid-cols-2 sm:grid-cols-<?php echo e(count($quickUsage) >= 4 ? '4' : count($quickUsage)); ?> gap-3">
                    <?php $__currentLoopData = $quickUsage; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $percentage = !$data['unlimited'] && $data['max'] > 0 ? ($data['current'] / $data['max']) * 100 : 0;
                        ?>
                        
                        <div class="text-center">
                            <div class="w-8 h-8  mx-auto mb-2 rounded-lg bg-<?php echo e($data['color']); ?>-100 flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-<?php echo e($data['color']); ?>-600">
                                    <?php echo $data['svg']; ?>

                                </svg>
                            </div>
                            <div class="text-xs text-gray-600 mb-1 truncate"><?php echo e($data['name']); ?></div>
                            <div class="text-lg font-bold text-gray-900">
                                <?php echo e($data['current']); ?><span class="text-sm text-gray-500">/<?php echo e($data['unlimited'] ? '∞' : $data['max']); ?></span>
                            </div>
                            <?php if(!$data['unlimited']): ?>
                                <div class="w-full bg-gray-200 rounded-full h-1.5 mt-1">
                                    <div class="h-1.5 rounded-full <?php echo e($percentage >= 100 ? 'bg-red-500' : ($percentage >= 80 ? 'bg-yellow-500' : 'bg-green-500')); ?>" 
                                         style="width: <?php echo e(min($percentage, 100)); ?>%"></div>
                                </div>
                            <?php else: ?>
                                <div class="text-xs text-green-600 font-medium">✓ غير محدود</div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                
                <?php if(count($reachedLimits) > 0): ?>
                    <div class="mt-3 px-3 py-2 bg-red-50 border border-red-200 rounded-lg flex items-center justify-between">
                        <span class="text-xs text-red-700 font-medium">⚠️ <?php echo e(count($reachedLimits)); ?> ميزة وصلت للحد الأقصى</span>
                        <a href="<?php echo e(route('plans.index')); ?>#plans" class="text-xs text-red-600 hover:underline font-medium">ترقية</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- الإحصائيات الرئيسية - صف واحد مضغوط مع SVG -->
<div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4">
    <!-- إجمالي المحتوى -->
    <div class="bg-white rounded-xl border shadow-sm p-4 hover:shadow-md transition-shadow">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-blue-100 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                    <polyline points="14 2 14 8 20 8"/>
                </svg>
            </div>
            <div class="flex-1 min-w-0">
                <div class="text-2xl font-bold text-gray-900"><?php echo e($stats['total_posts'] ?? 0); ?></div>
                <div class="text-xs text-gray-600">إجمالي المحتوى</div>
                <div class="text-xs text-green-600 font-medium">+<?php echo e($stats['posts_growth'] ?? 0); ?>%</div>
            </div>
        </div>
    </div>

    <!-- إجمالي التعليقات -->
    <div class="bg-white rounded-xl border shadow-sm p-4 hover:shadow-md transition-shadow">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-yellow-100 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-600">
                    <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                </svg>
            </div>
            <div class="flex-1 min-w-0">
                <div class="text-2xl font-bold text-gray-900"><?php echo e($stats['total_comments'] ?? 0); ?></div>
                <div class="text-xs text-gray-600">التعليقات</div>
                <div class="text-xs text-blue-600 font-medium"><?php echo e($stats['comments_today'] ?? 0); ?> اليوم</div>
            </div>
        </div>
    </div>

    <!-- ردود اليوم -->
    <div class="bg-white rounded-xl border shadow-sm p-4 hover:shadow-md transition-shadow">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-green-100 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                    <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/>
                </svg>
            </div>
            <div class="flex-1 min-w-0">
                <div class="text-2xl font-bold text-gray-900"><?php echo e($stats['replies_today'] ?? 0); ?></div>
                <div class="text-xs text-gray-600">ردود اليوم</div>
                <div class="text-xs text-purple-600 font-medium"><?php echo e($stats['auto_replies_active'] ?? 0); ?> تلقائي</div>
            </div>
        </div>
    </div>

    <!-- معدل الاستجابة -->
    <div class="bg-white rounded-xl border shadow-sm p-4 hover:shadow-md transition-shadow">
        <div class="flex items-center gap-3">
            <div class="w-10 h-10 bg-purple-100 rounded-lg flex items-center justify-center flex-shrink-0">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                    <path d="M3 3v18h18"/>
                    <path d="M7 12l3 3 4-6 4 4"/>
                </svg>
            </div>
            <div class="flex-1 min-w-0">
                <div class="text-2xl font-bold text-gray-900"><?php echo e($overallReplyRate); ?>%</div>
                <div class="text-xs text-gray-600">معدل الاستجابة</div>
                <div class="text-xs <?php echo e($overallReplyRate >= 80 ? 'text-green-600' : ($overallReplyRate >= 60 ? 'text-yellow-600' : 'text-red-600')); ?> font-medium">
                    <?php echo e($overallReplyRate >= 80 ? 'ممتاز ✓' : ($overallReplyRate >= 60 ? 'جيد' : 'يحتاج تحسين')); ?>

                </div>
            </div>
        </div>
    </div>
</div>


        <!-- إحصائيات المنصات -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
            <!-- إحصائيات فيسبوك -->
            <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border bg-blue-600 text-white rounded-t-xl">
                    <div class="flex items-center gap-3">
                        <div class="w-8 h-8 sm:w-10 sm:h-10 bg-white/20 rounded-lg flex items-center justify-center flex-shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M18 2h-3a5 5 0 0 0-5 5v3H7v4h3v8h4v-8h3l1-4h-4V7a1 1 0 0 1 1-1h3z"/>
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <h3 class="font-semibold text-base sm:text-lg truncate">فيسبوك</h3>
                            <p class="text-blue-100 text-xs sm:text-sm truncate">إحصائيات الصفحات والتفاعل</p>
                        </div>
                    </div>
                </div>

                <div data-slot="card-content" class="p-4 sm:p-6">
                    <div class="grid grid-cols-2 gap-3 sm:gap-4 mb-4 sm:mb-6">
                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-blue-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                                    <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                    <circle cx="12" cy="5" r="1"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold"><?php echo e($facebookStats['pages_count'] ?? 0); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">صفحات</div>
                            </div>
                        </div>

                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-green-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold truncate"><?php echo e(number_format($facebookStats['total_followers'] ?? 0)); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">متابعين</div>
                            </div>
                        </div>

                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-red-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-red-600">
                                    <path d="M19 14c1.49-1.46 3-3.21 3-5.5A5.5 5.5 0 0 0 16.5 3c-1.76 0-3 .5-4.5 2-1.5-1.5-2.74-2-4.5-2A5.5 5.5 0 0 0 2 8.5c0 2.29 1.51 4.04 3 5.5Z"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold truncate"><?php echo e(number_format($facebookStats['total_comments'] ?? 0)); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">التعليقات</div>
                            </div>
                        </div>

                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-cyan-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-cyan-600">
                                    <path d="M12 2a2 2 0 0 1 2 2c0 .74-.4 1.39-1 1.73V7h4a2 2 0 0 1 2 2v1.28c.6-.35 1-.99 1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V22a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V10.28c-.6-.35-1-.99-1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V11h4V9.27c-.6-.34-1-.99-1-1.73a2 2 0 0 1 4 0z"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold"><?php echo e($facebookStats['active_auto_replies'] ?? 0); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">ردود تلقائية</div>
                            </div>
                        </div>
                    </div>

                    <div class="border-t border-border pt-3 sm:pt-4">
                        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-2 mb-2">
                            <div class="text-sm">
                                <span class="text-muted-foreground">معدل الرد:</span>
                                <span class="font-bold text-green-600 mr-1"><?php echo e($facebookStats['reply_rate'] ?? 85); ?>%</span>
                            </div>
                            <div class="text-sm">
                                <span class="text-muted-foreground">تعليقات اليوم:</span>
                                <span class="font-bold mr-1"><?php echo e($facebookStats['comments_today'] ?? 0); ?></span>
                            </div>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-green-500 h-2 rounded-full" style="width: <?php echo e($facebookStats['reply_rate'] ?? 75); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- إحصائيات إنستقرام -->
            <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border bg-gradient-to-r from-purple-600 via-pink-600 to-orange-500 text-white rounded-t-xl">
                    <div class="flex items-center gap-3">
                        <div class="w-8 h-8 sm:w-10 sm:h-10 bg-white/20 rounded-lg flex items-center justify-center flex-shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect width="20" height="20" x="2" y="2" rx="5" ry="5"/>
                                <path d="m13.5 8.5 2-2"/>
                                <path d="m7.5 15.5 2-2"/>
                                <circle cx="9" cy="9" r="2"/>
                                <path d="m13.5 15.5 2 2"/>
                            </svg>
                        </div>
                        <div class="min-w-0">
                            <h3 class="font-semibold text-base sm:text-lg truncate">إنستقرام</h3>
                            <p class="text-white/80 text-xs sm:text-sm truncate">إحصائيات الحسابات والمحتوى</p>
                        </div>
                    </div>
                </div>

                <div data-slot="card-content" class="p-4 sm:p-6">
                    <div class="grid grid-cols-2 gap-3 sm:gap-4 mb-4 sm:mb-6">
                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-purple-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                                    <circle cx="12" cy="12" r="3"/>
                                    <path d="M12 1v6m0 6v6"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold"><?php echo e($instagramStats['accounts_count'] ?? 0); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">حسابات</div>
                            </div>
                        </div>

                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-green-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold truncate"><?php echo e(number_format($instagramStats['total_followers'] ?? 0)); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">متابعين</div>
                            </div>
                        </div>

                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-yellow-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-600">
                                    <rect width="18" height="18" x="3" y="3" rx="2" ry="2"/>
                                    <circle cx="9" cy="9" r="2"/>
                                    <path d="m21 15-3.086-3.086a2 2 0 0 0-2.828 0L6 21"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold"><?php echo e($instagramStats['published_posts'] ?? 0); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">محتوى منشور</div>
                            </div>
                        </div>

                        <div class="flex items-center gap-2 sm:gap-3">
                            <div class="w-8 h-8 sm:w-10 sm:h-10 bg-red-50 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-red-600">
                                    <path d="M19 14c1.49-1.46 3-3.21 3-5.5A5.5 5.5 0 0 0 16.5 3c-1.76 0-3 .5-4.5 2-1.5-1.5-2.74-2-4.5-2A5.5 5.5 0 0 0 2 8.5c0 2.29 1.51 4.04 3 5.5Z"/>
                                </svg>
                            </div>
                            <div class="min-w-0">
                                <div class="text-lg sm:text-xl font-bold truncate"><?php echo e(number_format($instagramStats['total_likes'] ?? 0)); ?></div>
                                <div class="text-xs sm:text-sm text-muted-foreground">إعجابات</div>
                            </div>
                        </div>
                    </div>

                    <div class="border-t border-border pt-3 sm:pt-4">
                        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-2 mb-2">
                            <div class="text-sm">
                                <span class="text-muted-foreground">معدل الرد:</span>
                                <span class="font-bold text-green-600 mr-1"><?php echo e($instagramStats['reply_rate'] ?? 78); ?>%</span>
                            </div>
                            <div class="text-sm">
                                <span class="text-muted-foreground">مجدول:</span>
                                <span class="font-bold text-orange-600 mr-1"><?php echo e($instagramStats['scheduled_posts'] ?? 0); ?></span>
                            </div>
                        </div>
                        <div class="w-full bg-gray-200 rounded-full h-2">
                            <div class="bg-gradient-to-r from-purple-500 to-pink-500 h-2 rounded-full" style="width: <?php echo e($instagramStats['reply_rate'] ?? 78); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- الرسوم البيانية والتحليلات -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
            <!-- رسم بياني للأداء -->
            <div class="lg:col-span-2">
                <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                    <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
                        <h3 class="font-semibold text-lg flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary">
                                <path d="M3 3v18h18"/>
                                <path d="m19 9-5 5-4-4-3 3"/>
                            </svg>
                            أداء المحتوى والتفاعل
                        </h3>
                        
                        <div class="flex items-center bg-muted rounded-lg p-1 w-full sm:w-auto justify-center">
                            <input type="radio" id="chart-posts" name="chartType" value="posts" class="sr-only chart-radio" checked>
                            <label for="chart-posts" class="chart-btn px-3 py-1 text-xs font-medium rounded cursor-pointer transition-all whitespace-nowrap">المحتوى</label>
                            
                            <input type="radio" id="chart-comments" name="chartType" value="comments" class="sr-only chart-radio">
                            <label for="chart-comments" class="chart-btn px-3 py-1 text-xs font-medium rounded cursor-pointer transition-all whitespace-nowrap">التعليقات</label>
                            
                            <input type="radio" id="chart-replies" name="chartType" value="replies" class="sr-only chart-radio">
                            <label for="chart-replies" class="chart-btn px-3 py-1 text-xs font-medium rounded cursor-pointer transition-all whitespace-nowrap">الردود</label>
                        </div>
                    </div>

                    <div data-slot="card-content" class="p-4 sm:p-6">
                        <div class="h-64 sm:h-80">
                            <canvas id="performanceChart"></canvas>
                        </div>
                    </div>
                </div>
            </div>

            <!-- أفضل المحتوى -->
            <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border">
                    <h3 class="font-semibold text-lg flex items-center gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-600">
                            <path d="M6 9H4.5a2.5 2.5 0 0 1 0-5H6"/>
                            <path d="M18 9h1.5a2.5 2.5 0 0 0 0-5H18"/>
                            <path d="M4 22h16"/>
                            <path d="M10 14.66V17c0 .55.47.98.97 1.21C12.01 18.75 13 19.24 14 20"/>
                            <path d="M14 14.66V17c0 .55-.47.98-.97 1.21C12.99 18.75 12 19.24 10 20"/>
                            <path d="M18 2H6v7a6 6 0 0 0 12 0V2Z"/>
                        </svg>
                        أفضل المحتوى أداءً
                    </h3>
                </div>

                <div data-slot="card-content" class="p-4 sm:p-6 flex-1">
                    <div class="space-y-3 max-h-64 sm:max-h-72 overflow-y-auto">
                        <?php $__empty_1 = true; $__currentLoopData = $topPerforming['posts'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="flex items-center gap-3 p-3 rounded-lg hover:bg-accent transition-colors cursor-pointer">
                                <div class="w-8 h-8 sm:w-10 sm:h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-lg flex items-center justify-center text-white font-bold text-xs sm:text-sm flex-shrink-0">
                                    <?php echo e($loop->iteration); ?>

                                </div>
                                <div class="flex-1 min-w-0">
                                    <div class="text-sm font-medium text-foreground truncate"><?php echo e(Str::limit($post->caption ?? 'محتوى بدون عنوان', 35)); ?></div>
                                    <div class="text-xs text-muted-foreground flex items-center gap-2 sm:gap-3 mt-1">
                                        <span class="flex items-center gap-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-red-500">
                                                <path d="M19 14c1.49-1.46 3-3.21 3-5.5A5.5 5.5 0 0 0 16.5 3c-1.76 0-3 .5-4.5 2-1.5-1.5-2.74-2-4.5-2A5.5 5.5 0 0 0 2 8.5c0 2.29 1.51 4.04 3 5.5Z"/>
                                            </svg>
                                            <?php echo e(number_format($post->likes_count ?? 0)); ?>

                                        </span>
                                        <span class="flex items-center gap-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-500">
                                                <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                                            </svg>
                                            <?php echo e(number_format($post->comments_count ?? 0)); ?>

                                        </span>
                                    </div>
                                </div>
                                <button class="w-7 h-7 sm:w-8 sm:h-8 rounded-lg border hover:bg-accent flex items-center justify-center transition-colors flex-shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0"/>
                                        <circle cx="12" cy="12" r="3"/>
                                    </svg>
                                </button>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-center py-6 sm:py-8">
                                <div class="w-12 h-12 sm:w-16 sm:h-16 bg-muted rounded-full flex items-center justify-center mx-auto mb-3 sm:mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-muted-foreground">
                                        <path d="M3 3v18h18"/>
                                        <path d="m19 9-5 5-4-4-3 3"/>
                                    </svg>
                                </div>
                                <p class="text-sm text-muted-foreground">لا توجد إحصائيات بعد</p>
                                <p class="text-xs text-muted-foreground mt-1">ابدأ بنشر محتوى لرؤية التحليلات</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- الأنشطة الأخيرة -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
            <!-- قائمة الأنشطة -->
            <div class="lg:col-span-2">
                <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                    <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border">
                        <h3 class="font-semibold text-lg flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                                <path d="M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8"/>
                                <path d="M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16"/>
                                <path d="M8 12l5 5L22 8"/>
                            </svg>
                            الأنشطة الأخيرة
                        </h3>
                    </div>

                    <div data-slot="card-content" class="p-4 sm:p-6">
                        <div class="space-y-3 max-h-80 sm:max-h-96 overflow-y-auto">
                            <?php $__empty_1 = true; $__currentLoopData = $recentActivities ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="flex items-start gap-3 sm:gap-4 p-3 sm:p-4 rounded-lg hover:bg-accent transition-colors">
                                    <div class="w-8 h-8 sm:w-10 sm:h-10 bg-<?php echo e($activity['type'] === 'post' ? 'blue' : ($activity['type'] === 'comment' ? 'yellow' : 'green')); ?>-100 rounded-full flex items-center justify-center flex-shrink-0">
                                        <?php if($activity['type'] === 'post'): ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                                                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                                <polyline points="14 2 14 8 20 8"/>
                                            </svg>
                                        <?php elseif($activity['type'] === 'comment'): ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-yellow-600">
                                                <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                                            </svg>
                                        <?php else: ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-green-600">
                                                <circle cx="12" cy="12" r="3"/>
                                            </svg>
                                        <?php endif; ?>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <div class="font-medium text-foreground text-sm sm:text-base"><?php echo e($activity['title']); ?></div>
                                        <div class="text-xs sm:text-sm text-muted-foreground mt-1 flex items-center gap-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <circle cx="12" cy="12" r="10"/>
                                                <polyline points="12 6 12 12 16 14"/>
                                            </svg>
                                            <?php echo e($activity['time']->diffForHumans()); ?>

                                        </div>
                                    </div>
                                    <?php if(isset($activity['link'])): ?>
                                        <a href="<?php echo e($activity['link']); ?>" class="w-7 h-7 sm:w-8 sm:h-8 rounded-lg border hover:bg-accent flex items-center justify-center transition-colors flex-shrink-0">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M7 17 17 7"/>
                                                <path d="M17 7v10"/>
                                                <path d="M17 7H7"/>
                                            </svg>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center py-8 sm:py-12">
                                    <div class="w-12 h-12 sm:w-16 sm:h-16 bg-muted rounded-full flex items-center justify-center mx-auto mb-3 sm:mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-muted-foreground">
                                            <polyline points="22 12 18 12 15 21 9 3 6 12 2 12"/>
                                        </svg>
                                    </div>
                                    <p class="text-sm text-muted-foreground">لا توجد أنشطة حديثة</p>
                                    <p class="text-xs text-muted-foreground mt-1">ستظهر أنشطتك هنا عند بدء استخدام المنصة</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- معلومات سريعة وروابط -->
            <div class="space-y-4 sm:space-y-6">
                <!-- معلومات سريعة -->
                <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                    <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border">
                        <h3 class="font-semibold text-lg flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-blue-600">
                                <circle cx="12" cy="12" r="10"/>
                                <path d="m9 12 2 2 4-4"/>
                            </svg>
                            معلومات سريعة
                        </h3>
                    </div>

                    <div data-slot="card-content" class="p-4 sm:p-6 space-y-3 sm:space-y-4">
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-muted-foreground">إجمالي المنصات:</span>
                            <span class="font-bold"><?php echo e(($facebookStats['pages_count'] ?? 0) + ($instagramStats['accounts_count'] ?? 0)); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-muted-foreground">الردود التلقائية:</span>
                            <span class="font-bold text-primary"><?php echo e($stats['auto_replies'] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-muted-foreground">محتوى اليوم:</span>
                            <span class="font-bold text-green-600"><?php echo e($stats['posts_today'] ?? 0); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-sm text-muted-foreground">تعليقات اليوم:</span>
                            <span class="font-bold text-yellow-600"><?php echo e($stats['comments_today'] ?? 0); ?></span>
                        </div>
                        
                        <div class="border-t border-border pt-3 sm:pt-4">
                            <div class="text-center">
                                              <div class="text-sm text-muted-foreground mb-2">معدل الاستجابة الإجمالي</div>
                            <div class="text-xl sm:text-2xl font-bold <?php echo e($overallReplyRate >= 80 ? 'text-green-600' : ($overallReplyRate >= 60 ? 'text-yellow-600' : 'text-red-600')); ?> mb-2">
                                <?php echo e($overallReplyRate); ?>%
                            </div>
                            <div class="w-full bg-gray-200 rounded-full h-2">
                                <div class="bg-green-500 h-2 rounded-full transition-all duration-300" 
                                     style="width: <?php echo e($overallReplyRate); ?>%"></div>
                            </div>
                            <div class="text-xs text-muted-foreground mt-2">
                                <?php echo e($totalReplied); ?> ردود من <?php echo e($totalComments); ?> تعليق
                            </div>


                        </div>
                        </div>
                    </div>
                </div>

                <!-- روابط سريعة -->
                <div data-slot="card" class="bg-card text-card-foreground flex flex-col rounded-xl border shadow-sm">
                    <div data-slot="card-header" class="px-4 sm:px-6 py-4 border-b border-border">
                        <h3 class="font-semibold text-lg flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-purple-600">
                                <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6"/>
                                <polyline points="15,3 21,3 21,9"/>
                                <line x1="10" y1="14" x2="21" y2="3"/>
                            </svg>
                            إجراءات سريعة
                        </h3>
                    </div>

                    <div data-slot="card-content" class="p-4 sm:p-6 space-y-3">
                        <?php if(Route::has('instagram.posts.create')): ?>
                            <a href="<?php echo e(route('instagram.posts.create')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all text-primary-foreground shadow-xs h-9 px-4 py-2 bg-primary hover:bg-primary/90 w-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M5 12h14"/>
                                    <path d="m12 5 7 7-7 7"/>
                                </svg>
                                إنشاء محتوى جديد
                            </a>
                        <?php endif; ?>

                        <?php if(Route::has('instagram.comments.index')): ?>
                            <a href="<?php echo e(route('instagram.comments.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all text-primary-foreground shadow-xs h-9 px-4 py-2 bg-cyan-600 hover:bg-cyan-600/90 w-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z"/>
                                    <path d="M16 14a9 9 0 1 0-3.9 5.9L22 16Z"/>
                                </svg>
                                إدارة التعليقات
                            </a>
                        <?php endif; ?>

                        <?php if(Route::has('instagram.auto-replies.index')): ?>
                            <a href="<?php echo e(route('instagram.auto-replies.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all text-primary-foreground shadow-xs h-9 px-4 py-2 bg-green-600 hover:bg-green-600/90 w-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 2a2 2 0 0 1 2 2c0 .74-.4 1.39-1 1.73V7h4a2 2 0 0 1 2 2v1.28c.6-.35 1-.99 1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V22a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2V10.28c-.6-.35-1-.99-1-1.73a2 2 0 0 1 4 0c0 .74-.4 1.39-1 1.73V11h4V9.27c-.6-.34-1-.99-1-1.73a2 2 0 0 1 4 0z"/>
                                </svg>
                                الردود التلقائية
                            </a>
                        <?php endif; ?>

                        <?php if(Route::has('plans.index')): ?>
                            <a href="<?php echo e(route('plans.index')); ?>" class="inline-flex items-center justify-center gap-2 whitespace-nowrap rounded-md text-sm font-medium transition-all border border-input bg-background hover:bg-accent hover:text-accent-foreground shadow-xs h-9 px-4 py-2 w-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M12 2L2 7l10 5 10-5-10-5z"/>
                                </svg>
                                إدارة الباقة
                            </a>
                        <?php endif; ?>
                    </div>
                </div>

                
            </div>
        </div>
    </div>

 <!--  
 برمجة وتصميم عمر محمد
 https://wa.me/249100858093
 omar@rompure.com
 https://x.com/omar_m7a
 -->
 
   
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // تحديث الوقت الحالي
        function updateClock() {
            const now = new Date();
            const timeElement = document.getElementById('current-time');
            if (timeElement) {
                const hours = now.getHours().toString().padStart(2, '0');
                const minutes = now.getMinutes().toString().padStart(2, '0');
                timeElement.textContent = `${hours}:${minutes}`;
            }
        }
        updateClock();
        setInterval(updateClock, 60000);

        // معالجة أزرار الفترة
        function updatePeriodButtons(activeRadio) {
            document.querySelectorAll('.period-btn').forEach(btn => {
                btn.classList.remove('bg-primary', 'text-primary-foreground');
                btn.classList.add('text-muted-foreground');
            });
            if (activeRadio) {
                const btn = activeRadio.nextElementSibling;
                if (btn) {
                  btn.classList.add('bg-primary', 'text-primary-foreground');
                  btn.classList.remove('text-muted-foreground');
                }
            }
        }

        document.querySelectorAll('.period-radio').forEach(radio => {
            radio.addEventListener('change', function() {
                updatePeriodButtons(this);
                refreshData();
            });
        });

        const initiallyChecked = document.querySelector('.period-radio:checked');
        if (initiallyChecked) updatePeriodButtons(initiallyChecked);

        // ✅ بيانات الرسوم البيانية مع fallback
        let performanceData = <?php echo json_encode($performanceData, 15, 512) ?>;
        if (!performanceData) {
            performanceData = {
                labels: ['الاثنين','الثلاثاء','الأربعاء','الخميس','الجمعة','السبت','الأحد'],
                posts: [12,19,13,15,12,17,14],
                comments: [65,59,80,81,56,65,70],
                replies: [28,48,40,19,35,27,30]
            };
        }

        // إنشاء الرسم البياني
        let performanceChart = null;
        const perfCtx = document.getElementById('performanceChart');
        if (perfCtx) {
            performanceChart = new Chart(perfCtx.getContext('2d'), {
                type: 'line',
                data: {
                    labels: performanceData.labels,
                    datasets: [
                        { label: 'المحتوى', data: performanceData.posts, borderColor: 'rgb(59,130,246)', backgroundColor: 'rgba(59,130,246,0.1)', tension:0.4, fill:true },
                        { label: 'التعليقات', data: performanceData.comments, borderColor: 'rgb(251,191,36)', backgroundColor: 'rgba(251,191,36,0.1)', tension:0.4, fill:true },
                        { label: 'الردود', data: performanceData.replies, borderColor: 'rgb(34,197,94)', backgroundColor: 'rgba(34,197,94,0.1)', tension:0.4, fill:true }
                    ]
                },
                options: {
                    responsive:true, 
                    maintainAspectRatio:false,
                    interaction:{ mode:'index', intersect:false },
                    scales:{ 
                        y:{ 
                            beginAtZero:true, 
                            ticks:{ precision:0 } 
                        } 
                    },
                    plugins:{
                        legend:{ 
                            position:'top',
                            labels: {
                                boxWidth: 12,
                                font: {
                size: 16
                
            }
                            }
                        },
                        tooltip:{ 
                            backgroundColor:'rgba(0,0,0,0.8)', 
                            titleColor:'white', 
                            bodyColor:'white',
                            titleFont: {
                                size: 18
                            },
                            bodyFont: {
                                size: 18
                            }
                        }
                    }
                }
            });
        }

        // دالة تحديث البيانات
        window.refreshData = function() {
            const period = document.querySelector('input[name="period"]:checked')?.value || 7;
            const refreshBtn = document.getElementById('refreshBtn');
            const refreshIcon = refreshBtn.querySelector('.refresh-icon');
            
            // إضافة تأثير التحميل
            refreshIcon.classList.add('animate-spin');
            
            fetch(`/dashboard/analytics?period=${period}`, {
                headers:{ 
                    'X-Requested-With':'XMLHttpRequest',
                    'Accept':'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(r => r.json())
            .then(data => {
                if (data.performance && performanceChart) {
                    performanceChart.data.labels = data.performance.labels;
                    performanceChart.data.datasets[0].data = data.performance.posts;
                    performanceChart.data.datasets[1].data = data.performance.comments;
                    performanceChart.data.datasets[2].data = data.performance.replies;
                    performanceChart.update();
                }
            })
            .catch(err => console.error('Error:',err))
            .finally(() => {
                // إزالة تأثير التحميل
                refreshIcon.classList.remove('animate-spin');
            });
        };

        // إضافة حدث النقر على زر التحديث
        document.getElementById('refreshBtn').addEventListener('click', refreshData);

        setInterval(refreshData, 300000);
    });
    </script>

    <style>
    .animate-spin {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }

    .period-btn, .chart-btn {
        transition: all 0.3s ease;
    }

    .period-btn:hover, .chart-btn:hover {
        background-color: rgba(59, 130, 246, 0.1);
    }

    /* تحسينات للاستجابة على الشاشات الصغيرة */
    @media (max-width: 640px) {
        .text-3xl { font-size: 1.5rem; }
        .text-2xl { font-size: 1.25rem; }
        .text-xl { font-size: 1.125rem; }
        .text-lg { font-size: 1rem; }
    }
    </style>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/dashboard.blade.php ENDPATH**/ ?>