<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\AppLayout::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    
        <script src="https://kit.fontawesome.com/6130ba508c.js" crossorigin="anonymous"></script>
      <div class="p-4 space-y-4 md:space-y-5">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
               
        <div class="flex justify-between items-center">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight flex items-center gap-2">
                    <i class="fas fa-robot text-indigo-600"></i>
                    <?php echo e(__('Messenger Flow Builder')); ?>

                </h2>
                <p class="text-sm text-gray-500 mt-1">إدارة الشات بوت الذكي والردود التلقائية</p>
            </div>
            <div class="flex gap-2">
                <a href="<?php echo e(route('messenger-flows.templates')); ?>" 
                   class="px-4 py-2 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 transition-colors flex items-center gap-2">
                    <i class="fas fa-layer-group"></i>
                    <span>القوالب</span>
                </a>
                <a href="<?php echo e(route('messenger-flows.builder')); ?>" 
                   class="px-4 py-2 bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors flex items-center gap-2">
                    <i class="fas fa-plus"></i>
                    <span>إنشاء Flow جديد</span>
                </a>
            </div>
        </div>
    

   
            <?php if(session('success')): ?>
                <div class="mb-6 bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg flex items-center gap-2">
                    <i class="fas fa-check-circle"></i>
                    <span><?php echo e(session('success')); ?></span>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg flex items-center gap-2">
                    <i class="fas fa-exclamation-circle"></i>
                    <span><?php echo e(session('error')); ?></span>
                </div>
            <?php endif; ?>

            <?php if($flows->isEmpty()): ?>
                <!-- Empty State -->
                <div class="bg-white rounded-lg shadow-sm p-12 text-center">
                    <div class="max-w-md mx-auto">
                        <div class="w-24 h-24 bg-indigo-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-robot text-indigo-600 text-4xl"></i>
                        </div>
                        <h3 class="text-2xl font-semibold text-gray-900 mb-2">لا توجد Flows حتى الآن</h3>
                        <p class="text-gray-600 mb-6">
                            ابدأ بإنشاء أول Flow لتشغيل الشات بوت التلقائي والرد على رسائل العملاء بذكاء
                        </p>
                        
                        <div class="flex flex-col sm:flex-row gap-3 justify-center">
                            <a href="<?php echo e(route('messenger-flows.builder')); ?>" 
                               class="inline-flex items-center justify-center px-6 py-3 bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors">
                                <i class="fas fa-plus mr-2"></i>
                                إنشاء Flow من الصفر
                            </a>
                            <a href="<?php echo e(route('messenger-flows.templates')); ?>" 
                               class="inline-flex items-center justify-center px-6 py-3 bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                                <i class="fas fa-layer-group mr-2"></i>
                                تصفح القوالب الجاهزة
                            </a>
                        </div>

                        <div class="mt-8 pt-8 border-t border-gray-200">
                            <h4 class="text-sm font-semibold text-gray-700 mb-3">ماذا يمكنك فعله بـFlow Builder؟</h4>
                            <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 text-sm text-gray-600">
                                <div class="flex items-start gap-2">
                                    <i class="fas fa-check text-green-500 mt-1"></i>
                                    <span>إنشاء ردود تلقائية ذكية</span>
                                </div>
                                <div class="flex items-start gap-2">
                                    <i class="fas fa-check text-green-500 mt-1"></i>
                                    <span>إرسال صور وفيديوهات</span>
                                </div>
                                <div class="flex items-start gap-2">
                                    <i class="fas fa-check text-green-500 mt-1"></i>
                                    <span>إضافة أزرار تفاعلية</span>
                                </div>
                                <div class="flex items-start gap-2">
                                    <i class="fas fa-check text-green-500 mt-1"></i>
                                    <span>عرض منتجات بـCarousel</span>
                                </div>
                                <div class="flex items-start gap-2">
                                    <i class="fas fa-check text-green-500 mt-1"></i>
                                    <span>شروط منطقية متقدمة</span>
                                </div>
                                <div class="flex items-start gap-2">
                                    <i class="fas fa-check text-green-500 mt-1"></i>
                                    <span>تتبع إحصائيات التفاعل</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <!-- Filters & Search -->
                <div class="bg-white rounded-lg shadow-sm border mb-6 p-4">
                    <div class="flex flex-col md:flex-row gap-4 items-center justify-between">
                        <div class="flex-1 w-full md:w-auto">
                            <div class="relative">
                                <input type="text" 
                                       id="searchInput" 
                                       placeholder="ابحث عن Flow..." 
                                       class="w-full pl-10 pr-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                                       onkeyup="filterFlows()">
                                <i class="fas fa-search absolute left-3 top-3 text-gray-400"></i>
                            </div>
                        </div>

                        <div class="flex gap-2 w-full md:w-auto">
                            <select id="statusFilter" 
                                    class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500"
                                    onchange="filterFlows()">
                                <option value="all">جميع الحالات</option>
                                <option value="active">مفعّل فقط</option>
                                <option value="inactive">معطّل فقط</option>
                            </select>

                            <select id="sortBy" 
                                    class="px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-indigo-500"
                                    onchange="sortFlows()">
                                <option value="recent">الأحدث</option>
                                <option value="name">الاسم</option>
                                <option value="executions">الأكثر استخداماً</option>
                                <option value="priority">الأولوية</option>
                            </select>
                        </div>
                    </div>

                    <!-- Stats Summary -->
                    <div class="mt-4 pt-4 border-t border-gray-200 grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                        <div>
                            <div class="text-2xl font-bold text-gray-900"><?php echo e($flows->count()); ?></div>
                            <div class="text-xs text-gray-500">إجمالي Flows</div>
                        </div>
                        <div>
                            <div class="text-2xl font-bold text-green-600"><?php echo e($flows->where('is_active', true)->count()); ?></div>
                            <div class="text-xs text-gray-500">مفعّل</div>
                        </div>
                        <div>
                            <div class="text-2xl font-bold text-gray-600"><?php echo e($flows->where('is_active', false)->count()); ?></div>
                            <div class="text-xs text-gray-500">معطّل</div>
                        </div>
                        <div>
                            <div class="text-2xl font-bold text-indigo-600"><?php echo e($flows->sum('executions_count')); ?></div>
                            <div class="text-xs text-gray-500">إجمالي التنفيذات</div>
                        </div>
                    </div>
                </div>

                <!-- Flows Grid -->
                <div id="flowsGrid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <?php $__currentLoopData = $flows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flow-card bg-white rounded-lg shadow-sm border hover:shadow-md transition-all" 
                             data-name="<?php echo e(strtolower($flow->name)); ?>"
                             data-status="<?php echo e($flow->is_active ? 'active' : 'inactive'); ?>"
                             data-executions="<?php echo e($flow->executions_count); ?>"
                             data-priority="<?php echo e($flow->priority); ?>"
                             data-created="<?php echo e($flow->created_at->timestamp); ?>">
                            
                            <!-- Card Header -->
                            <div class="p-5 border-b border-gray-100">
                                <div class="flex items-start justify-between mb-3">
                                    <div class="flex-1 min-w-0">
                                        <h3 class="text-lg font-semibold text-gray-900 truncate mb-1">
                                            <?php echo e($flow->name); ?>

                                        </h3>
                                        <?php if($flow->description): ?>
                                            <p class="text-sm text-gray-500 line-clamp-2">
                                                <?php echo e($flow->description); ?>

                                            </p>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <!-- Status Badge -->
                                    <span class="ml-2 flex-shrink-0 px-2.5 py-1 text-xs font-medium rounded-full <?php echo e($flow->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                        <?php echo e($flow->is_active ? '🟢 مفعّل' : '⚪ معطّل'); ?>

                                    </span>
                                </div>

                                <!-- Priority Badge -->
                                <?php if($flow->priority > 0): ?>
                                    <div class="inline-flex items-center px-2 py-1 bg-yellow-50 text-yellow-700 rounded text-xs font-medium">
                                        <i class="fas fa-star text-yellow-500 mr-1"></i>
                                        أولوية: <?php echo e($flow->priority); ?>

                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- Card Body -->
                            <div class="p-5 space-y-3">
                                <!-- Facebook Page -->
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-facebook text-blue-600 w-5 flex-shrink-0"></i>
                                    <span class="truncate"><?php echo e($flow->facebookPage->name ?? 'غير محدد'); ?></span>
                                </div>
                                
                                <!-- Trigger Type -->
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-bolt w-5 flex-shrink-0"></i>
                                    <span>
                                        <?php if($flow->trigger_type === 'keyword'): ?>
                                            كلمات مفتاحية
                                            <?php if($flow->trigger_keywords): ?>
                                                <span class="text-xs text-gray-400">(<?php echo e(count($flow->trigger_keywords)); ?>)</span>
                                            <?php endif; ?>
                                        <?php elseif($flow->trigger_type === 'greeting'): ?>
                                            رسالة ترحيب
                                        <?php else: ?>
                                            <?php echo e(ucfirst($flow->trigger_type)); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                                
                                <!-- Execution Stats -->
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-chart-line w-5 flex-shrink-0"></i>
                                    <span>
                                        <span class="font-semibold text-indigo-600"><?php echo e($flow->executions_count); ?></span>
                                        تنفيذ
                                    </span>
                                </div>

                                <!-- Nodes Count -->
                                <div class="flex items-center text-sm text-gray-600">
                                    <i class="fas fa-project-diagram w-5 flex-shrink-0"></i>
                                    <span>
                                        <?php echo e(count($flow->flow_data['nodes'] ?? [])); ?> عقدة
                                    </span>
                                </div>

                                <!-- Created At -->
                                <div class="flex items-center text-xs text-gray-400">
                                    <i class="fas fa-clock w-5 flex-shrink-0"></i>
                                    <span><?php echo e($flow->created_at->diffForHumans()); ?></span>
                                </div>
                            </div>

                            <!-- Card Footer -->
                            <div class="p-4 bg-gray-50 border-t border-gray-100 rounded-b-lg">
                                <div class="flex gap-2">
                                    <!-- Edit Button -->
                                    <a href="<?php echo e(route('messenger-flows.builder', $flow->id)); ?>" 
                                       class="flex-1 px-3 py-2 text-center bg-primary text-white rounded-lg hover:bg-primary/90 transition-colors text-sm font-medium">
                                        <i class="fas fa-edit"></i>
                                        <span class="hidden sm:inline"> تعديل</span>
                                    </a>
                                    
                                    <!-- Toggle Button -->
                                    <button onclick="toggleFlow(<?php echo e($flow->id); ?>, this)" 
                                            class="px-3 py-2 border border-gray-300 rounded-lg hover:bg-gray-100 transition-colors text-sm"
                                            title="<?php echo e($flow->is_active ? 'تعطيل' : 'تفعيل'); ?>">
                                        <i class="fas fa-power-off <?php echo e($flow->is_active ? 'text-green-600' : 'text-gray-400'); ?>"></i>
                                    </button>
                                    
                                    <!-- More Options Dropdown -->
                                    <div class="relative">
                                        <button onclick="toggleDropdown(<?php echo e($flow->id); ?>)" 
                                                class="px-3 py-2 border border-gray-300 rounded-lg hover:bg-gray-100 transition-colors text-sm"
                                                id="dropdown-btn-<?php echo e($flow->id); ?>">
                                            <i class="fas fa-ellipsis-v"></i>
                                        </button>
                                        
                                        <!-- Dropdown Menu -->
                                        <div id="dropdown-<?php echo e($flow->id); ?>" 
                                             class="hidden absolute left-0 mt-2 w-48 bg-white rounded-lg shadow-lg border border-gray-200 z-10">
                                            <div class="py-1">
                                                <a href="<?php echo e(route('messenger-flows.statistics', $flow->id)); ?>" 
                                                   class="flex items-center gap-2 px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-chart-bar w-4"></i>
                                                    الإحصائيات
                                                </a>
                                                <button onclick="duplicateFlow(<?php echo e($flow->id); ?>)" 
                                                        class="w-full flex items-center gap-2 px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-copy w-4"></i>
                                                    نسخ
                                                </button>
                                                <a href="<?php echo e(route('messenger-flows.export', $flow->id)); ?>" 
                                                   class="flex items-center gap-2 px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                                                    <i class="fas fa-download w-4"></i>
                                                    تصدير
                                                </a>
                                                <div class="border-t border-gray-100"></div>
                                                <button onclick="deleteFlow(<?php echo e($flow->id); ?>)" 
                                                        class="w-full flex items-center gap-2 px-4 py-2 text-sm text-red-600 hover:bg-red-50">
                                                    <i class="fas fa-trash w-4"></i>
                                                    حذف
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Empty Search Result -->
                <div id="noResults" class="hidden bg-white rounded-lg shadow-sm p-12 text-center">
                    <i class="fas fa-search text-gray-300 text-5xl mb-4"></i>
                    <h3 class="text-lg font-semibold text-gray-700 mb-2">لا توجد نتائج</h3>
                    <p class="text-gray-500">جرب البحث بكلمات مختلفة أو غيّر الفلاتر</p>
                </div>

                <!-- Import Modal -->
                <div id="importModal" class="hidden fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-4">
                    <div class="bg-white rounded-xl max-w-md w-full shadow-2xl">
                        <div class="p-6 border-b flex items-center justify-between">
                            <h3 class="text-lg font-semibold">
                                <i class="fas fa-upload text-indigo-600 mr-2"></i>
                                استيراد Flow
                            </h3>
                            <button onclick="closeImportModal()" class="text-gray-400 hover:text-gray-600">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>

                        <form id="importForm" enctype="multipart/form-data" class="p-6">
                            <?php echo csrf_field(); ?>
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">
                                    ملف JSON
                                </label>
                                <div class="border-2 border-dashed border-gray-300 rounded-lg p-6 text-center hover:border-indigo-500 transition-colors cursor-pointer"
                                     onclick="document.getElementById('fileInput').click()">
                                    <i class="fas fa-cloud-upload-alt text-4xl text-gray-400 mb-2"></i>
                                    <p class="text-sm text-gray-600">اضغط لاختيار ملف أو اسحبه هنا</p>
                                    <p class="text-xs text-gray-400 mt-1">JSON فقط (حد أقصى 2MB)</p>
                                </div>
                                <input type="file" 
                                       id="fileInput" 
                                       name="file" 
                                       accept=".json" 
                                       class="hidden" 
                                       onchange="handleFileSelect(this)">
                                <div id="fileName" class="mt-2 text-sm text-gray-600"></div>
                            </div>

                            <div class="flex gap-2">
                                <button type="button" 
                                        onclick="closeImportModal()" 
                                        class="flex-1 px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50">
                                    إلغاء
                                </button>
                                <button type="submit" 
                                        class="flex-1 px-4 py-2 bg-primary text-white rounded-lg hover:bg-primary/90">
                                    <i class="fas fa-upload mr-2"></i>استيراد
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Bulk Actions (Optional) -->
                <div class="mt-6 flex justify-between items-center">
                    <button onclick="openImportModal()" 
                            class="px-4 py-2 bg-white border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 transition-colors">
                        <i class="fas fa-upload mr-2"></i>
                        استيراد Flow
                    </button>

                    <div class="text-sm text-gray-500">
                        عرض <?php echo e($flows->count()); ?> من <?php echo e($flows->count()); ?>

                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        // Close dropdown when clicking outside
        document.addEventListener('click', function(e) {
            if (!e.target.closest('[id^="dropdown-btn-"]')) {
                document.querySelectorAll('[id^="dropdown-"]').forEach(dropdown => {
                    dropdown.classList.add('hidden');
                });
            }
        });

        // Toggle Dropdown
        function toggleDropdown(flowId) {
            event.stopPropagation();
            const dropdown = document.getElementById(`dropdown-${flowId}`);
            
            // Close all other dropdowns
            document.querySelectorAll('[id^="dropdown-"]').forEach(d => {
                if (d.id !== `dropdown-${flowId}`) {
                    d.classList.add('hidden');
                }
            });
            
            dropdown.classList.toggle('hidden');
        }

        // Toggle Flow Active Status
        function toggleFlow(flowId, button) {
            if (!confirm('هل تريد تغيير حالة هذا الـFlow؟')) return;
            
            const icon = button.querySelector('i');
            icon.className = 'fas fa-spinner fa-spin';
            button.disabled = true;
            
            fetch(`/messenger-flows/${flowId}/toggle`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ');
                    icon.className = 'fas fa-power-off';
                    button.disabled = false;
                }
            })
            .catch(error => {
                alert('حدث خطأ في الاتصال');
                icon.className = 'fas fa-power-off';
                button.disabled = false;
            });
        }

        // Delete Flow
        function deleteFlow(flowId) {
            if (!confirm('هل أنت متأكد من حذف هذا الـFlow؟\n\nلا يمكن التراجع عن هذا الإجراء.')) return;
            
            fetch(`/messenger-flows/${flowId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ');
                }
            })
            .catch(error => {
                alert('حدث خطأ في الاتصال');
            });
        }

        // Duplicate Flow
        function duplicateFlow(flowId) {
            if (!confirm('هل تريد نسخ هذا الـFlow؟')) return;
            
            fetch(`/messenger-flows/${flowId}/duplicate`, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('حدث خطأ');
                }
            })
            .catch(error => {
                alert('حدث خطأ في الاتصال');
            });
        }

        // Filter Flows
        function filterFlows() {
            const searchTerm = document.getElementById('searchInput').value.toLowerCase();
            const statusFilter = document.getElementById('statusFilter').value;
            const flowCards = document.querySelectorAll('.flow-card');
            let visibleCount = 0;

            flowCards.forEach(card => {
                const name = card.dataset.name;
                const status = card.dataset.status;
                
                const matchesSearch = name.includes(searchTerm);
                const matchesStatus = statusFilter === 'all' || status === statusFilter;
                
                if (matchesSearch && matchesStatus) {
                    card.style.display = 'block';
                    visibleCount++;
                } else {
                    card.style.display = 'none';
                }
            });

            // Show/hide no results message
            const noResults = document.getElementById('noResults');
            const flowsGrid = document.getElementById('flowsGrid');
            
            if (visibleCount === 0) {
                flowsGrid.style.display = 'none';
                noResults.classList.remove('hidden');
            } else {
                flowsGrid.style.display = 'grid';
                noResults.classList.add('hidden');
            }
        }

        // Sort Flows
        function sortFlows() {
            const sortBy = document.getElementById('sortBy').value;
            const flowsGrid = document.getElementById('flowsGrid');
            const flowCards = Array.from(document.querySelectorAll('.flow-card'));

            flowCards.sort((a, b) => {
                switch(sortBy) {
                    case 'name':
                        return a.dataset.name.localeCompare(b.dataset.name);
                    case 'executions':
                        return parseInt(b.dataset.executions) - parseInt(a.dataset.executions);
                    case 'priority':
                        return parseInt(b.dataset.priority) - parseInt(a.dataset.priority);
                    case 'recent':
                    default:
                        return parseInt(b.dataset.created) - parseInt(a.dataset.created);
                }
            });

            flowCards.forEach(card => flowsGrid.appendChild(card));
        }

        // Import Modal Functions
        function openImportModal() {
            document.getElementById('importModal').classList.remove('hidden');
        }

        function closeImportModal() {
            document.getElementById('importModal').classList.add('hidden');
            document.getElementById('importForm').reset();
            document.getElementById('fileName').textContent = '';
        }

        function handleFileSelect(input) {
            const file = input.files[0];
            if (file) {
                document.getElementById('fileName').textContent = `📄 ${file.name}`;
            }
        }

        // Handle Import Form Submit
        document.getElementById('importForm')?.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const submitBtn = this.querySelector('[type="submit"]');
            const originalText = submitBtn.innerHTML;
            
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>جاري الاستيراد...';
            submitBtn.disabled = true;
            
            fetch('/messenger-flows/import', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('تم استيراد الـFlow بنجاح!');
                    location.reload();
                } else {
                    alert(data.message || 'حدث خطأ أثناء الاستيراد');
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                }
            })
            .catch(error => {
                alert('حدث خطأ في الاتصال');
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            });
        });

        // Drag and drop for import
        const dropZone = document.querySelector('[onclick*="fileInput"]');
        if (dropZone) {
            ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
                dropZone.addEventListener(eventName, preventDefaults, false);
            });

            function preventDefaults(e) {
                e.preventDefault();
                e.stopPropagation();
            }

            ['dragenter', 'dragover'].forEach(eventName => {
                dropZone.addEventListener(eventName, () => {
                    dropZone.classList.add('border-indigo-500', 'bg-indigo-50');
                });
            });

            ['dragleave', 'drop'].forEach(eventName => {
                dropZone.addEventListener(eventName, () => {
                    dropZone.classList.remove('border-indigo-500', 'bg-indigo-50');
                });
            });

            dropZone.addEventListener('drop', function(e) {
                const files = e.dataTransfer.files;
                if (files.length > 0) {
                    document.getElementById('fileInput').files = files;
                    handleFileSelect(document.getElementById('fileInput'));
                }
            });
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/fast.rompure.com/fast.rompure.com/resources/views/messenger-flows/index.blade.php ENDPATH**/ ?>